/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.frame.XLoadable;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XModule;
import com.sun.star.frame.XStorable;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.task.XStatusIndicatorFactory;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.DateTime;
import com.sun.star.util.XModifiable;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XRefreshable;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.ViewHandler;
import java.util.GregorianCalendar;

public class TextDocument {
    public XComponent xComponent;
    public XTextDocument xTextDocument;
    public XNumberFormats NumberFormats;
    public XDocumentProperties m_xDocProps;
    public XStatusIndicator xProgressBar;
    public XFrame xFrame;
    public XText xText;
    public XMultiServiceFactory xMSFDoc;
    public XMultiServiceFactory xMSF;
    public XNumberFormatsSupplier xNumberFormatsSupplier;
    public XWindowPeer xWindowPeer;
    public int PageWidth;
    public int ScaleWidth;
    public Size DocSize;
    public Rectangle PosSize;
    public Locale CharLocale;
    public XStorable xStorable;

    public TextDocument(XMultiServiceFactory xMSF, XTerminateListener listener, String FrameName) {
        this.xMSF = xMSF;
        this.xFrame = OfficeDocument.createNewFrame(xMSF, listener, FrameName);
    }

    public TextDocument(XMultiServiceFactory xMSF, String _sPreviewURL, boolean bShowStatusIndicator, XTerminateListener listener) {
        this.xMSF = xMSF;
        this.xFrame = OfficeDocument.createNewFrame(xMSF, listener);
        this.xTextDocument = this.loadAsPreview(_sPreviewURL, true);
        this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xTextDocument);
        if (bShowStatusIndicator) {
            this.showStatusIndicator();
        }
        this.init();
    }

    public TextDocument(XMultiServiceFactory xMSF, boolean bShowStatusIndicator, XTerminateListener listener) {
        this.xMSF = xMSF;
        XDesktop xDesktop = Desktop.getDesktop(xMSF);
        XFramesSupplier xFrameSupplier = (XFramesSupplier)UnoRuntime.queryInterface(XFramesSupplier.class, (Object)xDesktop);
        this.xFrame = xFrameSupplier.getActiveFrame();
        this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xFrame.getController().getModel());
        this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.xComponent);
        if (bShowStatusIndicator) {
            this.showStatusIndicator();
        }
        this.init();
    }

    public TextDocument(XMultiServiceFactory xMSF, ModuleIdentifier _moduleIdentifier, boolean bShowStatusIndicator) {
        this.xMSF = xMSF;
        try {
            this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xMSF.createInstance("com.sun.star.text.TextDocument"));
            XLoadable xLoadable = (XLoadable)UnoRuntime.queryInterface(XLoadable.class, (Object)this.xTextDocument);
            xLoadable.initNew();
            XModule xModule = (XModule)UnoRuntime.queryInterface(XModule.class, (Object)this.xTextDocument);
            xModule.setIdentifier(_moduleIdentifier.getIdentifier());
            XDesktop xDesktop = Desktop.getDesktop(xMSF);
            XComponentLoader xLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xDesktop);
            PropertyValue[] loadArgs = new PropertyValue[]{new PropertyValue("Model", -1, (Object)this.xTextDocument, PropertyState.DIRECT_VALUE)};
            xLoader.loadComponentFromURL("private:object", "_blank", 0, loadArgs);
            this.xFrame = this.xTextDocument.getCurrentController().getFrame();
            this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xTextDocument);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bShowStatusIndicator) {
            this.showStatusIndicator();
        }
        this.init();
    }

    public TextDocument(XMultiServiceFactory xMSF, XTextDocument _textDocument, boolean bshowStatusIndicator) {
        this.xMSF = xMSF;
        this.xFrame = _textDocument.getCurrentController().getFrame();
        this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)_textDocument);
        this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.xComponent);
        if (bshowStatusIndicator) {
            XStatusIndicatorFactory xStatusIndicatorFactory = (XStatusIndicatorFactory)UnoRuntime.queryInterface(XStatusIndicatorFactory.class, (Object)this.xFrame);
            this.xProgressBar = xStatusIndicatorFactory.createStatusIndicator();
            this.xProgressBar.start(PropertyNames.EMPTY_STRING, 100);
            this.xProgressBar.setValue(5);
        }
        this.xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.xFrame.getComponentWindow());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
        this.xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)this.xTextDocument);
        XDocumentPropertiesSupplier xDocPropsSuppl = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.xTextDocument);
        this.m_xDocProps = xDocPropsSuppl.getDocumentProperties();
        this.CharLocale = (Locale)Helper.getUnoStructValue(this.xComponent, "CharLocale");
        this.xText = this.xTextDocument.getText();
    }

    private void init() {
        this.xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.xFrame.getComponentWindow());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
        this.xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)this.xTextDocument);
        XDocumentPropertiesSupplier xDocPropsSuppl = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.xTextDocument);
        this.m_xDocProps = xDocPropsSuppl.getDocumentProperties();
        this.CharLocale = (Locale)Helper.getUnoStructValue(this.xComponent, "CharLocale");
        this.xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xTextDocument);
        this.xText = this.xTextDocument.getText();
    }

    private void showStatusIndicator() {
        XStatusIndicatorFactory xStatusIndicatorFactory = (XStatusIndicatorFactory)UnoRuntime.queryInterface(XStatusIndicatorFactory.class, (Object)this.xFrame);
        this.xProgressBar = xStatusIndicatorFactory.createStatusIndicator();
        this.xProgressBar.start(PropertyNames.EMPTY_STRING, 100);
        this.xProgressBar.setValue(5);
    }

    public XTextDocument loadAsPreview(String sDefaultTemplate, boolean asTemplate) {
        PropertyValue[] loadValues = new PropertyValue[3];
        loadValues[0] = new PropertyValue();
        loadValues[0].Name = PropertyNames.READ_ONLY;
        loadValues[0].Value = Boolean.TRUE;
        loadValues[1] = new PropertyValue();
        loadValues[1].Name = "AsTemplate";
        loadValues[1].Value = asTemplate ? Boolean.TRUE : Boolean.FALSE;
        loadValues[2] = new PropertyValue();
        loadValues[2].Name = "Preview";
        loadValues[2].Value = Boolean.TRUE;
        if (this.xTextDocument != null) {
            try {
                XModifiable xModi = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)this.xTextDocument);
                xModi.setModified(false);
            }
            catch (PropertyVetoException e1) {
                e1.printStackTrace(System.err);
            }
        }
        Object oDoc = OfficeDocument.load((XInterface)this.xFrame, sDefaultTemplate, "_self", loadValues);
        this.xTextDocument = (XTextDocument)oDoc;
        this.DocSize = this.getPageSize();
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
        ViewHandler myViewHandler = new ViewHandler(this.xMSFDoc, this.xTextDocument);
        try {
            myViewHandler.setViewSetting("ZoomType", new Short(2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TextFieldHandler myFieldHandler = new TextFieldHandler(this.xMSF, this.xTextDocument);
        myFieldHandler.updateDocInfoFields();
        return this.xTextDocument;
    }

    public Size getPageSize() {
        try {
            XStyleFamiliesSupplier xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.xTextDocument);
            XNameAccess xNameAccess = null;
            xNameAccess = xStyleFamiliesSupplier.getStyleFamilies();
            XNameContainer xPageStyleCollection = null;
            xPageStyleCollection = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xNameAccess.getByName("PageStyles"));
            XStyle xPageStyle = (XStyle)UnoRuntime.queryInterface(XStyle.class, (Object)xPageStyleCollection.getByName("First Page"));
            return (Size)Helper.getUnoPropertyValue(xPageStyle, "Size");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public TextDocument(XMultiServiceFactory xMSF, String URL2, PropertyValue[] xArgs, XTerminateListener listener) {
        this.xMSF = xMSF;
        XDesktop xDesktop = Desktop.getDesktop(xMSF);
        this.xFrame = OfficeDocument.createNewFrame(xMSF, listener);
        Object oDoc = OfficeDocument.load((XInterface)this.xFrame, URL2, "_self", xArgs);
        this.xTextDocument = (XTextDocument)oDoc;
        this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xTextDocument);
        XWindow xWindow = this.xFrame.getComponentWindow();
        this.xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.xFrame.getComponentWindow());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
        this.xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)this.xTextDocument);
        XDocumentPropertiesSupplier xDocPropsSuppl = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.xTextDocument);
        this.m_xDocProps = xDocPropsSuppl.getDocumentProperties();
        this.CharLocale = (Locale)Helper.getUnoStructValue(this.xComponent, "CharLocale");
    }

    public static XTextCursor createTextCursor(Object oCursorContainer) {
        XSimpleText xText = (XSimpleText)UnoRuntime.queryInterface(XSimpleText.class, (Object)oCursorContainer);
        return xText.createTextCursor();
    }

    public int getCharWidth(String ScaleString) {
        int iScale = 200;
        this.xTextDocument.lockControllers();
        int iScaleLen = ScaleString.length();
        XTextCursor xTextCursor = TextDocument.createTextCursor(this.xTextDocument.getText());
        xTextCursor.gotoStart(false);
        Helper.setUnoPropertyValue(xTextCursor, "PageDescName", "First Page");
        xTextCursor.setString(ScaleString);
        XTextViewCursorSupplier xViewCursor = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)this.xTextDocument.getCurrentController());
        XTextViewCursor xTextViewCursor = xViewCursor.getViewCursor();
        xTextViewCursor.gotoStart(false);
        int iFirstPos = xTextViewCursor.getPosition().X;
        xTextViewCursor.gotoEnd(false);
        int iLastPos = xTextViewCursor.getPosition().X;
        iScale = (iLastPos - iFirstPos) / iScaleLen;
        xTextCursor.gotoStart(false);
        xTextCursor.gotoEnd(true);
        xTextCursor.setString(PropertyNames.EMPTY_STRING);
        this.unlockallControllers();
        return iScale;
    }

    public void unlockallControllers() {
        while (this.xTextDocument.hasControllersLocked()) {
            this.xTextDocument.unlockControllers();
        }
    }

    public void refresh() {
        XRefreshable xRefreshable = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)this.xTextDocument);
        xRefreshable.refresh();
    }

    public void setWizardTemplateDocInfo(String WizardName, String TemplateDescription) {
        try {
            Object uD = Configuration.getConfigurationRoot(this.xMSF, "/org.openoffice.UserProfile/Data", false);
            XNameAccess xNA = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)uD);
            Object gn = xNA.getByName("givenname");
            Object sn = xNA.getByName("sn");
            String fullname = gn + PropertyNames.SPACE + sn;
            GregorianCalendar cal = new GregorianCalendar();
            int year = cal.get(1);
            int month = cal.get(2);
            int day = cal.get(5);
            DateTime currentDate = new DateTime();
            currentDate.Day = (short)day;
            currentDate.Month = (short)month;
            currentDate.Year = (short)year;
            Helper.DateUtils du = new Helper.DateUtils(this.xMSF, this.xTextDocument);
            int ff = du.getFormat((short)20);
            String myDate = du.format(ff, currentDate);
            XDocumentPropertiesSupplier xDocPropsSuppl = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.xTextDocument);
            XDocumentProperties xDocProps2 = xDocPropsSuppl.getDocumentProperties();
            xDocProps2.setAuthor(fullname);
            xDocProps2.setModifiedBy(fullname);
            String description = xDocProps2.getDescription();
            description = description + PropertyNames.SPACE + TemplateDescription;
            description = JavaTools.replaceSubString(description, WizardName, "<wizard_name>");
            description = JavaTools.replaceSubString(description, myDate, "<current_date>");
            xDocProps2.setDescription(description);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        catch (WrappedTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean removeTextContent(Object oTextContent) {
        try {
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)oTextContent);
            this.xText.removeTextContent(xTextContent);
            return true;
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    public static int getPageCount(Object model) {
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)model);
        XController xController = xModel.getCurrentController();
        XTextViewCursorSupplier xTextVCS = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)xController);
        XTextViewCursor xTextVC = xTextVCS.getViewCursor();
        XPageCursor xPC = (XPageCursor)UnoRuntime.queryInterface(XPageCursor.class, (Object)xTextVC);
        xPC.jumpToLastPage();
        return xPC.getPage();
    }

    public static class ModuleIdentifier {
        private String m_identifier;

        protected final String getIdentifier() {
            return this.m_identifier;
        }

        public ModuleIdentifier(String _identifier) {
            this.m_identifier = _identifier;
        }
    }
}

