/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.SectionFileLink;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;

public class TextSectionHandler {
    public XTextSectionsSupplier xTextSectionsSupplier;
    private XMultiServiceFactory xMSFDoc;
    private XTextDocument xTextDocument;
    private XText xText;

    public TextSectionHandler(XMultiServiceFactory xMSF, XTextDocument xTextDocument) {
        this.xMSFDoc = xMSF;
        this.xTextDocument = xTextDocument;
        this.xText = xTextDocument.getText();
        this.xTextSectionsSupplier = (XTextSectionsSupplier)UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)xTextDocument);
    }

    public void removeTextSectionbyName(String SectionName) {
        try {
            XNameAccess xAllTextSections = this.xTextSectionsSupplier.getTextSections();
            if (xAllTextSections.hasByName(SectionName)) {
                Object oTextSection = this.xTextSectionsSupplier.getTextSections().getByName(SectionName);
                this.removeTextSection(oTextSection);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public boolean hasTextSectionByName(String SectionName) {
        XNameAccess xAllTextSections = this.xTextSectionsSupplier.getTextSections();
        return xAllTextSections.hasByName(SectionName);
    }

    public void removeLastTextSection() {
        try {
            XIndexAccess xAllTextSections = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextSectionsSupplier.getTextSections());
            Object oTextSection = xAllTextSections.getByIndex(xAllTextSections.getCount() - 1);
            this.removeTextSection(oTextSection);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void removeTextSection(Object _oTextSection) {
        try {
            XTextContent xTextContentTextSection = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)_oTextSection);
            this.xText.removeTextContent(xTextContentTextSection);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void removeInvisibleTextSections() {
        try {
            XIndexAccess xAllTextSections = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextSectionsSupplier.getTextSections());
            int TextSectionCount = xAllTextSections.getCount();
            for (int i = TextSectionCount - 1; i >= 0; --i) {
                boolean bRemoveTextSection;
                XTextContent xTextContentTextSection = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xAllTextSections.getByIndex(i));
                XPropertySet xTextSectionPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextContentTextSection);
                boolean bl = bRemoveTextSection = !AnyConverter.toBoolean((Object)xTextSectionPropertySet.getPropertyValue("IsVisible"));
                if (!bRemoveTextSection) continue;
                this.xText.removeTextContent(xTextContentTextSection);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void removeAllTextSections() {
        try {
            XIndexAccess xAllTextSections = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextSectionsSupplier.getTextSections());
            int TextSectionCount = xAllTextSections.getCount();
            for (int i = TextSectionCount - 1; i >= 0; --i) {
                XTextContent xTextContentTextSection = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xAllTextSections.getByIndex(i));
                XPropertySet xTextSectionPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextContentTextSection);
                this.xText.removeTextContent(xTextContentTextSection);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void breakLinkofTextSections() {
        try {
            XIndexAccess xAllTextSections = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextSectionsSupplier.getTextSections());
            int iSectionCount = xAllTextSections.getCount();
            SectionFileLink oSectionLink = new SectionFileLink();
            oSectionLink.FileURL = PropertyNames.EMPTY_STRING;
            for (int i = 0; i < iSectionCount; ++i) {
                Object oTextSection = xAllTextSections.getByIndex(i);
                Helper.setUnoPropertyValues(oTextSection, new String[]{"FileLink", "LinkRegion"}, new Object[]{oSectionLink, PropertyNames.EMPTY_STRING});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void breakLinkOfTextSection(Object oTextSection) {
        SectionFileLink oSectionLink = new SectionFileLink();
        oSectionLink.FileURL = PropertyNames.EMPTY_STRING;
        Helper.setUnoPropertyValues(oTextSection, new String[]{"FileLink", "LinkRegion"}, new Object[]{oSectionLink, PropertyNames.EMPTY_STRING});
    }

    public void linkSectiontoTemplate(String TemplateName, String SectionName) {
        try {
            Object oTextSection = this.xTextSectionsSupplier.getTextSections().getByName(SectionName);
            this.linkSectiontoTemplate(oTextSection, TemplateName, SectionName);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void linkSectiontoTemplate(Object oTextSection, String TemplateName, String SectionName) {
        SectionFileLink oSectionLink = new SectionFileLink();
        oSectionLink.FileURL = TemplateName;
        Helper.setUnoPropertyValues(oTextSection, new String[]{"FileLink", "LinkRegion"}, new Object[]{oSectionLink, SectionName});
        XNamed xSectionName = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)oTextSection);
        String NewSectionName = xSectionName.getName();
        if (NewSectionName.compareTo(SectionName) != 0) {
            xSectionName.setName(SectionName);
        }
    }

    public void insertTextSection(String GroupName, String TemplateName, boolean _bAddParagraph) {
        try {
            if (_bAddParagraph) {
                XTextCursor xTextCursor = this.xText.createTextCursor();
                this.xText.insertControlCharacter((XTextRange)xTextCursor, (short)0, false);
                xTextCursor.collapseToEnd();
            }
            XTextCursor xSecondTextCursor = this.xText.createTextCursor();
            xSecondTextCursor.gotoEnd(false);
            this.insertTextSection(GroupName, TemplateName, xSecondTextCursor);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(System.err);
        }
    }

    public void insertTextSection(String sectionName, String templateName, XTextCursor position) {
        try {
            Object xTextSection;
            if (this.xTextSectionsSupplier.getTextSections().hasByName(sectionName)) {
                xTextSection = this.xTextSectionsSupplier.getTextSections().getByName(sectionName);
            } else {
                xTextSection = this.xMSFDoc.createInstance("com.sun.star.text.TextSection");
                XTextContent xTextContentSection = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xTextSection);
                position.getText().insertTextContent((XTextRange)position, xTextContentSection, false);
            }
            this.linkSectiontoTemplate(xTextSection, templateName, sectionName);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

