/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XViewSettingsSupplier;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.text.TextTableHandler;

public class ViewHandler {
    private XTextViewCursorSupplier xTextViewCursorSupplier;
    private XMultiServiceFactory xMSFDoc;
    private XTextDocument xTextDocument;
    private XStyleFamiliesSupplier xStyleFamiliesSupplier;
    private XViewSettingsSupplier xViewSettingsSupplier;

    public ViewHandler(XMultiServiceFactory xMSF, XTextDocument xTextDocument) {
        this.xMSFDoc = xMSF;
        this.xTextDocument = xTextDocument;
        this.xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)xTextDocument.getCurrentController());
        this.xViewSettingsSupplier = (XViewSettingsSupplier)UnoRuntime.queryInterface(XViewSettingsSupplier.class, (Object)xTextDocument.getCurrentController());
        this.xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)xTextDocument);
    }

    public void selectFirstPage(TextTableHandler oTextTableHandler) {
        try {
            XPageCursor xPageCursor = (XPageCursor)UnoRuntime.queryInterface(XPageCursor.class, (Object)this.xTextViewCursorSupplier.getViewCursor());
            XTextCursor xViewTextCursor = (XTextCursor)UnoRuntime.queryInterface(XTextCursor.class, (Object)xPageCursor);
            xPageCursor.jumpToFirstPage();
            xPageCursor.jumpToStartOfPage();
            Helper.setUnoPropertyValue(xPageCursor, "PageDescName", "First Page");
            Object oPageStyles = this.xStyleFamiliesSupplier.getStyleFamilies().getByName("PageStyles");
            XNameAccess xName = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)oPageStyles);
            Object oPageStyle = xName.getByName("First Page");
            XIndexAccess xAllTextTables = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)oTextTableHandler.xTextTablesSupplier.getTextTables());
            XTextContent xTextTable = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xAllTextTables.getByIndex(0));
            XTextRange xRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xTextTable.getAnchor().getText());
            xViewTextCursor.gotoRange(xRange, false);
            XTextRange xHeaderRange = (XTextRange)Helper.getUnoPropertyValue(oPageStyle, "HeaderText", XTextRange.class);
            if (!AnyConverter.isVoid((Object)xHeaderRange)) {
                xViewTextCursor.gotoRange(xHeaderRange, false);
                xViewTextCursor.collapseToStart();
            } else {
                System.out.println("No Headertext available");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void setViewSetting(String Setting, Object Value2) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.xViewSettingsSupplier.getViewSettings().setPropertyValue(Setting, Value2);
    }

    public void collapseViewCursorToStart() {
        XTextViewCursor xTextViewCursor = this.xTextViewCursorSupplier.getViewCursor();
        xTextViewCursor.collapseToStart();
    }
}

