/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XListBox;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.HelpIds;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.TerminateWizardException;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.QueryMetaData;
import com.sun.star.wizards.ui.FieldSelection;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.WizardDialog;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandFieldSelection
extends FieldSelection
implements Comparator<String> {
    private CommandMetaData CurDBMetaData;
    private XListBox xTableListBox;
    private XFixedText xlblTable;
    private String sTableListBoxName;
    private String sTableLabelName;
    private String sQueryPrefix;
    private String sTablePrefix;
    private short m_iSelPos = (short)-1;
    private short iOldSelPos = (short)-1;
    private boolean bpreselectCommand = true;
    private boolean bgetQueries;
    private WizardDialog oWizardDialog;
    private Collator aCollator = null;

    public CommandFieldSelection(WizardDialog _CurUnoDialog, CommandMetaData _CurDBMetaData, int iStep, int _iHeight, String _reslblFields, String _reslblSelFields, String _reslblTables, boolean _bgetQueries, int _ifirstHID) {
        super(_CurUnoDialog, iStep, 95, 57, 210, _iHeight, _reslblFields, _reslblSelFields, _ifirstHID + 1, true);
        this.insertControls(_CurDBMetaData, _bgetQueries, _reslblTables);
        this.oWizardDialog = (WizardDialog)this.CurUnoDialog;
    }

    public CommandFieldSelection(UnoDialog _CurUnoDialog, CommandMetaData _CurDBMetaData, int _iHeight, String _reslblFields, String _reslblSelFields, String _reslblTables, boolean _bgetQueries, int _ifirstHID) {
        super(_CurUnoDialog, 1, 95, 57, 210, _iHeight, _reslblFields, _reslblSelFields, _ifirstHID + 1, true);
        this.insertControls(_CurDBMetaData, _bgetQueries, _reslblTables);
        this.oWizardDialog = (WizardDialog)this.CurUnoDialog;
    }

    private void insertControls(CommandMetaData _CurDBMetaData, boolean _bgetQueries, String _reslblTables) {
        try {
            this.AppendMode = !_bgetQueries;
            this.bgetQueries = _bgetQueries;
            this.CurDBMetaData = _CurDBMetaData;
            this.toggleListboxControls(Boolean.FALSE);
            this.sTableLabelName = "lblTables_" + this.sIncSuffix;
            this.sTableListBoxName = "lstTables_" + this.sIncSuffix;
            this.sTablePrefix = this.getTablePrefix();
            this.sQueryPrefix = this.getQueryPrefix();
            Integer LabelWidth = new Integer(this.getListboxWidth() + 6);
            this.xlblTable = this.CurUnoDialog.insertLabel(this.sTableLabelName, new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{Boolean.FALSE, 8, _reslblTables, 95, 27, this.IStep, new Short(3), LabelWidth});
            this.xTableListBox = this.CurUnoDialog.insertListBox(this.sTableListBoxName, 0, null, new ItemListenerImpl(), new String[]{"Dropdown", PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, "LineCount", PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{Boolean.TRUE, Boolean.FALSE, 12, HelpIds.getHelpIdString(this.FirstHelpIndex - 1), new Short(UnoDialog.getListBoxLineCount()), 95, 37, this.IStep, new Short(4), this.getListboxWidth()});
            this.fillupCommandListBox();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public String getQueryPrefix() {
        if (this.sQueryPrefix == null) {
            this.sQueryPrefix = this.CurUnoDialog.m_oResource.getResText(2322);
        }
        return this.sQueryPrefix;
    }

    private String getCommandPrefix(int _nCommandType) {
        if (_nCommandType == 0) {
            return this.getTablePrefix();
        }
        if (_nCommandType == 1) {
            return this.getQueryPrefix();
        }
        return PropertyNames.EMPTY_STRING;
    }

    public String getTablePrefix() {
        if (this.sTablePrefix == null) {
            this.sTablePrefix = this.CurUnoDialog.m_oResource.getResText(2321);
        }
        return this.sTablePrefix;
    }

    private short getselectedItemPos() {
        String[] sItemList;
        short[] iSelPoses = (short[])Helper.getUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.SELECTED_ITEMS);
        if (iSelPoses.length > 0) {
            return iSelPoses[0];
        }
        if (this.bpreselectCommand && (sItemList = (String[])Helper.getUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.STRING_ITEM_LIST)).length > 0) {
            return 0;
        }
        return -1;
    }

    public void fillUpFieldsListbox() {
        try {
            boolean binitialize = false;
            String curCommandName = PropertyNames.EMPTY_STRING;
            short iSelPos = this.getselectedItemPos();
            String sSelectedTableName = this.xTableListBox.getItem(iSelPos);
            if (!this.bgetQueries) {
                curCommandName = sSelectedTableName;
                this.CurDBMetaData.setTableByName(curCommandName);
                binitialize = this.CurDBMetaData.getFieldNamesOfCommand(curCommandName, 0, this.AppendMode);
            } else if (sSelectedTableName.startsWith(this.sTablePrefix)) {
                this.CurDBMetaData.setCommandType(0);
                curCommandName = JavaTools.replaceSubString(sSelectedTableName, PropertyNames.EMPTY_STRING, this.sTablePrefix);
                this.CurDBMetaData.setTableByName(curCommandName);
                binitialize = this.CurDBMetaData.getFieldNamesOfCommand(curCommandName, 0, this.AppendMode);
            } else {
                this.CurDBMetaData.setCommandType(1);
                curCommandName = JavaTools.replaceSubString(sSelectedTableName, PropertyNames.EMPTY_STRING, this.sQueryPrefix);
                this.CurDBMetaData.setQueryByName(curCommandName);
                binitialize = this.CurDBMetaData.getFieldNamesOfCommand(curCommandName, 1, this.AppendMode);
            }
            if (binitialize) {
                this.CurDBMetaData.setCommandName(curCommandName);
                if (this.CurDBMetaData.m_aAllFieldNames != null && this.CurDBMetaData.m_aAllFieldNames.length > 0) {
                    this.initialize(this.CurDBMetaData.m_aAllFieldNames, this.AppendMode, this.CurDBMetaData.getMaxColumnsInSelect());
                    return;
                }
            }
            this.emptyFieldsListBoxes();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private short fillupCommandListBox() throws TerminateWizardException {
        short[] iSelArray = new short[]{};
        boolean bgetFields = false;
        String[] ContentList = new String[]{};
        if (this.bgetQueries) {
            ContentList = new String[this.CurDBMetaData.getTableNames().length + this.CurDBMetaData.getQueryNames().length];
            System.arraycopy(this.CurDBMetaData.getQueryNames(), 0, ContentList, this.CurDBMetaData.getTableNames().length, this.CurDBMetaData.getQueryNames().length);
            ContentList = this.setPrefixinArray(ContentList, this.sQueryPrefix, this.CurDBMetaData.getTableNames().length, this.CurDBMetaData.getQueryNames().length);
        } else {
            ContentList = new String[this.CurDBMetaData.getTableNames().length];
        }
        System.arraycopy(this.CurDBMetaData.getTableNames(), 0, ContentList, 0, this.CurDBMetaData.getTableNames().length);
        if (this.bgetQueries) {
            ContentList = this.setPrefixinArray(ContentList, this.sTablePrefix, 0, this.CurDBMetaData.getTableNames().length);
        }
        Arrays.sort(ContentList, this);
        Helper.setUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.STRING_ITEM_LIST, ContentList);
        short iSelPos = this.getselectedItemPos();
        if (this.bpreselectCommand) {
            if (iSelPos > -1) {
                bgetFields = true;
                iSelArray = new short[]{iSelPos};
            }
        } else {
            this.emptyFieldsListBoxes();
            iSelArray = new short[]{iSelPos};
        }
        Helper.setUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.SELECTED_ITEMS, iSelArray);
        this.toggleCommandListBox(true);
        if (bgetFields) {
            this.fillUpFieldsListbox();
        }
        return iSelPos;
    }

    private Collator getCollator() {
        if (this.aCollator == null) {
            Locale aOfficeLocale = Configuration.getLocale(this.CurDBMetaData.xMSF);
            java.util.Locale aJavaLocale = new java.util.Locale(aOfficeLocale.Language, aOfficeLocale.Country, aOfficeLocale.Variant);
            this.aCollator = Collator.getInstance(aJavaLocale);
            this.aCollator.setStrength(2);
        }
        return this.aCollator;
    }

    @Override
    public int compare(String _oObject1, String _oObject2) {
        return this.getCollator().compare(_oObject1, _oObject2);
    }

    private String[] setPrefixinArray(String[] _ContentList, String _sprefix, int _startindex, int _nlen) {
        for (int i = _startindex; i < _startindex + _nlen; ++i) {
            _ContentList[i] = _sprefix + _ContentList[i];
        }
        return _ContentList;
    }

    public void toggleCommandListBox(String[] _NewItems) {
        boolean bdoenable = QueryMetaData.getIncludedCommandNames(_NewItems).length < this.CurDBMetaData.getMaxTablesInSelect();
        this.toggleCommandListBox(bdoenable);
    }

    public void toggleCommandListBox(boolean _bdoenable) {
        Helper.setUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.PROPERTY_ENABLED, _bdoenable);
        Helper.setUnoPropertyValue(UnoDialog.getModel(this.xlblTable), PropertyNames.PROPERTY_ENABLED, _bdoenable);
    }

    public String getSelectedCommandName() {
        String sCommandname = this.xTableListBox.getSelectedItem();
        if (sCommandname.startsWith(this.sTablePrefix)) {
            return sCommandname.substring(this.sTablePrefix.length());
        }
        if (sCommandname.startsWith(this.sQueryPrefix)) {
            return sCommandname.substring(this.sQueryPrefix.length());
        }
        return sCommandname;
    }

    public int getSelectedCommandType() {
        String sCommandname = this.xTableListBox.getSelectedItem();
        if (sCommandname.startsWith(this.sTablePrefix)) {
            return 0;
        }
        return 1;
    }

    public void preselectCommand(PropertyValue[] _aPropertyValue, boolean _bReadOnly) {
        try {
            if (Properties.hasPropertyValue(_aPropertyValue, PropertyNames.COMMAND_TYPE)) {
                int nCommandType = AnyConverter.toInt((Object)Properties.getPropertyValue(_aPropertyValue, PropertyNames.COMMAND_TYPE));
                String sCommand = AnyConverter.toString((Object)Properties.getPropertyValue(_aPropertyValue, PropertyNames.COMMAND));
                if (sCommand != null) {
                    this.preselectCommand(sCommand, nCommandType, _bReadOnly);
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void preselectCommand(String _selitem, int _nCommandType, boolean _bReadOnly) {
        if (_selitem.length() > 0) {
            String sPrefix;
            String[] sitems = (String[])Helper.getUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.STRING_ITEM_LIST);
            short iselpos = (short)JavaTools.FieldInList(sitems, (sPrefix = this.getCommandPrefix(_nCommandType)) + _selitem);
            if (iselpos > -1) {
                Helper.setUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.SELECTED_ITEMS, new short[]{iselpos});
            }
            this.fillUpFieldsListbox();
        } else {
            Helper.setUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.SELECTED_ITEMS, new short[0]);
        }
        if (_bReadOnly) {
            Helper.setUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.READ_ONLY, _selitem.length() > 0);
        }
    }

    public void preselectCommand(String _selitem, boolean _bReadOnly) {
        if (_selitem.length() > 0) {
            String[] sitems = (String[])Helper.getUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.STRING_ITEM_LIST);
            short iselpos = (short)JavaTools.FieldInList(sitems, this.getTablePrefix() + _selitem);
            if (iselpos > -1) {
                Helper.setUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.SELECTED_ITEMS, new short[]{iselpos});
            }
            this.fillUpFieldsListbox();
        } else {
            Helper.setUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.SELECTED_ITEMS, new short[0]);
            this.fillUpFieldsListbox();
        }
        if (_bReadOnly) {
            Helper.setUnoPropertyValue(UnoDialog.getModel(this.xTableListBox), PropertyNames.READ_ONLY, _selitem.length() > 0);
        }
        this.toggleListboxButtons((short)-1, (short)-1);
    }

    class ItemListenerImpl
    implements XItemListener {
        ItemListenerImpl() {
        }

        public void itemStateChanged(ItemEvent EventObject2) {
            short[] SelItems = (short[])CommandFieldSelection.this.CurUnoDialog.getControlProperty(CommandFieldSelection.this.sTableListBoxName, PropertyNames.SELECTED_ITEMS);
            if (SelItems.length > 0) {
                CommandFieldSelection.this.iOldSelPos = CommandFieldSelection.this.m_iSelPos;
                CommandFieldSelection.this.m_iSelPos = SelItems[0];
                if (CommandFieldSelection.this.m_iSelPos > -1 && CommandFieldSelection.this.m_iSelPos != CommandFieldSelection.this.iOldSelPos) {
                    if (!CommandFieldSelection.this.AppendMode) {
                        CommandFieldSelection.this.oWizardDialog.enablefromStep(CommandFieldSelection.this.IStep + 1, false);
                    }
                    CommandFieldSelection.this.fillUpFieldsListbox();
                }
            }
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

