/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XFrame;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;

public class DocumentPreview {
    private XWindow xWindow;
    private XFrame xFrame;
    private XComponent xComponent;
    private XControl xControl;
    private int step;
    private PropertyValue[] loadArgs;
    private String url;
    public static final int PREVIEW_MODE = 1;

    public DocumentPreview(XMultiServiceFactory xmsf, Object control) throws Exception {
        this.xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)control);
        this.createPreviewFrame(xmsf, this.xControl);
    }

    protected XComponent setDocument(String url_, String[] propNames, Object[] propValues) throws IllegalArgumentException, IOException, CloseVetoException {
        this.url = url_;
        Properties ps = new Properties();
        for (int i = 0; i < propNames.length; ++i) {
            ps.put(propNames[i], propValues[i]);
        }
        return this.setDocument(this.url, ps.getProperties());
    }

    protected XComponent setDocument(String url, PropertyValue[] lArgs) throws IllegalArgumentException, IOException, CloseVetoException {
        this.loadArgs = lArgs;
        XComponentLoader xCompLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.xFrame);
        this.xFrame.activate();
        this.xComponent = xCompLoader.loadComponentFromURL(url, "_self", 0, this.loadArgs);
        return this.xComponent;
    }

    public void reload(XMultiServiceFactory xmsf) throws IllegalArgumentException, IOException, CloseVetoException, com.sun.star.uno.Exception {
        this.closeFrame();
        this.createPreviewFrame(xmsf, this.xControl);
        this.setDocument(this.url, this.loadArgs);
    }

    private void closeFrame() throws CloseVetoException {
        if (this.xFrame != null) {
            ((XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.xFrame)).close(false);
        }
    }

    public XComponent setDocument(String url, int mode) throws IllegalArgumentException, IOException, CloseVetoException {
        switch (mode) {
            case 1: {
                return this.setDocument(url, new String[]{"Preview", PropertyNames.READ_ONLY}, new Object[]{Boolean.TRUE, Boolean.TRUE});
            }
        }
        return null;
    }

    public void createPreviewFrame(XMultiServiceFactory xmsf, XControl xControl) throws com.sun.star.uno.Exception, IllegalArgumentException {
        XWindowPeer controlPeer = xControl.getPeer();
        XWindow controlWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xControl);
        Rectangle r = controlWindow.getPosSize();
        Object toolkit = xmsf.createInstance("com.sun.star.awt.Toolkit");
        XToolkit xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)toolkit);
        WindowDescriptor aDescriptor = new WindowDescriptor();
        aDescriptor.Type = WindowClass.SIMPLE;
        aDescriptor.WindowServiceName = "window";
        aDescriptor.ParentIndex = (short)-1;
        aDescriptor.Parent = controlPeer;
        aDescriptor.Bounds = new Rectangle(0, 0, r.Width, r.Height);
        aDescriptor.WindowAttributes = 524289;
        XWindowPeer xPeer = xToolkit.createWindow(aDescriptor);
        this.xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xPeer);
        Object frame = xmsf.createInstance("com.sun.star.frame.Frame");
        this.xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)frame);
        this.xFrame.initialize(this.xWindow);
        this.xWindow.setVisible(true);
    }

    public void dispose() {
        try {
            this.closeFrame();
        }
        catch (CloseVetoException ex) {
            ex.printStackTrace();
        }
    }
}

