/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.KeyEvent;
import com.sun.star.awt.MouseEvent;
import com.sun.star.awt.Size;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XItemEventBroadcaster;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XKeyListener;
import com.sun.star.awt.XMouseListener;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.HelpIds;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.IRenderer;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.ui.PeerConfig;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.event.CommonListener;
import com.sun.star.wizards.ui.event.MethodInvocation;
import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ImageList
implements XItemEventBroadcaster,
ListDataListener {
    private XFixedText lblImageText;
    private XFixedText grbxSelectedImage;
    private XButton btnBack;
    private XButton btnNext;
    private XFixedText lblCounter;
    private XControl[] m_aImages;
    private boolean benabled = true;
    private UnoDialog2 oUnoDialog;
    private Size gap = new Size(4, 4);
    private int cols = 4;
    private int rows = 3;
    private Size imageSize = new Size(20, 20);
    private Size pos;
    private Size selectionGap = new Size(2, 2);
    private boolean showButtons = true;
    private Short step;
    private static final Short NO_BORDER = new Short(0);
    private boolean refreshOverNull = true;
    private int imageTextLines = 1;
    private boolean rowSelect = false;
    public int tabIndex;
    public Boolean scaleImages = Boolean.TRUE;
    public String name = "il";
    private int selected = -1;
    private int pageStart = 0;
    public int helpURL = 0;
    private CommonListener uiEventListener = new CommonListener();
    private IImageRenderer renderer;
    private ListModel listModel;
    public IRenderer counterRenderer = new SimpleCounterRenderer();
    private Object dialogModel;
    private ImageKeyListener imageKeyListener;
    private static final Integer BACKGROUND_COLOR = 0x1000000;
    private static final Short HIDE_PAGE = new Short(99);
    private static final Integer TRANSPARENT = new Integer(-1);
    private static final int LINE_HEIGHT = 8;
    private MethodInvocation METHOD_MOUSE_PRESSED;
    private Integer m_imageHeight;
    private Integer m_imageWidth;
    private static final String[] IMAGE_PROPS = new String[]{PropertyNames.PROPERTY_BORDER, "BackgroundColor", PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, "ScaleImage", PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tabstop", PropertyNames.PROPERTY_WIDTH};
    private Short m_tabIndex;
    private static final String[] MOVE_SELECTION = new String[]{PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP};
    private Object[] MOVE_SELECTION_VALS = new Object[3];
    private transient ArrayList<XItemListener> itemListenerList;

    public Size getImageSize() {
        return this.imageSize;
    }

    public void setImageSize(Size imageSize) {
        this.imageSize = imageSize;
    }

    public void create(UnoDialog2 dialog) {
        this.oUnoDialog = dialog;
        this.dialogModel = dialog.xDialogModel;
        int imageTextHeight = this.imageTextLines * 8;
        PeerConfig opeerConfig = new PeerConfig(dialog);
        this.MOVE_SELECTION_VALS[2] = this.step;
        XControl imgContainer = dialog.insertImage(this.name + "lblContainer", new String[]{"BackgroundColor", PropertyNames.PROPERTY_BORDER, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_WIDTH}, new Object[]{BACKGROUND_COLOR, new Short(1), new Integer((this.imageSize.Height + this.gap.Height) * this.rows + this.gap.Height + imageTextHeight + 1), new Integer(this.pos.Width), new Integer(this.pos.Height), this.step, new Integer((this.imageSize.Width + this.gap.Width) * this.cols + this.gap.Width)});
        opeerConfig.setPeerProperties(imgContainer, new String[]{"MouseTransparent"}, new Object[]{Boolean.TRUE});
        int selectionWidth = this.rowSelect ? (this.imageSize.Width + this.gap.Width) * this.cols - this.gap.Width + this.selectionGap.Width * 2 : this.imageSize.Width + this.selectionGap.Width * 2;
        this.grbxSelectedImage = dialog.insertLabel(this.name + "_grbxSelected", new String[]{"BackgroundColor", PropertyNames.PROPERTY_BORDER, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, "Tabstop", PropertyNames.PROPERTY_WIDTH}, new Object[]{TRANSPARENT, new Short(1), new Integer(this.imageSize.Height + this.selectionGap.Height * 2), 0, 0, this.step, Boolean.TRUE, new Integer(selectionWidth)});
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.grbxSelectedImage);
        xWindow.addMouseListener((XMouseListener)new OMouseListener());
        String[] pNames1 = new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tabstop", PropertyNames.PROPERTY_WIDTH};
        this.lblImageText = dialog.insertLabel(this.name + "_imageText", pNames1, new Object[]{new Integer(imageTextHeight), PropertyNames.EMPTY_STRING, new Integer(this.pos.Width + 1), new Integer(this.pos.Height + (this.imageSize.Height + this.gap.Height) * this.rows + this.gap.Height), this.step, new Short(0), Boolean.FALSE, new Integer(this.cols * (this.imageSize.Width + this.gap.Width) + this.gap.Width - 2)});
        if (this.showButtons) {
            Integer btnSize = 14;
            this.btnBack = dialog.insertButton(this.name + "_btnBack", "prevPage", this, pNames1, new Object[]{btnSize, HelpIds.getHelpIdString(this.helpURL++), new Integer(this.pos.Width), new Integer(this.pos.Height + (this.imageSize.Height + this.gap.Height) * this.rows + this.gap.Height + imageTextHeight + 1), this.step, new Short((short)(this.tabIndex + 1)), Boolean.TRUE, btnSize});
            this.btnNext = dialog.insertButton(this.name + "_btnNext", "nextPage", this, pNames1, new Object[]{btnSize, HelpIds.getHelpIdString(this.helpURL++), new Integer(this.pos.Width + (this.imageSize.Width + this.gap.Width) * this.cols + this.gap.Width - btnSize + 1), new Integer(this.pos.Height + (this.imageSize.Height + this.gap.Height) * this.rows + this.gap.Height + imageTextHeight + 1), this.step, new Short((short)(this.tabIndex + 2)), Boolean.TRUE, btnSize});
            this.lblCounter = dialog.insertLabel(this.name + "_lblCounter", pNames1, new Object[]{new Integer(8), PropertyNames.EMPTY_STRING, new Integer(this.pos.Width + btnSize + 1), new Integer(this.pos.Height + (this.imageSize.Height + this.gap.Height) * this.rows + this.gap.Height + imageTextHeight + (btnSize - 8) / 2), this.step, new Short(0), Boolean.FALSE, new Integer(this.cols * (this.imageSize.Width + this.gap.Width) + this.gap.Width - 2 * btnSize - 1)});
            Helper.setUnoPropertyValue(this.getModel(this.lblCounter), PropertyNames.PROPERTY_ALIGN, new Short(1));
            Helper.setUnoPropertyValue(this.getModel(this.btnBack), PropertyNames.PROPERTY_LABEL, "<");
            Helper.setUnoPropertyValue(this.getModel(this.btnNext), PropertyNames.PROPERTY_LABEL, ">");
        }
        this.imageKeyListener = new ImageKeyListener();
        this.m_tabIndex = new Short((short)this.tabIndex);
        this.m_aImages = new XControl[this.rows * this.cols];
        try {
            this.METHOD_MOUSE_PRESSED = new MethodInvocation("mousePressed", (Object)this, Object.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.m_imageHeight = new Integer(this.imageSize.Height);
        this.m_imageWidth = new Integer(this.imageSize.Width);
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                this.m_aImages[r * this.cols + c] = this.createImage(dialog, r, c);
            }
        }
        this.refreshImages();
        this.listModel.addListDataListener(this);
    }

    private XControl createImage(UnoDialog2 dialog, int _row, int _col) {
        String imageName = this.name + "_image" + (_row * this.cols + _col);
        XControl image = dialog.insertImage(imageName, IMAGE_PROPS, new Object[]{NO_BORDER, BACKGROUND_COLOR, this.m_imageHeight, HelpIds.getHelpIdString(this.helpURL++), new Integer(this.getImagePosX(_col)), new Integer(this.getImagePosY(_row)), this.scaleImages, this.step, this.m_tabIndex, Boolean.FALSE, this.m_imageWidth});
        XWindow win = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)image);
        win.addMouseListener((XMouseListener)this.uiEventListener);
        win.addKeyListener((XKeyListener)this.imageKeyListener);
        this.uiEventListener.add(imageName, "MPR", this.METHOD_MOUSE_PRESSED);
        return image;
    }

    private int getImagePosX(int col) {
        return this.pos.Width + col * (this.imageSize.Width + this.gap.Width) + this.gap.Width;
    }

    private int getImagePosY(int row) {
        return this.pos.Height + row * (this.imageSize.Height + this.gap.Height) + this.gap.Height;
    }

    private void refreshImages() {
        if (this.showButtons) {
            this.refreshCounterText();
        }
        this.hideSelection();
        if (this.refreshOverNull) {
            for (int i = 0; i < this.m_aImages.length; ++i) {
                this.setVisible(this.m_aImages[i], false);
            }
        }
        boolean focusable = true;
        for (int i = 0; i < this.m_aImages.length; ++i) {
            Object[] oResources = this.renderer.getImageUrls(this.getObjectFor(i));
            if (oResources == null) continue;
            if (oResources.length == 1) {
                Helper.setUnoPropertyValue(this.m_aImages[i].getModel(), PropertyNames.PROPERTY_IMAGEURL, oResources[0]);
            } else if (oResources.length == 2) {
                this.oUnoDialog.getPeerConfiguration().setImageUrl((Object)this.m_aImages[i].getModel(), oResources[0], oResources[1]);
            }
            Helper.setUnoPropertyValue(this.m_aImages[i].getModel(), "Tabstop", focusable ? Boolean.TRUE : Boolean.FALSE);
            if (this.refreshOverNull) {
                this.setVisible(this.m_aImages[i], true);
            }
            focusable = false;
        }
        this.refreshSelection();
    }

    private void refreshCounterText() {
        Helper.setUnoPropertyValue(this.getModel(this.lblCounter), PropertyNames.PROPERTY_LABEL, this.counterRenderer.render(new Counter(this.pageStart + 1, this.pageEnd(), this.listModel.getSize())));
    }

    private int pageEnd() {
        int i = this.pageStart + this.cols * this.rows;
        if (i > this.listModel.getSize() - 1) {
            return this.listModel.getSize();
        }
        return i;
    }

    private void refreshSelection() {
        if (this.selected < this.pageStart || this.selected >= this.pageStart + this.rows * this.cols) {
            this.hideSelection();
        } else {
            this.moveSelection(this.getImageIndexFor(this.selected));
        }
    }

    private void hideSelection() {
        Helper.setUnoPropertyValue(this.getModel(this.grbxSelectedImage), PropertyNames.PROPERTY_STEP, HIDE_PAGE);
        this.setVisible(this.grbxSelectedImage, false);
    }

    private void moveSelection(int image) {
        this.setVisible(this.grbxSelectedImage, false);
        int row = image / this.cols;
        int col = this.rowSelect ? 0 : image - row * this.cols;
        this.MOVE_SELECTION_VALS[0] = new Integer(this.getImagePosX(col) - this.selectionGap.Width);
        this.MOVE_SELECTION_VALS[1] = new Integer(this.getImagePosY(row) - this.selectionGap.Height);
        Helper.setUnoPropertyValues(this.getModel(this.grbxSelectedImage), MOVE_SELECTION, this.MOVE_SELECTION_VALS);
        if (((Number)Helper.getUnoPropertyValue(this.dialogModel, PropertyNames.PROPERTY_STEP)).shortValue() == this.step.shortValue()) {
            this.setVisible(this.grbxSelectedImage, true);
        }
        for (int i = 0; i < this.m_aImages.length; ++i) {
            if (i != image) {
                this.defocus(i);
                continue;
            }
            Helper.setUnoPropertyValue(this.m_aImages[image].getModel(), "Tabstop", Boolean.TRUE);
        }
    }

    private void setVisible(Object control, boolean visible) {
        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)control)).setVisible(visible);
    }

    private Object getObjectFor(int i) {
        int ii = this.getIndexFor(i);
        if (this.listModel.getSize() <= ii) {
            return null;
        }
        return this.listModel.getElementAt(ii);
    }

    private int getIndexFor(int i) {
        return this.pageStart + i;
    }

    private int getImageIndexFor(int i) {
        return i - this.pageStart;
    }

    public void contentsChanged(ListDataEvent event) {
    }

    public void intervalAdded(ListDataEvent event) {
        if (event.getIndex0() <= this.selected && event.getIndex1() <= this.selected) {
            this.selected += event.getIndex1() - event.getIndex0() + 1;
        }
        if (event.getIndex0() < this.pageStart || event.getIndex1() < this.pageStart + this.getRows() + this.getCols()) {
            this.refreshImages();
        }
    }

    public void intervalRemoved(ListDataEvent event) {
    }

    public synchronized void addItemListener(XItemListener listener) {
        if (this.itemListenerList == null) {
            this.itemListenerList = new ArrayList();
        }
        this.itemListenerList.add(listener);
    }

    public synchronized void removeItemListener(XItemListener listener) {
        if (this.itemListenerList != null) {
            this.itemListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireItemSelected() {
        ArrayList list;
        ImageList imageList = this;
        synchronized (imageList) {
            if (this.itemListenerList == null) {
                return;
            }
            list = (ArrayList)this.itemListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((XItemListener)list.get(i)).itemStateChanged(null);
        }
    }

    public int getCols() {
        return this.cols;
    }

    public Size getGap() {
        return this.gap;
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public Short getStep() {
        return this.step;
    }

    public int getPageStart() {
        return this.pageStart;
    }

    public Size getPos() {
        return this.pos;
    }

    public IImageRenderer getRenderer() {
        return this.renderer;
    }

    public int getRows() {
        return this.rows;
    }

    public int getSelected() {
        return this.selected;
    }

    public Size getSelectionGap() {
        return this.selectionGap;
    }

    public boolean isShowButtons() {
        return this.showButtons;
    }

    public void setCols(int i) {
        this.cols = i;
    }

    public void setGap(Size size) {
        this.gap = size;
    }

    public void setListModel(ListModel model) {
        this.listModel = model;
    }

    public void setStep(Short short1) {
        this.step = short1;
    }

    public void setPageStart(int i) {
        if (i == this.pageStart) {
            return;
        }
        this.pageStart = i;
        this.enableButtons();
        this.refreshImages();
    }

    public void setPos(Size size) {
        this.pos = size;
    }

    public void setRenderer(IImageRenderer renderer) {
        this.renderer = renderer;
    }

    public void setRows(int i) {
        this.rows = i;
    }

    public void setSelected(int i) {
        if (this.rowSelect && i >= 0) {
            i = i / this.cols * this.cols;
        }
        if (this.selected == i) {
            return;
        }
        this.selected = i;
        this.refreshImageText();
        this.refreshSelection();
        this.fireItemSelected();
    }

    public void setSelected(Object object) {
        if (object == null) {
            this.setSelected(-1);
        } else {
            for (int i = 0; i < this.getListModel().getSize(); ++i) {
                if (!this.getListModel().getElementAt(i).equals(object)) continue;
                this.setSelected(i);
                return;
            }
        }
        this.setSelected(-1);
    }

    private void refreshImageText() {
        Object item = this.selected >= 0 ? this.getListModel().getElementAt(this.selected) : null;
        Helper.setUnoPropertyValue(this.getModel(this.lblImageText), PropertyNames.PROPERTY_LABEL, PropertyNames.SPACE + this.renderer.render(item));
    }

    public void setSelectionGap(Size size) {
        this.selectionGap = size;
    }

    public void setShowButtons(boolean b) {
        this.showButtons = b;
    }

    public void nextPage() {
        if (this.pageStart < this.getListModel().getSize() - this.rows * this.cols) {
            this.setPageStart(this.pageStart + this.rows * this.cols);
        }
    }

    public void prevPage() {
        if (this.pageStart == 0) {
            return;
        }
        int i = this.pageStart - this.rows * this.cols;
        if (i < 0) {
            i = 0;
        }
        this.setPageStart(i);
    }

    private void enableButtons() {
        this.enable(this.btnNext, this.pageStart + this.rows * this.cols < this.listModel.getSize());
        this.enable(this.btnBack, this.pageStart > 0);
    }

    private void enable(Object control, Boolean enable) {
        Helper.setUnoPropertyValue(this.getModel(control), PropertyNames.PROPERTY_ENABLED, enable);
    }

    private Object getModel(Object control) {
        return ((XControl)UnoRuntime.queryInterface(XControl.class, (Object)control)).getModel();
    }

    private void setBorder(Object control, Short border) {
        Helper.setUnoPropertyValue(this.getModel(control), PropertyNames.PROPERTY_BORDER, border);
    }

    private int getImageFromEvent(Object event) {
        Object image = ((EventObject)event).Source;
        String controlName = (String)Helper.getUnoPropertyValue(this.getModel(image), PropertyNames.PROPERTY_NAME);
        return Integer.valueOf(controlName.substring(6 + this.name.length()));
    }

    public void mousePressed(Object event) {
        int image = this.getImageFromEvent(event);
        int index = this.getIndexFor(image);
        if (index < this.listModel.getSize()) {
            this.focus(image);
            this.setSelected(index);
        }
    }

    public Object[] getSelectedObjects() {
        return new Object[]{this.getListModel().getElementAt(this.selected)};
    }

    public Object getSelectedObject() {
        return this.selected >= 0 ? this.getListModel().getElementAt(this.selected) : null;
    }

    public void showSelected() {
        int oldPageStart = this.pageStart;
        this.pageStart = this.selected == -1 ? (this.pageStart += 0) : this.selected / this.m_aImages.length * this.m_aImages.length;
        if (oldPageStart != this.pageStart) {
            this.enableButtons();
            this.refreshImages();
        }
    }

    public void setRowSelect(boolean b) {
        this.rowSelect = b;
    }

    public boolean isRowSelect() {
        return this.rowSelect;
    }

    private final void focus(int image) {
        Helper.setUnoPropertyValue(this.m_aImages[image].getModel(), "Tabstop", Boolean.TRUE);
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.m_aImages[image]);
        xWindow.setFocus();
    }

    private final void defocus(int image) {
        Helper.setUnoPropertyValue(UnoDialog.getModel(this.m_aImages[image]), "Tabstop", Boolean.FALSE);
    }

    public void display(int i) {
        int is = this.getCols() * this.getRows();
        int ps = this.listModel.getSize() / is * is;
        this.setPageStart(ps);
    }

    public boolean isenabled() {
        return this.benabled;
    }

    public void setenabled(boolean b) {
        for (int i = 0; i < this.m_aImages.length; ++i) {
            UnoDialog2.setEnabled((Object)this.m_aImages[i], b);
        }
        UnoDialog2.setEnabled((Object)this.grbxSelectedImage, b);
        UnoDialog2.setEnabled((Object)this.lblImageText, b);
        if (this.showButtons) {
            UnoDialog2.setEnabled((Object)this.btnBack, b);
            UnoDialog2.setEnabled((Object)this.btnNext, b);
            UnoDialog2.setEnabled((Object)this.lblCounter, b);
        }
        this.benabled = b;
    }

    private class ImageKeyListener
    implements XKeyListener {
        private ImageKeyListener() {
        }

        public void keyPressed(KeyEvent ke) {
            int c;
            int r;
            int d;
            int image = ImageList.this.getImageFromEvent(ke);
            int newImage = image + (d = this.getKeyMove(ke, r = image / ImageList.this.getCols(), c = image - r * ImageList.this.getCols()));
            if (newImage == image) {
                return;
            }
            if (this.isFocusable(newImage)) {
                this.changeFocus(image, newImage);
            }
        }

        private boolean isFocusable(int image) {
            return image >= 0 && ImageList.this.getIndexFor(image) < ImageList.this.listModel.getSize();
        }

        private void changeFocus(int oldFocusImage, int newFocusImage) {
            ImageList.this.focus(newFocusImage);
            ImageList.this.defocus(oldFocusImage);
        }

        private final int getKeyMove(KeyEvent ke, int row, int col) {
            switch (ke.KeyCode) {
                case 1025: {
                    if (row <= 0) break;
                    return 0 - ImageList.this.getCols();
                }
                case 1024: {
                    if (row >= ImageList.this.getRows() - 1) break;
                    return ImageList.this.getCols();
                }
                case 1026: {
                    if (col <= 0) break;
                    return -1;
                }
                case 1027: {
                    if (col >= ImageList.this.getCols() - 1) break;
                    return 1;
                }
                case 1284: {
                    this.select(ke);
                }
            }
            return 0;
        }

        private void select(KeyEvent ke) {
            ImageList.this.setSelected(ImageList.this.getIndexFor(ImageList.this.getImageFromEvent(ke)));
        }

        public void keyReleased(KeyEvent ke) {
        }

        public void disposing(EventObject arg0) {
        }
    }

    public static class Counter {
        public int start;
        public int end;
        public int max;

        public Counter(int start_, int end_, int max_) {
            this.start = start_;
            this.end = end_;
            this.max = max_;
        }
    }

    private static class SimpleCounterRenderer
    implements IRenderer {
        private SimpleCounterRenderer() {
        }

        public String render(Object counter) {
            return PropertyNames.EMPTY_STRING + ((Counter)counter).start + ".." + ((Counter)counter).end + "/" + ((Counter)counter).max;
        }
    }

    public static interface IImageRenderer
    extends IRenderer {
        public Object[] getImageUrls(Object var1);
    }

    class OMouseListener
    implements XMouseListener {
        public void mousePressed(MouseEvent arg0) {
            ImageList.this.focus(ImageList.this.getImageIndexFor(ImageList.this.getSelected()));
        }

        public void mouseReleased(MouseEvent arg0) {
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent arg0) {
        }

        public void disposing(EventObject arg0) {
        }
    }
}

