/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.FontDescriptor;
import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XItemEventBroadcaster;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindowListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexContainer;
import com.sun.star.frame.TerminationVetoException;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.HelpIds;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.XCompletion;
import com.sun.star.wizards.ui.event.CommonListener;
import com.sun.star.wizards.ui.event.MethodInvocation;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public abstract class WizardDialog
extends UnoDialog2
implements VetoableChangeListener,
XTerminateListener,
XCompletion {
    private static final String NEXT_ACTION_PERFORMED = "gotoNextAvailableStep";
    private static final String BACK_ACTION_PERFORMED = "gotoPreviousAvailableStep";
    private static final String FINISH_ACTION_PERFORMED = "finishWizard_1";
    private static final String CANCEL_ACTION_PERFORMED = "cancelWizard_1";
    private static final String HELP_ACTION_PERFORMED = "callHelp";
    public VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private String[] sRightPaneHeaders;
    private int iButtonWidth = 50;
    private int nNewStep = 1;
    private int nOldStep = 1;
    private int nMaxStep = 1;
    protected XItemListener RoadmapItemListener;
    protected XControl xRoadmapControl;
    XItemEventBroadcaster xRoadmapBroadcaster;
    String[] sRMItemLabels;
    private Object oRoadmap;
    private XSingleServiceFactory xSSFRoadmap;
    public XIndexContainer xIndexContRoadmap;
    private Resource oWizardResource;
    public String sMsgEndAutopilot;
    private int hid;
    private boolean bTerminateListenermustberemoved = true;

    public WizardDialog(XMultiServiceFactory xMSF, int hid_) {
        super(xMSF);
        this.hid = hid_;
        this.oWizardResource = new Resource(xMSF, "Common", "dbw");
        this.sMsgEndAutopilot = this.oWizardResource.getResText(1033);
    }

    public Resource getResource() {
        return this.oWizardResource;
    }

    public void activate() {
        try {
            XTopWindow top = (XTopWindow)UnoRuntime.queryInterface(XTopWindow.class, (Object)this.xWindow);
            if (top != null) {
                top.toFront();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMaxStep(int i) {
        this.nMaxStep = i;
    }

    public int getMaxStep() {
        return this.nMaxStep;
    }

    public void setOldStep(int i) {
        this.nOldStep = i;
    }

    public int getOldStep() {
        return this.nOldStep;
    }

    public void setNewStep(int i) {
        this.nNewStep = i;
    }

    public int getNewStep() {
        return this.nNewStep;
    }

    public void vetoableChange(PropertyChangeEvent arg0) {
        this.nNewStep = this.nOldStep;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        try {
            this.nNewStep = itemEvent.ItemId;
            this.nOldStep = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_STEP));
            if (this.nNewStep != this.nOldStep) {
                this.switchToStep();
            }
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void setRoadmapInteractive(boolean _bInteractive) {
        Helper.setUnoPropertyValue(this.oRoadmap, "Activated", _bInteractive);
    }

    public void setRoadmapComplete(boolean bComplete) {
        Helper.setUnoPropertyValue(this.oRoadmap, "Complete", bComplete);
    }

    public boolean isRoadmapComplete() {
        try {
            return AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(this.oRoadmap, "Complete"));
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public void setCurrentRoadmapItemID(short ID) {
        int nCurItemID;
        if (this.oRoadmap != null && (nCurItemID = this.getCurrentRoadmapItemID()) != ID) {
            Helper.setUnoPropertyValue(this.oRoadmap, "CurrentItemID", new Short(ID));
        }
    }

    public int getCurrentRoadmapItemID() {
        try {
            return AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.oRoadmap, "CurrentItemID"));
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace(System.err);
            return -1;
        }
    }

    public void addRoadmap() {
        try {
            int iDialogHeight = (Integer)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_HEIGHT);
            this.oRoadmap = this.insertControlModel("com.sun.star.awt.UnoControlRoadmapModel", "rdmNavi", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tabstop", PropertyNames.PROPERTY_WIDTH}, new Object[]{new Integer(iDialogHeight - 26), 0, 0, 0, new Short(0), Boolean.TRUE, 85});
            XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.oRoadmap);
            xPSet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)"rdmNavi");
            this.xSSFRoadmap = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)this.oRoadmap);
            this.xIndexContRoadmap = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)this.oRoadmap);
            MethodInvocation mi = new MethodInvocation("itemStateChanged", (Object)this, ItemEvent.class);
            this.getGuiEventListener().add("rdmNavi", "ICH", mi);
            this.xRoadmapControl = this.xDlgContainer.getControl("rdmNavi");
            this.xRoadmapBroadcaster = (XItemEventBroadcaster)UnoRuntime.queryInterface(XItemEventBroadcaster.class, (Object)this.xRoadmapControl);
            this.xRoadmapBroadcaster.addItemListener((XItemListener)this.getGuiEventListener());
            Helper.setUnoPropertyValue(this.oRoadmap, "Text", this.oWizardResource.getResText(516));
        }
        catch (NoSuchMethodException ex) {
            Resource.showCommonResourceError(this.xMSF);
        }
        catch (Exception jexception) {
            jexception.printStackTrace(System.err);
        }
    }

    public void setRMItemLabels(Resource _oResource, int StartResID) {
        this.sRMItemLabels = _oResource.getResArray(StartResID, this.nMaxStep);
    }

    public String[] getRMItemLabels() {
        return this.sRMItemLabels;
    }

    public int insertRoadmapItem(int _Index, boolean _bEnabled, int _LabelID, int _CurItemID) {
        return this.insertRoadmapItem(_Index, _bEnabled, this.sRMItemLabels[_LabelID], _CurItemID);
    }

    public int insertRoadmapItem(int Index, boolean _bEnabled, String _sLabel, int _CurItemID) {
        try {
            Object oRoadmapItem = this.xSSFRoadmap.createInstance();
            Helper.setUnoPropertyValue(oRoadmapItem, PropertyNames.PROPERTY_LABEL, _sLabel);
            Helper.setUnoPropertyValue(oRoadmapItem, PropertyNames.PROPERTY_ENABLED, _bEnabled);
            Helper.setUnoPropertyValue(oRoadmapItem, "ID", new Integer(_CurItemID));
            this.xIndexContRoadmap.insertByIndex(Index, oRoadmapItem);
            return Index + 1;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return -1;
        }
    }

    public int getRMItemCount() {
        return this.xIndexContRoadmap.getCount();
    }

    public XInterface getRoadmapItemByID(int _ID) {
        try {
            for (int i = 0; i < this.xIndexContRoadmap.getCount(); ++i) {
                XInterface CurRoadmapItem = (XInterface)this.xIndexContRoadmap.getByIndex(i);
                int CurID = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(CurRoadmapItem, "ID"));
                if (CurID != _ID) continue;
                return CurRoadmapItem;
            }
            return null;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public boolean switchToStep(int _nOldStep, int _nNewStep) {
        this.nOldStep = _nOldStep;
        this.nNewStep = _nNewStep;
        return this.switchToStep();
    }

    private boolean switchToStep() {
        this.leaveStep(this.nOldStep, this.nNewStep);
        if (this.nNewStep != this.nOldStep) {
            if (this.nNewStep == this.nMaxStep) {
                this.setControlProperty("btnWizardNext", "DefaultButton", Boolean.FALSE);
                this.setControlProperty("btnWizardFinish", "DefaultButton", Boolean.TRUE);
            } else {
                this.setControlProperty("btnWizardNext", "DefaultButton", Boolean.TRUE);
                this.setControlProperty("btnWizardFinish", "DefaultButton", Boolean.FALSE);
            }
            this.changeToStep(this.nNewStep);
            this.enterStep(this.nOldStep, this.nNewStep);
            return true;
        }
        return false;
    }

    protected abstract void leaveStep(int var1, int var2);

    protected abstract void enterStep(int var1, int var2);

    protected void changeToStep(int nNewStep) {
        Helper.setUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_STEP, new Integer(nNewStep));
        this.setCurrentRoadmapItemID((short)nNewStep);
        this.enableNextButton(this.getNextAvailableStep() > 0);
        this.enableBackButton(nNewStep != 1);
    }

    public boolean iscompleted(int _ndialogpage) {
        return false;
    }

    public boolean ismodified(int _ndialogpage) {
        return false;
    }

    public void setcompleted(int _ndialogpage, boolean _biscompleted) {
    }

    public void setmodified(int _ndialogpage, Object ooldValue, Object onewValue) {
    }

    public void drawNaviBar() {
        try {
            short curtabindex = 30000;
            Integer IButtonWidth = new Integer(this.iButtonWidth);
            int iButtonHeight = 14;
            Integer IButtonHeight = new Integer(iButtonHeight);
            Integer ICurStep = 0;
            int iDialogHeight = (Integer)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_HEIGHT);
            int iDialogWidth = (Integer)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_WIDTH);
            int iHelpPosX = 8;
            int iBtnPosY = iDialogHeight - iButtonHeight - 6;
            int iCancelPosX = iDialogWidth - this.iButtonWidth - 6;
            int iFinishPosX = iCancelPosX - 6 - this.iButtonWidth;
            int iNextPosX = iFinishPosX - 6 - this.iButtonWidth;
            int iBackPosX = iNextPosX - 3 - this.iButtonWidth;
            this.insertControlModel("com.sun.star.awt.UnoControlFixedLineModel", "lnNaviSep", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.ORIENTATION, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_WIDTH}, new Object[]{1, 0, 0, new Integer(iDialogHeight - 26), ICurStep, new Integer(iDialogWidth)});
            this.insertControlModel("com.sun.star.awt.UnoControlFixedLineModel", "lnRoadSep", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.ORIENTATION, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_WIDTH}, new Object[]{new Integer(iBtnPosY - 6), 1, 85, 0, ICurStep, 1});
            String[] propNames = new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, "PushButtonType", PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH};
            Helper.setUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_HELPURL, HelpIds.getHelpIdString(this.hid));
            Object[] objectArray = new Object[9];
            objectArray[0] = true;
            objectArray[1] = IButtonHeight;
            objectArray[2] = this.oWizardResource.getResText(515);
            objectArray[3] = new Integer(iHelpPosX);
            objectArray[4] = new Integer(iBtnPosY);
            objectArray[5] = new Short(3);
            objectArray[6] = ICurStep;
            short s = curtabindex;
            curtabindex = (short)(curtabindex + 1);
            objectArray[7] = new Short(s);
            objectArray[8] = IButtonWidth;
            this.insertButton("btnWizardHelp", HELP_ACTION_PERFORMED, new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, "PushButtonType", PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray);
            Object[] objectArray2 = new Object[10];
            objectArray2[0] = false;
            objectArray2[1] = IButtonHeight;
            objectArray2[2] = HelpIds.getHelpIdString(this.hid + 2);
            objectArray2[3] = this.oWizardResource.getResText(513);
            objectArray2[4] = new Integer(iBackPosX);
            objectArray2[5] = new Integer(iBtnPosY);
            objectArray2[6] = new Short(0);
            objectArray2[7] = ICurStep;
            short s2 = curtabindex;
            curtabindex = (short)(curtabindex + 1);
            objectArray2[8] = new Short(s2);
            objectArray2[9] = IButtonWidth;
            this.insertButton("btnWizardBack", BACK_ACTION_PERFORMED, propNames, objectArray2);
            Object[] objectArray3 = new Object[10];
            objectArray3[0] = true;
            objectArray3[1] = IButtonHeight;
            objectArray3[2] = HelpIds.getHelpIdString(this.hid + 3);
            objectArray3[3] = this.oWizardResource.getResText(514);
            objectArray3[4] = new Integer(iNextPosX);
            objectArray3[5] = new Integer(iBtnPosY);
            objectArray3[6] = new Short(0);
            objectArray3[7] = ICurStep;
            short s3 = curtabindex;
            curtabindex = (short)(curtabindex + 1);
            objectArray3[8] = new Short(s3);
            objectArray3[9] = IButtonWidth;
            this.insertButton("btnWizardNext", NEXT_ACTION_PERFORMED, propNames, objectArray3);
            Object[] objectArray4 = new Object[10];
            objectArray4[0] = true;
            objectArray4[1] = IButtonHeight;
            objectArray4[2] = HelpIds.getHelpIdString(this.hid + 4);
            objectArray4[3] = this.oWizardResource.getResText(512);
            objectArray4[4] = new Integer(iFinishPosX);
            objectArray4[5] = new Integer(iBtnPosY);
            objectArray4[6] = new Short(0);
            objectArray4[7] = ICurStep;
            short s4 = curtabindex;
            curtabindex = (short)(curtabindex + 1);
            objectArray4[8] = new Short(s4);
            objectArray4[9] = IButtonWidth;
            this.insertButton("btnWizardFinish", FINISH_ACTION_PERFORMED, propNames, objectArray4);
            Object[] objectArray5 = new Object[10];
            objectArray5[0] = true;
            objectArray5[1] = IButtonHeight;
            objectArray5[2] = HelpIds.getHelpIdString(this.hid + 5);
            objectArray5[3] = this.oWizardResource.getResText(511);
            objectArray5[4] = new Integer(iCancelPosX);
            objectArray5[5] = new Integer(iBtnPosY);
            objectArray5[6] = new Short(0);
            objectArray5[7] = ICurStep;
            short s5 = curtabindex;
            curtabindex = (short)(curtabindex + 1);
            objectArray5[8] = new Short(s5);
            objectArray5[9] = IButtonWidth;
            this.insertButton("btnWizardCancel", CANCEL_ACTION_PERFORMED, propNames, objectArray5);
            this.setControlProperty("btnWizardNext", "DefaultButton", Boolean.TRUE);
            MethodInvocation windowHidden = new MethodInvocation("windowHidden", (Object)this);
            this.xWindow.addWindowListener((XWindowListener)((CommonListener)this.getGuiEventListener()));
            String dialogName = (String)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_NAME);
            this.getGuiEventListener().add(dialogName, "APR", windowHidden);
        }
        catch (Exception jexception) {
            jexception.printStackTrace(System.err);
        }
    }

    protected void insertRoadMapItems(String[] items, int[] steps, boolean[] enabled) {
        for (int i = 0; i < items.length; ++i) {
            this.insertRoadmapItem(i, enabled[i], items[i], steps[i]);
        }
    }

    public void setStepEnabled(int _nStep, boolean bEnabled, boolean enableNextButton) {
        this.setStepEnabled(_nStep, bEnabled);
        if (this.getNextAvailableStep() > 0) {
            this.enableNextButton(bEnabled);
        }
    }

    public void enableNavigationButtons(boolean _bEnableBack, boolean _bEnableNext, boolean _bEnableFinish) {
        this.enableBackButton(_bEnableBack);
        this.enableNextButton(_bEnableNext);
        this.enableFinishButton(_bEnableFinish);
    }

    public void enableBackButton(boolean enabled) {
        this.setControlProperty("btnWizardBack", PropertyNames.PROPERTY_ENABLED, enabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public void enableNextButton(boolean enabled) {
        this.setControlProperty("btnWizardNext", PropertyNames.PROPERTY_ENABLED, enabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public void enableFinishButton(boolean enabled) {
        this.setControlProperty("btnWizardFinish", PropertyNames.PROPERTY_ENABLED, enabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStepEnabled(int _nStep, boolean bEnabled) {
        XInterface xRoadmapItem = this.getRoadmapItemByID(_nStep);
        if (xRoadmapItem != null) {
            Helper.setUnoPropertyValue(xRoadmapItem, PropertyNames.PROPERTY_ENABLED, bEnabled);
        }
    }

    public void enablefromStep(int _iStep, boolean _bDoEnable) {
        if (_iStep <= this.nMaxStep) {
            for (int i = _iStep; i <= this.nMaxStep; ++i) {
                this.setStepEnabled(i, _bDoEnable);
            }
            this.enableFinishButton(_bDoEnable);
            if (!_bDoEnable) {
                this.enableNextButton(_iStep > this.getCurrentStep() + 1);
            } else {
                this.enableNextButton(this.getCurrentStep() != this.nMaxStep);
            }
        }
    }

    public boolean isStepEnabled(int _nStep) {
        try {
            XInterface xRoadmapItem = this.getRoadmapItemByID(_nStep);
            if (xRoadmapItem == null) {
                return false;
            }
            boolean bIsEnabled = AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(xRoadmapItem, PropertyNames.PROPERTY_ENABLED));
            return bIsEnabled;
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public synchronized void gotoPreviousAvailableStep() {
        if (this.nNewStep > 1) {
            boolean bIsEnabled;
            this.nOldStep = this.nNewStep--;
            while (this.nNewStep > 0 && !(bIsEnabled = this.isStepEnabled(this.nNewStep))) {
                --this.nNewStep;
            }
            if (this.nNewStep == 0) {
                this.nNewStep = this.nOldStep;
            }
            this.switchToStep();
        }
    }

    protected int getNextAvailableStep() {
        if (this.isRoadmapComplete()) {
            for (int i = this.nNewStep + 1; i <= this.nMaxStep; ++i) {
                if (!this.isStepEnabled(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void gotoNextAvailableStep() {
        this.nOldStep = this.nNewStep;
        this.nNewStep = this.getNextAvailableStep();
        if (this.nNewStep > -1) {
            this.switchToStep();
        }
    }

    public abstract boolean finishWizard();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishWizard_1() {
        this.enableFinishButton(false);
        boolean success = false;
        try {
            success = this.finishWizard();
        }
        finally {
            if (!success) {
                this.enableFinishButton(true);
            }
        }
        if (success) {
            this.removeTerminateListener();
        }
    }

    public int getMaximalStep() {
        return this.nMaxStep;
    }

    public int getCurrentStep() {
        try {
            return AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.MSFDialogModel, PropertyNames.PROPERTY_STEP));
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace(System.err);
            return -1;
        }
    }

    public void setCurrentStep(int _nNewstep) {
        this.nNewStep = _nNewstep;
        this.changeToStep(this.nNewStep);
    }

    public void setRightPaneHeaders(Resource _oResource, int StartResID, int _nMaxStep) {
        String[] sRightPaneHeaders = _oResource.getResArray(StartResID, _nMaxStep);
        this.setRightPaneHeaders(sRightPaneHeaders);
    }

    public void setRightPaneHeaders(String[] _sRightPaneHeaders) {
        this.nMaxStep = _sRightPaneHeaders.length;
        this.sRightPaneHeaders = _sRightPaneHeaders;
        FontDescriptor oFontDesc = new FontDescriptor();
        oFontDesc.Weight = 150.0f;
        for (int i = 0; i < this.sRightPaneHeaders.length; ++i) {
            this.insertLabel("lblQueryTitle" + String.valueOf(i), new String[]{PropertyNames.FONT_DESCRIPTOR, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_MULTILINE, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{oFontDesc, 16, this.sRightPaneHeaders[i], Boolean.TRUE, 91, 8, new Integer(i + 1), new Short(12), 212});
        }
    }

    public void cancelWizard() {
        this.xDialog.endExecute();
    }

    public void callHelp() {
    }

    public void removeTerminateListener() {
        if (this.bTerminateListenermustberemoved) {
            Desktop.getDesktop(this.xMSF).removeTerminateListener((XTerminateListener)this);
            this.bTerminateListenermustberemoved = false;
        }
    }

    public void cancelWizard_1() {
        this.cancelWizard();
        this.removeTerminateListener();
    }

    public void windowHidden() {
        this.cancelWizard_1();
    }

    public void notifyTermination(EventObject arg0) {
        this.cancelWizard_1();
    }

    public void queryTermination(EventObject arg0) throws TerminationVetoException {
        this.activate();
        throw new TerminationVetoException();
    }

    public void disposing(EventObject arg0) {
        this.cancelWizard_1();
    }
}

