/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui.event;

import com.sun.star.wizards.ui.event.TaskEvent;
import com.sun.star.wizards.ui.event.TaskListener;
import java.util.ArrayList;
import java.util.List;

public class Task {
    private int successful = 0;
    private int failed = 0;
    private int max = 0;
    private String taskName;
    private List<TaskListener> listeners = new ArrayList<TaskListener>();
    private String subtaskName;

    public Task(String taskName_, String subtaskName_, int max_) {
        this.taskName = taskName_;
        this.subtaskName = subtaskName_;
        this.max = max_;
    }

    public void start() {
        this.fireTaskStarted();
    }

    public void fail() {
        this.fireTaskFailed();
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max_) {
        this.max = max_;
        this.fireTaskStatusChanged();
    }

    public void advance(boolean success_) {
        if (success_) {
            ++this.successful;
        } else {
            ++this.failed;
        }
        this.fireTaskStatusChanged();
        if (this.failed + this.successful == this.max) {
            this.fireTaskFinished();
        }
    }

    public void advance(boolean success_, String nextSubtaskName) {
        this.advance(success_);
        this.setSubtaskName(nextSubtaskName);
    }

    public int getStatus() {
        return this.successful + this.failed;
    }

    public void addTaskListener(TaskListener tl) {
        this.listeners.add(tl);
    }

    public void removeTaskListener(TaskListener tl) {
        this.listeners.remove(tl);
    }

    protected void fireTaskStatusChanged() {
        TaskEvent te = new TaskEvent(this, 3);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).taskStatusChanged(te);
        }
    }

    protected void fireTaskStarted() {
        TaskEvent te = new TaskEvent(this, 1);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).taskStarted(te);
        }
    }

    protected void fireTaskFailed() {
        TaskEvent te = new TaskEvent(this, 5);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).taskFinished(te);
        }
    }

    protected void fireTaskFinished() {
        TaskEvent te = new TaskEvent(this, 2);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).taskFinished(te);
        }
    }

    protected void fireSubtaskNameChanged() {
        TaskEvent te = new TaskEvent(this, 4);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).subtaskNameChanged(te);
        }
    }

    public String getSubtaskName() {
        return this.subtaskName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setSubtaskName(String string) {
        this.subtaskName = string;
        this.fireSubtaskNameChanged();
    }

    public int getFailed() {
        return this.failed;
    }

    public int getSuccessfull() {
        return this.successful;
    }
}

