/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui.event;

import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.TextEvent;
import com.sun.star.awt.XCheckBox;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XTextListener;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.ui.event.DataAware;
import com.sun.star.wizards.ui.event.DataAwareFields;

public class UnoDataAware
extends DataAware {
    protected Object unoControl;
    protected Object unoModel;
    protected String unoPropName;
    protected Object[] disableObjects = new Object[0];
    protected boolean inverse = false;

    protected UnoDataAware(Object dataObject, DataAware.Value value, Object unoObject_, String unoPropName_) {
        super(dataObject, value);
        this.unoControl = unoObject_;
        this.unoModel = UnoDataAware.getModel(this.unoControl);
        this.unoPropName = unoPropName_;
    }

    public void setInverse(boolean i) {
        this.inverse = i;
    }

    protected void enableControls(Object value) {
        Boolean b = this.getBoolean(value);
        if (this.inverse) {
            b = b != false ? Boolean.FALSE : Boolean.TRUE;
        }
        for (int i = 0; i < this.disableObjects.length; ++i) {
            UnoDataAware.setEnabled(this.disableObjects[i], b);
        }
    }

    protected void setToUI(Object value) {
        Helper.setUnoPropertyValue(this.unoModel, this.unoPropName, value);
    }

    private String stringof(Object value) {
        if (value.getClass().isArray()) {
            StringBuffer sb = new StringBuffer("[");
            for (int i = 0; i < ((short[])value).length; ++i) {
                sb.append(((short[])value)[i]).append(" , ");
            }
            sb.append("]");
            return sb.toString();
        }
        return value.toString();
    }

    protected Boolean getBoolean(Object value) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value.getClass().isArray()) {
            return ((short[])value).length != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (value.equals(PropertyNames.EMPTY_STRING)) {
            return Boolean.FALSE;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void disableControls(Object[] controls) {
        this.disableObjects = controls;
    }

    protected Object getFromUI() {
        return Helper.getUnoPropertyValue(this.unoModel, this.unoPropName);
    }

    private static UnoDataAware attachTextControl(Object data, String prop, Object unoText, final DataAware.Listener listener, String unoProperty, boolean field, Object value) {
        XTextComponent text = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)unoText);
        final UnoDataAware uda = new UnoDataAware(data, field ? DataAwareFields.getFieldValueFor(data, prop, value) : new DataAware.PropertyValue(prop, data), text, unoProperty);
        text.addTextListener(new XTextListener(){

            public void textChanged(TextEvent te) {
                uda.updateData();
                if (listener != null) {
                    listener.eventPerformed(te);
                }
            }

            public void disposing(EventObject eo) {
            }
        });
        return uda;
    }

    public static UnoDataAware attachEditControl(Object data, String prop, Object unoControl, DataAware.Listener listener, boolean field) {
        return UnoDataAware.attachTextControl(data, prop, unoControl, listener, "Text", field, PropertyNames.EMPTY_STRING);
    }

    public static UnoDataAware attachDateControl(Object data, String prop, Object unoControl, DataAware.Listener listener, boolean field) {
        return UnoDataAware.attachTextControl(data, prop, unoControl, listener, "Date", field, 0);
    }

    public static UnoDataAware attachTimeControl(Object data, String prop, Object unoControl, DataAware.Listener listener, boolean field) {
        return UnoDataAware.attachTextControl(data, prop, unoControl, listener, "Time", field, 0);
    }

    public static UnoDataAware attachNumericControl(Object data, String prop, Object unoControl, DataAware.Listener listener, boolean field) {
        return UnoDataAware.attachTextControl(data, prop, unoControl, listener, "Value", field, new Double(0.0));
    }

    public static UnoDataAware attachCheckBox(Object data, String prop, Object checkBox, DataAware.Listener listener, boolean field) {
        XCheckBox xcheckBox = (XCheckBox)UnoRuntime.queryInterface(XCheckBox.class, (Object)checkBox);
        UnoDataAware uda = new UnoDataAware(data, field ? DataAwareFields.getFieldValueFor(data, prop, new Short(0)) : new DataAware.PropertyValue(prop, data), checkBox, PropertyNames.PROPERTY_STATE);
        xcheckBox.addItemListener(UnoDataAware.itemListener(uda, listener));
        return uda;
    }

    static XItemListener itemListener(final DataAware da, final DataAware.Listener listener) {
        return new XItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                da.updateData();
                if (listener != null) {
                    listener.eventPerformed(ie);
                }
            }

            public void disposing(EventObject eo) {
            }
        };
    }

    public static UnoDataAware attachLabel(Object data, String prop, Object label, DataAware.Listener listener, boolean field) {
        return new UnoDataAware(data, field ? DataAwareFields.getFieldValueFor(data, prop, PropertyNames.EMPTY_STRING) : new DataAware.PropertyValue(prop, data), label, PropertyNames.PROPERTY_LABEL);
    }

    public static UnoDataAware attachListBox(Object data, String prop, Object listBox, DataAware.Listener listener, boolean field) {
        XListBox xListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)listBox);
        UnoDataAware uda = new UnoDataAware(data, field ? DataAwareFields.getFieldValueFor(data, prop, new short[0]) : new DataAware.PropertyValue(prop, data), listBox, PropertyNames.SELECTED_ITEMS);
        xListBox.addItemListener(UnoDataAware.itemListener(uda, listener));
        return uda;
    }

    public static Object getModel(Object control) {
        return ((XControl)UnoRuntime.queryInterface(XControl.class, (Object)control)).getModel();
    }

    public static void setEnabled(Object control, boolean enabled) {
        UnoDataAware.setEnabled(control, enabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void setEnabled(Object control, Boolean enabled) {
        Helper.setUnoPropertyValue(UnoDataAware.getModel(control), PropertyNames.PROPERTY_ENABLED, enabled);
    }
}

