/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentDeserializer;
import org.openoffice.xmerge.DocumentDeserializer2;
import org.openoffice.xmerge.DocumentDeserializerFactory;
import org.openoffice.xmerge.DocumentMerger;
import org.openoffice.xmerge.DocumentMergerFactory;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.DocumentSerializer2;
import org.openoffice.xmerge.DocumentSerializerFactory;
import org.openoffice.xmerge.util.registry.ConverterInfo;

public class Convert
implements Cloneable {
    private ConverterInfo ci;
    private boolean toOffice;
    private ConvertData inputCD = new ConvertData();

    public Convert(ConverterInfo ci, boolean toOffice) {
        this.ci = ci;
        this.toOffice = toOffice;
    }

    public void addInputStream(String name, InputStream is) throws IOException {
        Document inputDoc = this.toOffice ? this.ci.getPluginFactory().createDeviceDocument(name, is) : this.ci.getPluginFactory().createOfficeDocument(name, is);
        this.inputCD.addDocument(inputDoc);
    }

    public void addInputStream(String name, InputStream is, boolean isZip) throws IOException {
        Document inputDoc = this.toOffice ? this.ci.getPluginFactory().createDeviceDocument(name, is) : this.ci.getPluginFactory().createOfficeDocument(name, is, isZip);
        this.inputCD.addDocument(inputDoc);
    }

    public DocumentMerger getDocumentMerger(Document origDoc) throws IOException {
        DocumentMergerFactory myDocMergerFactory = this.ci.getDocMergerFactory();
        DocumentMerger merger = myDocMergerFactory.createDocumentMerger(origDoc);
        return merger;
    }

    public void reset() {
        this.inputCD.reset();
    }

    public Object clone() {
        Convert aClone = null;
        try {
            aClone = (Convert)super.clone();
            aClone.reset();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Convert clone could not be created");
        }
        return aClone;
    }

    public ConvertData convert() throws ConvertException, IOException {
        ConvertData dataOut = new ConvertData();
        if (this.toOffice) {
            DocumentDeserializerFactory myDocDeserializerFactory = this.ci.getDocDeserializerFactory();
            DocumentDeserializer deser = myDocDeserializerFactory.createDocumentDeserializer(this.inputCD);
            Document deviceDoc = deser.deserialize();
            dataOut.addDocument(deviceDoc);
            return dataOut;
        }
        DocumentSerializerFactory myDocSerializerFactory = this.ci.getDocSerializerFactory();
        Iterator<Object> e = this.inputCD.getDocumentEnumeration();
        Document doc = (Document)e.next();
        DocumentSerializer ser = myDocSerializerFactory.createDocumentSerializer(doc);
        dataOut = ser.serialize();
        return dataOut;
    }

    public ConvertData convert(String sFromURL, String sToURL) throws ConvertException, IOException {
        Iterator<Object> e;
        Document doc;
        ConvertData dataOut = new ConvertData();
        if (this.toOffice) {
            DocumentDeserializerFactory myDocDeserializerFactory = this.ci.getDocDeserializerFactory();
            DocumentDeserializer deser = myDocDeserializerFactory.createDocumentDeserializer(this.inputCD);
            Document officeDoc = deser instanceof DocumentSerializer2 ? ((DocumentDeserializer2)((Object)deser)).deserialize(sFromURL, sToURL) : deser.deserialize();
            dataOut.addDocument(officeDoc);
            return dataOut;
        }
        DocumentSerializerFactory myDocSerializerFactory = this.ci.getDocSerializerFactory();
        DocumentSerializer ser = myDocSerializerFactory.createDocumentSerializer(doc = (Document)(e = this.inputCD.getDocumentEnumeration()).next());
        dataOut = ser instanceof DocumentSerializer2 ? ((DocumentSerializer2)ser).serialize(sFromURL, sToURL) : ser.serialize();
        return dataOut;
    }

    public Document getOfficeDocument(String name, InputStream is) throws IOException {
        return this.ci.getPluginFactory().createOfficeDocument(name, is);
    }

    public Document getDeviceDocument(String name, InputStream is) throws IOException {
        return this.ci.getPluginFactory().createDeviceDocument(name, is);
    }
}

