/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.openoffice.xmerge.converter.palm.Record;

public final class PalmDB {
    public static final short PDB_HEADER_ATTR_BACKUP = 8;
    public static final int NAME_LENGTH = 32;
    private Record[] records;
    private byte[] bName = null;
    private String sName = null;
    private int creatorID = 0;
    private int typeID = 0;
    private int version = 0;
    private short attribute = 0;

    public PalmDB(int creatorID, int typeID, int version, short attribute) {
        this.records = new Record[0];
        this.setAttributes(creatorID, typeID, version, attribute);
    }

    public PalmDB(String name, int creatorID, int typeID, int version, short attribute, Record[] recs) throws UnsupportedEncodingException {
        this(name.getBytes("8859_1"), creatorID, typeID, version, attribute, recs);
    }

    public PalmDB(byte[] name, int creatorID, int typeID, int version, short attribute, Record[] recs) throws UnsupportedEncodingException {
        this.store(name);
        this.records = new Record[recs.length];
        System.arraycopy(recs, 0, this.records, 0, recs.length);
        this.setAttributes(creatorID, typeID, version, attribute);
    }

    public void setAttributes(int creatorID, int typeID, int version, short attribute) {
        this.creatorID = creatorID;
        this.typeID = typeID;
        this.version = version;
        this.attribute = attribute;
    }

    private void store(byte[] bytes) throws UnsupportedEncodingException {
        int i;
        this.bName = new byte[32];
        int lastIndex = 31;
        int len = bytes.length < lastIndex ? bytes.length : lastIndex;
        for (i = 0; i < len && bytes[i] != 0; ++i) {
            this.bName[i] = bytes[i];
        }
        this.sName = new String(this.bName, 0, i, "8859_1");
    }

    public int getCreatorID() {
        return this.creatorID;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public short getAttribute() {
        return this.attribute;
    }

    public int getVersion() {
        return this.version;
    }

    public int getRecordCount() {
        return this.records.length;
    }

    public Record getRecord(int index) {
        return this.records[index];
    }

    public Record[] getRecords() {
        return this.records;
    }

    public String getPDBNameString() {
        return this.sName;
    }

    public byte[] getPDBNameBytes() {
        return this.bName;
    }

    public void write(OutputStream os) throws IOException {
        DataOutputStream out = new DataOutputStream(os);
        out.write(this.bName);
        out.writeShort(this.records.length);
        for (int i = 0; i < this.records.length; ++i) {
            this.records[i].write(out);
        }
    }

    public void read(InputStream is) throws IOException {
        DataInputStream in = new DataInputStream(is);
        byte[] bytes = new byte[32];
        in.readFully(bytes);
        this.store(bytes);
        int nrec = in.readUnsignedShort();
        this.records = new Record[nrec];
        for (int i = 0; i < nrec; ++i) {
            this.records[i] = new Record();
            this.records[i].read(in);
        }
    }

    public boolean equals(Object obj) {
        boolean bool;
        block7: {
            bool = false;
            if (obj instanceof PalmDB) {
                PalmDB pdb = (PalmDB)obj;
                if (this.sName.equals(pdb.sName) && this.bName.length == pdb.bName.length) {
                    int i;
                    for (i = 0; i < this.bName.length; ++i) {
                        if (this.bName[i] == pdb.bName[i]) {
                            continue;
                        }
                        break block7;
                    }
                    if (this.records.length == pdb.records.length) {
                        for (i = 0; i < this.records.length; ++i) {
                            if (this.records[i].equals(pdb.records[i])) {
                                continue;
                            }
                            break block7;
                        }
                        bool = true;
                    }
                }
            }
        }
        return bool;
    }
}

