/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.converter.palm.PalmDB;
import org.openoffice.xmerge.converter.palm.PdbDecoder;
import org.openoffice.xmerge.converter.palm.PdbEncoder;
import org.openoffice.xmerge.converter.palm.Record;

public class PalmDocument
implements Document {
    private PalmDB pdb;
    private String fileName;

    public PalmDocument(InputStream is) throws IOException {
        this.read(is);
    }

    public PalmDocument(String name, int creatorID, int typeID, int version, short attribute, Record[] recs) throws UnsupportedEncodingException {
        this.pdb = new PalmDB(name, creatorID, typeID, version, attribute, recs);
        this.fileName = this.pdb.getPDBNameString();
    }

    public void read(InputStream is) throws IOException {
        PdbDecoder decoder = new PdbDecoder();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int n = 0;
        while ((n = is.read(buf)) > 0) {
            baos.write(buf, 0, n);
        }
        byte[] bytearr = baos.toByteArray();
        this.pdb = decoder.parse(bytearr);
        this.fileName = this.pdb.getPDBNameString();
    }

    public void write(OutputStream os) throws IOException {
        PdbEncoder encoder = new PdbEncoder(this.pdb);
        encoder.write(os);
    }

    public PalmDB getPdb() {
        return this.pdb;
    }

    public void setPdb(PalmDB pdb) {
        String name;
        this.pdb = pdb;
        this.fileName = name = pdb.getPDBNameString();
    }

    public String getFileName() {
        return this.fileName + ".pdb";
    }

    public String getName() {
        return this.fileName;
    }
}

