/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.openoffice.xmerge.converter.palm.PalmDB;
import org.openoffice.xmerge.converter.palm.PdbHeader;
import org.openoffice.xmerge.converter.palm.Record;

public final class PdbEncoder {
    private PdbHeader header = new PdbHeader();
    private PalmDB db = null;
    private static final int START_UNIQUE_ID = 47806;

    public PdbEncoder(PalmDB db) {
        this.header.version = db.getVersion();
        this.header.attribute = db.getAttribute();
        this.db = db;
        this.header.pdbName = db.getPDBNameBytes();
        this.header.creatorID = db.getCreatorID();
        this.header.typeID = db.getTypeID();
        Date date = new Date();
        this.header.modificationDate = this.header.creationDate = date.getTime() / 1000L + 2082844800L;
        this.header.numRecords = db.getRecordCount();
    }

    public void write(OutputStream os) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        DataOutputStream dos = new DataOutputStream(bos);
        this.header.write(dos);
        if (this.header.numRecords > 0) {
            int i;
            int[] recOffset = new int[this.header.numRecords];
            byte[] recAttr = new byte[this.header.numRecords];
            recOffset[0] = 78 + this.header.numRecords * 8;
            int lastIndex = this.header.numRecords - 1;
            for (int i2 = 0; i2 < lastIndex; ++i2) {
                Record rec = this.db.getRecord(i2);
                int size = rec.getSize();
                recAttr[i2] = rec.getAttributes();
                recOffset[i2 + 1] = recOffset[i2] + size;
            }
            Record lastRec = this.db.getRecord(lastIndex);
            recAttr[lastIndex] = lastRec.getAttributes();
            int uid = 47806;
            for (i = 0; i < this.header.numRecords; ++i) {
                dos.writeInt(recOffset[i]);
                int attr = recAttr[i] << 24;
                dos.writeInt(attr |= uid);
                ++uid;
            }
            for (i = 0; i < this.header.numRecords; ++i) {
                Record rec = this.db.getRecord(i);
                byte[] bytes = rec.getBytes();
                dos.write(bytes);
            }
        } else {
            dos.writeShort(0);
        }
        dos.flush();
    }
}

