/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class PdbHeader {
    byte[] pdbName = null;
    short attribute = 0;
    int version = 0;
    long creationDate = 0L;
    long modificationDate = 0L;
    long lastBackupDate = 0L;
    long modificationNumber = 0L;
    int appInfoID = 0;
    int sortInfoID = 0;
    int typeID = 0;
    int creatorID = 0;
    int uniqueIDSeed = 0;
    int nextRecordListID = 0;
    int numRecords = 0;

    PdbHeader() {
    }

    public void read(DataInput in) throws IOException {
        this.pdbName = new byte[32];
        in.readFully(this.pdbName);
        this.attribute = in.readShort();
        this.version = in.readUnsignedShort();
        this.creationDate = (long)in.readInt() & 0xFFFFFFFFL;
        this.modificationDate = (long)in.readInt() & 0xFFFFFFFFL;
        this.lastBackupDate = (long)in.readInt() & 0xFFFFFFFFL;
        this.modificationNumber = (long)in.readInt() & 0xFFFFFFFFL;
        this.appInfoID = in.readInt();
        this.sortInfoID = in.readInt();
        this.creatorID = in.readInt();
        this.typeID = in.readInt();
        this.uniqueIDSeed = in.readInt();
        this.nextRecordListID = in.readInt();
        this.numRecords = in.readUnsignedShort();
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.pdbName);
        out.writeShort(this.attribute);
        out.writeShort(this.version);
        out.writeInt((int)this.creationDate);
        out.writeInt((int)this.modificationDate);
        out.writeInt((int)this.lastBackupDate);
        out.writeInt((int)this.modificationNumber);
        out.writeInt(this.appInfoID);
        out.writeInt(this.sortInfoID);
        out.writeInt(this.typeID);
        out.writeInt(this.creatorID);
        out.writeInt(this.uniqueIDSeed);
        out.writeInt(this.nextRecordListID);
        out.writeShort(this.numRecords);
    }
}

