/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Style {
    protected String name = null;
    protected String family = null;
    protected String parent = null;
    protected StyleCatalog sc;

    public Style(Node node, StyleCatalog sc) {
        NamedNodeMap attrNodes;
        this.sc = sc;
        if (node.getNodeName().equals("style:default-style")) {
            this.name = "DEFAULT_STYLE";
        }
        if ((attrNodes = node.getAttributes()) != null) {
            int len = attrNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node attr = attrNodes.item(i);
                if (attr.getNodeName().equals("style:family")) {
                    this.family = attr.getNodeValue();
                    continue;
                }
                if (attr.getNodeName().equals("style:name")) {
                    this.name = attr.getNodeValue();
                    continue;
                }
                if (!attr.getNodeName().equals("style:parent-style-name")) continue;
                this.parent = attr.getNodeValue();
            }
        }
    }

    public Style(String name, String family, String parent, StyleCatalog sc) {
        this.sc = sc;
        this.name = name;
        this.family = family;
        this.parent = parent;
    }

    public void setCatalog(StyleCatalog sc) {
        this.sc = sc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getFamily() {
        return this.family;
    }

    public String getParent() {
        return this.parent;
    }

    public Style getResolved() {
        return new Style(this.name, this.family, this.parent, this.sc);
    }

    public Node createNode(Document parentDoc, String name) {
        return null;
    }

    public void writeAttributes(Node node) {
    }

    public boolean isSubset(Style style) {
        return true;
    }
}

