/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.openoffice.xmerge.converter.xml.ParaStyle;
import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.TextStyle;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleCatalog {
    private ArrayList<Style> styles;

    public StyleCatalog(int initialEntries) {
        this.styles = new ArrayList(initialEntries);
    }

    public void add(Node node, String[] families, Class<?>[] classes, Class<?> defaultClass, boolean alwaysCreateDefault) {
        if (node == null) {
            return;
        }
        if (families == null) {
            families = new String[]{};
        }
        if (classes == null) {
            classes = new Class[]{};
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                boolean found = false;
                Node child = children.item(i);
                String name = child.getNodeName();
                if (!name.equals("style:default-style") && !name.equals("style:style")) continue;
                String familyName = this.getFamilyName(child);
                if (familyName == null) {
                    Debug.log(2, "familyName is null!");
                    continue;
                }
                for (int j = 0; j < families.length; ++j) {
                    if (!families[j].equals(familyName)) continue;
                    this.callConstructor(classes[j], child);
                    found = true;
                }
                if (found && !alwaysCreateDefault || defaultClass == null) continue;
                this.callConstructor(defaultClass, child);
            }
        }
    }

    private void callConstructor(Class<?> cls, Node node) {
        Class[] params = new Class[]{Node.class, this.getClass()};
        try {
            Constructor<?> c = cls.getConstructor(params);
            Object[] p = new Object[]{node, this};
            this.styles.add((Style)c.newInstance(p));
        }
        catch (Exception e) {
            Debug.log(2, "Exception when calling constructor", e);
        }
    }

    public void add(Style s) {
        this.styles.add(s);
    }

    public Style lookup(String name, String family, String parent, Class<?> styleClass) {
        int nStyles = this.styles.size();
        for (int i = 0; i < nStyles; ++i) {
            Style s = this.styles.get(i);
            if (name != null && s.getName() != null && !s.getName().equals(name) || family != null && s.getFamily() != null && !s.getFamily().equals(family) || parent != null && s.getParent() != null && !s.getParent().equals(parent) || styleClass != null && s.getClass() != styleClass || s.getName() == null) continue;
            return s;
        }
        return null;
    }

    public Style[] getMatching(Style s) {
        int matchCount = 0;
        int nStyles = this.styles.size();
        for (int j = 0; j < nStyles; ++j) {
            Style p = this.styles.get(j).getResolved();
            if (!p.isSubset(s)) continue;
            ++matchCount;
        }
        Style[] matchArray = new Style[matchCount];
        matchCount = 0;
        for (int j = 0; j < nStyles; ++j) {
            Style p = this.styles.get(j).getResolved();
            if (!p.isSubset(s)) continue;
            matchArray[matchCount++] = p;
        }
        return matchArray;
    }

    public Style getBestMatch(Style s) {
        return null;
    }

    public Element writeNode(Document parentDoc, String name) {
        Element rootNode = parentDoc.createElement(name);
        int len = this.styles.size();
        for (int j = 0; j < len; ++j) {
            Element propertiesNode;
            Style s = this.styles.get(j);
            Element styleNode = parentDoc.createElement("style:style");
            if (s.getName() != null) {
                styleNode.setAttribute("style:name", s.getName());
            }
            if (s.getParent() != null) {
                styleNode.setAttribute("style:parent-style-name", s.getParent());
            }
            if (s.getFamily() != null) {
                styleNode.setAttribute("style:family", s.getFamily());
            }
            if ((propertiesNode = (Element)s.createNode(parentDoc, "style:properties")) != null) {
                styleNode.appendChild(propertiesNode);
            }
            rootNode.appendChild(styleNode);
        }
        return rootNode;
    }

    public void dumpCSV(boolean para) {
        if (!para) {
            TextStyle.dumpHdr();
            int nStyles = this.styles.size();
            for (int i = 0; i < nStyles; ++i) {
                Style s = this.styles.get(i);
                if (!s.getClass().equals(TextStyle.class)) continue;
                ((TextStyle)s).dumpCSV();
            }
        } else {
            ParaStyle.dumpHdr();
            int nStyles = this.styles.size();
            for (int i = 0; i < nStyles; ++i) {
                Style s = this.styles.get(i);
                if (!s.getClass().equals(ParaStyle.class)) continue;
                ((ParaStyle)s).dumpCSV();
            }
        }
    }

    private String getFamilyName(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int len = attributes.getLength();
            for (int i = 0; i < len; ++i) {
                Node attr = attributes.item(i);
                if (!attr.getNodeName().equals("style:family")) continue;
                return attr.getNodeValue();
            }
        }
        return null;
    }
}

