/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import java.awt.Color;
import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextStyle
extends Style
implements Cloneable {
    protected static final int FIRST_ATTR = 1;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int STRIKETHRU = 8;
    public static final int SUPERSCRIPT = 16;
    public static final int SUBSCRIPT = 32;
    protected static final int LAST_ATTR = 32;
    protected int values = 0;
    protected int mask = 0;
    protected int sizeInPoints = 0;
    protected String fontName = null;
    protected Color fontColor = null;
    protected Color bgColor = null;
    private static String[] ignored = new String[]{"style:text-autospace", "style:text-underline-color", "fo:margin-left", "fo:margin-right", "fo:text-indent", "fo:margin-top", "fo:margin-bottom", "text:line-number", "text:number-lines", "style:country-asian", "style:font-size-asian", "style:font-name-complex", "style:language-complex", "style:country-complex", "style:font-size-complex", "style:punctuation-wrap", "fo:language", "fo:country", "style:font-name-asian", "style:language-asian", "style:line-break", "fo:keep-with-next"};

    public TextStyle(Node node, StyleCatalog sc) {
        super(node, sc);
        NamedNodeMap attrNodes = node.getAttributes();
        if (attrNodes != null) {
            int len = attrNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node attr = attrNodes.item(i);
                this.handleAttribute(attr.getNodeName(), attr.getNodeValue());
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                NamedNodeMap childAttrNodes;
                Node child = children.item(i);
                String name = child.getNodeName();
                if (!name.equals("style:properties") || (childAttrNodes = child.getAttributes()) == null) continue;
                int nChildAttrNodes = childAttrNodes.getLength();
                for (int j = 0; j < nChildAttrNodes; ++j) {
                    Node attr = childAttrNodes.item(j);
                    this.handleAttribute(attr.getNodeName(), attr.getNodeValue());
                }
            }
        }
    }

    public TextStyle(String name, String family, String parent, int mask, int values, int fontSize, String fontName, StyleCatalog sc) {
        super(name, family, parent, sc);
        this.mask = mask;
        this.values = values;
        this.sizeInPoints = fontSize;
        this.fontName = fontName;
    }

    private Color parseColorString(String value) {
        String r = value.substring(1, 3);
        String g = value.substring(3, 5);
        String b = value.substring(5, 7);
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            red = Integer.parseInt(r, 16);
            green = Integer.parseInt(g, 16);
            blue = Integer.parseInt(b, 16);
        }
        catch (NumberFormatException e) {
            Debug.log(2, "Problem parsing a color string", e);
        }
        return new Color(red, green, blue);
    }

    private void handleAttribute(String attr, String value) {
        if (attr.equals("fo:font-weight")) {
            if (value.equals("bold")) {
                this.turnAttributesOn(1);
            } else if (value.equals("normal")) {
                this.turnAttributesOff(1);
            }
        } else if (attr.equals("fo:font-style")) {
            if (value.equals("italic")) {
                this.turnAttributesOn(2);
            } else if (value.equals("oblique")) {
                this.turnAttributesOn(2);
            } else if (value.equals("normal")) {
                this.turnAttributesOff(2);
            }
        } else if (attr.equals("style:text-underline")) {
            if (value.equals("none")) {
                this.turnAttributesOff(4);
            } else {
                this.turnAttributesOn(4);
            }
        } else if (attr.equals("style:text-crossing-out")) {
            if (value.equals("none")) {
                this.turnAttributesOff(8);
            } else {
                this.turnAttributesOn(8);
            }
        } else if (attr.equals("style:text-position")) {
            if (value.startsWith("super ")) {
                this.turnAttributesOn(16);
            } else if (value.startsWith("sub ")) {
                this.turnAttributesOn(32);
            } else if (value.startsWith("0% ")) {
                this.turnAttributesOff(48);
            } else {
                String firstPart = value.substring(0, value.indexOf(" "));
                if (firstPart.endsWith("%")) {
                    int amount;
                    firstPart = firstPart.substring(0, value.indexOf("%"));
                    try {
                        amount = Integer.parseInt(firstPart);
                    }
                    catch (NumberFormatException e) {
                        amount = 0;
                        Debug.log(2, "Problem with style:text-position tag", e);
                    }
                    if (amount < 0) {
                        this.turnAttributesOn(32);
                    } else if (amount > 0) {
                        this.turnAttributesOn(16);
                    }
                }
            }
        } else if (attr.equals("fo:font-size")) {
            if (value.endsWith("pt")) {
                String num = value.substring(0, value.length() - 2);
                this.sizeInPoints = Integer.parseInt(num);
            }
        } else if (attr.equals("style:font-name")) {
            this.fontName = value;
        } else if (attr.equals("fo:color")) {
            this.fontColor = this.parseColorString(value);
        } else if (attr.equals("style:text-background-color")) {
            this.bgColor = this.parseColorString(value);
        } else if (!this.isIgnored(attr)) {
            Debug.log(1, "TextStyle Unhandled: " + attr + "=" + value);
        }
    }

    public boolean isSet(int attribute) {
        return (this.mask & attribute) != 0;
    }

    public boolean getAttribute(int attribute) {
        if ((this.mask & attribute) == 0) {
            return false;
        }
        return (this.values & attribute) != 0;
    }

    public int getFontSize() {
        return this.sizeInPoints;
    }

    public String getFontName() {
        return this.fontName;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    public void setColors(Color fontColor, Color backgroundColor) {
        if (fontColor != null) {
            this.fontColor = fontColor;
        }
        if (backgroundColor != null) {
            this.bgColor = backgroundColor;
        }
    }

    public Style getResolved() {
        TextStyle resolved = null;
        try {
            resolved = (TextStyle)this.clone();
        }
        catch (Exception e) {
            Debug.log(2, "Can't clone", e);
        }
        TextStyle parentStyle = null;
        if (this.sc != null) {
            if (this.parent != null) {
                parentStyle = (TextStyle)this.sc.lookup(this.parent, this.family, null, this.getClass());
                if (parentStyle == null) {
                    Debug.log(2, "parent style lookup of " + this.parent + " failed!");
                } else {
                    parentStyle = (TextStyle)parentStyle.getResolved();
                }
            } else if (!this.name.equals("DEFAULT_STYLE")) {
                parentStyle = (TextStyle)this.sc.lookup("DEFAULT_STYLE", null, null, this.getClass());
            }
        }
        if (parentStyle != null) {
            parentStyle = (TextStyle)parentStyle.getResolved();
            if (this.sizeInPoints == 0 && parentStyle.sizeInPoints != 0) {
                resolved.sizeInPoints = parentStyle.sizeInPoints;
            }
            if (this.fontName == null && parentStyle.fontName != null) {
                resolved.fontName = parentStyle.fontName;
            }
            if (this.fontColor == null && parentStyle.fontColor != null) {
                resolved.fontColor = parentStyle.fontColor;
            }
            if (this.bgColor == null && parentStyle.bgColor != null) {
                resolved.bgColor = parentStyle.bgColor;
            }
            for (int m = 1; m <= 32; m <<= 1) {
                if ((this.mask & m) != 0 || (parentStyle.mask & m) == 0) continue;
                resolved.mask |= m;
                resolved.values |= parentStyle.mask & m;
            }
        }
        return resolved;
    }

    private void turnAttributesOn(int flags) {
        this.mask |= flags;
        this.values |= flags;
    }

    private void turnAttributesOff(int flags) {
        this.mask |= flags;
        this.values &= ~flags;
    }

    private static String toCSV(String value) {
        if (value != null) {
            return "\"" + value + "\",";
        }
        return "\"\",";
    }

    private static String toLastCSV(String value) {
        if (value != null) {
            return "\"" + value + "\"";
        }
        return "\"\"";
    }

    public static void dumpHdr() {
        System.out.println(TextStyle.toCSV("Name") + TextStyle.toCSV("Family") + TextStyle.toCSV("parent") + TextStyle.toCSV("Font") + TextStyle.toCSV("Size") + TextStyle.toCSV("Bold") + TextStyle.toCSV("Italic") + TextStyle.toCSV("Underline") + TextStyle.toCSV("Strikethru") + TextStyle.toCSV("Superscript") + TextStyle.toLastCSV("Subscript"));
    }

    public void dumpCSV() {
        String attributes = "";
        for (int bitVal = 1; bitVal <= 32; bitVal <<= 1) {
            attributes = (bitVal & this.mask) != 0 ? attributes + TextStyle.toCSV((bitVal & this.values) != 0 ? "yes" : "no") : attributes + TextStyle.toCSV(null);
        }
        System.out.println(TextStyle.toCSV(this.name) + TextStyle.toCSV(this.family) + TextStyle.toCSV(this.parent) + TextStyle.toCSV(this.fontName) + TextStyle.toCSV("" + this.sizeInPoints) + attributes + TextStyle.toLastCSV(null));
    }

    public Node createNode(Document parentDoc, String name) {
        Element node = parentDoc.createElement(name);
        this.writeAttributes(node);
        return node;
    }

    public boolean isSubset(Style style) {
        if (style.getClass() != this.getClass()) {
            return false;
        }
        TextStyle tStyle = (TextStyle)style;
        if (tStyle.values != this.values) {
            return false;
        }
        if (tStyle.sizeInPoints != 0 && this.sizeInPoints != tStyle.sizeInPoints) {
            return false;
        }
        if (tStyle.fontName != null) {
            if (this.fontName == null) {
                return false;
            }
            if (!this.fontName.equals(tStyle.fontName)) {
                return false;
            }
        }
        if (tStyle.fontColor != null) {
            if (this.fontColor == null) {
                return false;
            }
            if (!this.fontColor.equals(tStyle.fontColor)) {
                return false;
            }
        }
        if (tStyle.bgColor != null) {
            if (this.bgColor == null) {
                return false;
            }
            if (!this.bgColor.equals(tStyle.bgColor)) {
                return false;
            }
        }
        return true;
    }

    public void writeAttributes(Element node) {
        if ((this.mask & 1) != 0 && (this.values & 1) != 0) {
            node.setAttribute("fo:font-weight", "bold");
        }
        if ((this.mask & 2) != 0 && (this.values & 2) != 0) {
            node.setAttribute("fo:font-style", "italic");
        }
        if ((this.mask & 4) != 0 && (this.values & 4) != 0) {
            node.setAttribute("style:text-underline", "single");
        }
        if ((this.mask & 8) != 0 && (this.values & 8) != 0) {
            node.setAttribute("style:text-crossing-out", "single-line");
        }
        if ((this.mask & 0x10) != 0 && (this.values & 0x10) != 0) {
            node.setAttribute("style:text-position", "super 58%");
        }
        if ((this.mask & 0x20) != 0 && (this.values & 0x20) != 0) {
            node.setAttribute("style:text-position", "sub 58%");
        }
        if (this.sizeInPoints != 0) {
            Integer fs = new Integer(this.sizeInPoints);
            node.setAttribute("fo:font-size", fs.toString() + "pt");
        }
        if (this.fontName != null) {
            node.setAttribute("style:font-name", this.fontName);
        }
        if (this.fontColor != null) {
            node.setAttribute("fo:color", this.buildColorString(this.fontColor));
        }
        if (this.bgColor != null) {
            node.setAttribute("style:text-background-color", this.buildColorString(this.bgColor));
        }
    }

    private String buildColorString(Color c) {
        int[] v = new int[]{c.getRed(), c.getGreen(), c.getBlue()};
        String colorString = new String("#");
        for (int i = 0; i <= 2; ++i) {
            String xx = Integer.toHexString(v[i]);
            if (xx.length() < 2) {
                xx = "0" + xx;
            }
            colorString = colorString + xx;
        }
        return colorString;
    }

    private boolean isIgnored(String attribute) {
        for (int i = 0; i < ignored.length; ++i) {
            if (!ignored[i].equals(attribute)) continue;
            return true;
        }
        return false;
    }
}

