/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.util.ArrayList;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.sxc.SheetSettings;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookSettings
implements OfficeConstants {
    private Document settings = null;
    private boolean hasColumnRowHeaders = true;
    private String activeSheet = new String();
    private ArrayList<SheetSettings> worksheetSettings = new ArrayList();

    public BookSettings(Node root) {
        this.readNode(root);
    }

    public BookSettings(ArrayList<SheetSettings> worksheetSettings) {
        this.worksheetSettings = worksheetSettings;
    }

    public void setColumnRowHeaders(boolean hasColumnRowHeaders) {
        this.hasColumnRowHeaders = hasColumnRowHeaders;
    }

    public boolean hasColumnRowHeaders() {
        return this.hasColumnRowHeaders;
    }

    public ArrayList<SheetSettings> getSheetSettings() {
        return this.worksheetSettings;
    }

    public String getActiveSheet() {
        return this.activeSheet;
    }

    public void setActiveSheet(String activeSheet) {
        this.activeSheet = activeSheet;
    }

    private void addConfigItem(Node root, String attribute, String type, String value) {
        Element configItem = this.settings.createElement("config:config-item");
        configItem.setAttribute("config:name", attribute);
        configItem.setAttribute("config:type", type);
        configItem.appendChild(this.settings.createTextNode(value));
        root.appendChild(configItem);
    }

    public void writeNode(Document settings, Node root) {
        this.settings = settings;
        Element configItemMapNamed = settings.createElement("config:config-item-map-named");
        configItemMapNamed.setAttribute("config:name", "Tables");
        for (SheetSettings s : this.worksheetSettings) {
            s.writeNode(settings, configItemMapNamed);
        }
        this.addConfigItem(root, "ActiveTable", "string", this.activeSheet);
        String booleanValue = Boolean.toString(this.hasColumnRowHeaders);
        this.addConfigItem(root, "HasColumnRowHeaders", "boolean", booleanValue);
        root.appendChild(configItemMapNamed);
    }

    public void addAttribute(String name, String value) {
        if (name.equals("ActiveTable")) {
            this.activeSheet = value;
        } else if (name.equals("HasColumnRowHeaders")) {
            Boolean b = Boolean.valueOf(value);
            this.hasColumnRowHeaders = b;
        }
    }

    public void readNode(Node root) {
        if (root.hasChildNodes()) {
            NodeList nodeList = root.getChildNodes();
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = nodeList.item(i);
                if (child.getNodeType() != 1) continue;
                String nodeName = child.getNodeName();
                if (nodeName.equals("config:config-item")) {
                    NamedNodeMap cellAtt = child.getAttributes();
                    Node configNameNode = cellAtt.getNamedItem("config:name");
                    String name = configNameNode.getNodeValue();
                    NodeList nodeList2 = child.getChildNodes();
                    int len2 = nodeList2.getLength();
                    String s = "";
                    for (int j = 0; j < len2; ++j) {
                        Node child2 = nodeList2.item(j);
                        if (child2.getNodeType() != 3) continue;
                        s = child2.getNodeValue();
                    }
                    this.addAttribute(name, s);
                    continue;
                }
                if (nodeName.equals("config:config-item-map-named")) {
                    this.readNode(child);
                    continue;
                }
                if (nodeName.equals("config:config-item-map-entry")) {
                    SheetSettings s = new SheetSettings(child);
                    this.worksheetSettings.add(s);
                    continue;
                }
                Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(child) + " />");
            }
        }
    }
}

