/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.TwipsConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ColumnStyle
extends Style
implements Cloneable {
    private int colWidth = 0;

    public ColumnStyle(Node node, StyleCatalog sc) {
        super(node, sc);
        NamedNodeMap attrNodes = node.getAttributes();
        if (attrNodes != null) {
            int len = attrNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node attr = attrNodes.item(i);
                this.handleAttribute(attr.getNodeName(), attr.getNodeValue());
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                NamedNodeMap childAttrNodes;
                Node child = children.item(i);
                String name = child.getNodeName();
                if (!name.equals("style:properties") || (childAttrNodes = child.getAttributes()) == null) continue;
                int nChildAttrNodes = childAttrNodes.getLength();
                for (int j = 0; j < nChildAttrNodes; ++j) {
                    Node attr = childAttrNodes.item(j);
                    this.handleAttribute(attr.getNodeName(), attr.getNodeValue());
                }
            }
        }
    }

    public ColumnStyle(String name, String family, String parent, int colWidth, StyleCatalog sc) {
        super(name, family, parent, sc);
        this.colWidth = colWidth;
    }

    public int getColWidth() {
        return this.colWidth;
    }

    public void setColWidth(int colWidth) {
        this.colWidth = colWidth;
    }

    private int parseColWidth(String value) {
        int width = 255;
        if (value.indexOf("cm") != -1) {
            float widthCM = Float.parseFloat(value.substring(0, value.indexOf("c")));
            width = TwipsConverter.cm2twips(widthCM);
        } else if (value.indexOf("inch") != -1) {
            float widthInch = Float.parseFloat(value.substring(0, value.indexOf("i")));
            width = TwipsConverter.inches2twips(widthInch);
        }
        return width;
    }

    private void handleAttribute(String attr, String value) {
        if (attr.equals("style:column-width")) {
            this.colWidth = this.parseColWidth(value);
        } else {
            Debug.log(1, "ColumnStyle Unhandled: " + attr + "=" + value);
        }
    }

    public Style getResolved() {
        ColumnStyle resolved = null;
        try {
            resolved = (ColumnStyle)this.clone();
        }
        catch (Exception e) {
            Debug.log(2, "Can't clone", e);
        }
        ColumnStyle parentStyle = null;
        if (this.sc != null) {
            if (this.parent != null) {
                parentStyle = (ColumnStyle)this.sc.lookup(this.parent, this.family, null, this.getClass());
                if (parentStyle == null) {
                    Debug.log(2, "parent style lookup of " + this.parent + " failed!");
                } else {
                    parentStyle = (ColumnStyle)parentStyle.getResolved();
                }
            } else if (!this.name.equals("DEFAULT_STYLE")) {
                parentStyle = (ColumnStyle)this.sc.lookup("DEFAULT_STYLE", null, null, this.getClass());
            }
        }
        if (parentStyle != null) {
            parentStyle = (ColumnStyle)parentStyle.getResolved();
            if (this.colWidth == 0 && parentStyle.getColWidth() != 0) {
                resolved.setColWidth(parentStyle.getColWidth());
            }
        }
        return resolved;
    }

    public Node createNode(Document parentDoc, String name) {
        Element node = parentDoc.createElement(name);
        this.writeAttributes(node);
        return node;
    }

    public boolean isSubset(Style style) {
        if (style.getClass() != this.getClass()) {
            return false;
        }
        ColumnStyle tStyle = (ColumnStyle)style;
        return this.colWidth == tStyle.getColWidth();
    }

    public void writeAttributes(Element node) {
        if (this.colWidth != 0) {
            String width = TwipsConverter.twips2cm(this.colWidth) + "cm";
            node.setAttribute("style:column-width", width);
        }
    }
}

