/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentMerger;
import org.openoffice.xmerge.MergeException;
import org.openoffice.xmerge.converter.xml.sxc.SxcDocument;
import org.openoffice.xmerge.merger.Difference;
import org.openoffice.xmerge.merger.diff.IteratorRowCompare;
import org.openoffice.xmerge.merger.diff.RowIterator;
import org.openoffice.xmerge.merger.merge.PositionBaseRowMerge;
import org.openoffice.xmerge.merger.merge.SheetMerge;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentMergerImpl
implements DocumentMerger {
    private ConverterCapabilities cc_;
    private Document orig = null;

    public DocumentMergerImpl(Document doc, ConverterCapabilities cc) {
        this.cc_ = cc;
        this.orig = doc;
    }

    public void merge(Document modifiedDoc) throws MergeException {
        SxcDocument sdoc1 = (SxcDocument)this.orig;
        SxcDocument sdoc2 = (SxcDocument)modifiedDoc;
        org.w3c.dom.Document doc1 = sdoc1.getContentDOM();
        org.w3c.dom.Document doc2 = sdoc2.getContentDOM();
        Element elem1 = doc1.getDocumentElement();
        Element elem2 = doc2.getDocumentElement();
        NodeList workSheetList1 = elem1.getElementsByTagName("table:table");
        NodeList workSheetList2 = elem2.getElementsByTagName("table:table");
        int numOfWorkSheet = workSheetList1.getLength();
        for (int i = 0; i < numOfWorkSheet; ++i) {
            Node workSheet = workSheetList1.item(i);
            Node matchingWorkSheet = this.matchWorkSheet(workSheet, workSheetList2);
            if (matchingWorkSheet == null) continue;
            RowIterator i1 = new RowIterator(this.cc_, workSheet);
            RowIterator i2 = new RowIterator(this.cc_, matchingWorkSheet);
            IteratorRowCompare diffAlgo = new IteratorRowCompare();
            Difference[] diffResult = diffAlgo.computeDiffs(i1, i2);
            if (Debug.isFlagSet(1)) {
                Debug.log(1, "Diff Result: ");
                for (int j = 0; j < diffResult.length; ++j) {
                    Debug.log(1, diffResult[j].debug());
                }
            }
            PositionBaseRowMerge rowMerger = new PositionBaseRowMerge(this.cc_);
            SheetMerge merger = new SheetMerge(this.cc_, rowMerger);
            merger.applyDifference(i1, i2, diffResult);
        }
        numOfWorkSheet = workSheetList2.getLength();
        NodeList officeBodyList = elem1.getElementsByTagName("office:body");
        Node officeBody = officeBodyList.item(0);
        for (int j = 0; j < numOfWorkSheet; ++j) {
            Node workSheet = workSheetList2.item(j);
            Node matchingWorkSheet = this.matchWorkSheet(workSheet, workSheetList1);
            if (matchingWorkSheet != null) continue;
            Node cloneNode = XmlUtil.deepClone(officeBody, workSheet);
            officeBody.appendChild(cloneNode);
        }
    }

    private Node matchWorkSheet(Node orgSheet, NodeList modSheetList) {
        Node matchSheet = null;
        String orgTableName = ((Element)orgSheet).getAttribute("table:name");
        if (orgTableName == null) {
            return null;
        }
        int numOfWorkSheet = modSheetList.getLength();
        for (int i = 0; i < numOfWorkSheet; ++i) {
            String modTableName = ((Element)modSheetList.item(i)).getAttribute("table:name");
            if (modTableName == null || !orgTableName.equals(modTableName)) continue;
            matchSheet = modSheetList.item(i);
            break;
        }
        return matchSheet;
    }
}

