/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import java.util.ArrayList;
import java.util.List;
import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.merger.Iterator;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.Resources;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeIterator
implements Iterator {
    private List<Node> nodeList = null;
    private int currentPosition = 0;
    private Node root;
    private ConverterCapabilities cc_ = null;

    public NodeIterator(ConverterCapabilities cc, Node node) {
        this.cc_ = cc;
        this.nodeList = new ArrayList<Node>();
        this.root = node;
        this.markTree(node);
    }

    public Object next() {
        if (this.currentPosition < this.nodeList.size() - 1) {
            ++this.currentPosition;
            return this.currentElement();
        }
        return null;
    }

    public Object previous() {
        if (this.currentPosition > 0) {
            --this.currentPosition;
            return this.currentElement();
        }
        return null;
    }

    public Object start() {
        this.currentPosition = 0;
        return this.currentElement();
    }

    public Object end() {
        int size = this.nodeList.size();
        if (size > 0) {
            this.currentPosition = size - 1;
            return this.currentElement();
        }
        return null;
    }

    public Object currentElement() {
        if (this.currentPosition < 0 || this.currentPosition >= this.nodeList.size()) {
            return null;
        }
        return this.nodeList.get(this.currentPosition);
    }

    public int elementCount() {
        return this.nodeList.size();
    }

    public boolean equivalent(Object obj1, Object obj2) {
        boolean equal = false;
        String errMsg = null;
        if (!(obj1 instanceof Node) || !(obj2 instanceof Node)) {
            errMsg = Resources.getInstance().getString("NOT_NODE_ERROR");
            Debug.log(2, errMsg);
        } else {
            Node node1 = (Node)obj1;
            Node node2 = (Node)obj2;
            equal = this.compareNode(node1, node2);
        }
        return equal;
    }

    public void refresh() {
        this.nodeList = new ArrayList<Node>();
        this.markTree(this.root);
        this.currentPosition = 0;
    }

    protected boolean compareNode(Node node1, Node node2) {
        boolean equal = false;
        if (node1 != null && node2 != null && node1.getNodeType() == node2.getNodeType() && node1.getNodeName().equals(node2.getNodeName()) && (node1.getNodeValue() == null && node2.getNodeValue() == null || node1.getNodeValue() != null && node2.getNodeValue() != null && node1.getNodeValue().equals(node2.getNodeValue())) && this.attributesEqual(node1, node2)) {
            if (!node1.hasChildNodes() && !node2.hasChildNodes()) {
                equal = true;
            } else if (!node1.hasChildNodes() || !node2.hasChildNodes()) {
                equal = false;
            } else if (this.childrenEqual(node1, node2)) {
                equal = true;
            }
        }
        return equal;
    }

    protected boolean childrenEqual(Node node1, Node node2) {
        boolean equal = false;
        NodeList node1Children = node1.getChildNodes();
        NodeList node2Children = node2.getChildNodes();
        if (node1Children != null && node2Children != null && node1Children.getLength() == node2Children.getLength()) {
            equal = true;
            for (int i = 0; i < node1Children.getLength(); ++i) {
                if (this.compareNode(node1Children.item(i), node2Children.item(i))) continue;
                equal = false;
                break;
            }
        }
        return equal;
    }

    protected boolean attributesEqual(Node node1, Node node2) {
        boolean equal;
        block8: {
            equal = false;
            String nodeName = node1.getNodeName();
            NamedNodeMap[] attrNode = new NamedNodeMap[]{node1.getAttributes(), node2.getAttributes()};
            if (attrNode[0] == null || attrNode[1] == null) {
                if (attrNode[0] == null && attrNode[1] == null) {
                    equal = true;
                }
                return equal;
            }
            int[] len = new int[2];
            for (int i = 0; i < 2; ++i) {
                int dst;
                int src;
                if (i == 0) {
                    src = 0;
                    dst = 1;
                } else {
                    src = 1;
                    dst = 0;
                }
                len[src] = attrNode[src].getLength();
                for (int j = 0; j < len[src]; ++j) {
                    Node srcAttr = attrNode[src].item(j);
                    String srcAttrName = srcAttr.getNodeName();
                    if (this.cc_ != null && !this.cc_.canConvertAttribute(nodeName, srcAttrName)) continue;
                    Node dstAttr = attrNode[dst].getNamedItem(srcAttrName);
                    if (dstAttr == null) {
                        Debug.log(1, "[NodeIterator] Attr not exist in dst - " + srcAttrName);
                    } else {
                        if (srcAttr.getNodeValue().equals(dstAttr.getNodeValue())) continue;
                        Debug.log(1, "[NodeIterator] Attr diff src: " + srcAttr.getNodeValue() + " dst: " + dstAttr.getNodeValue());
                    }
                    break block8;
                }
            }
            equal = true;
        }
        return equal;
    }

    protected abstract boolean nodeSupported(Node var1);

    private void markTree(Node node) {
        if (this.nodeSupported(node)) {
            this.nodeList.add(node);
        } else {
            String nodeName = node.getNodeName();
            if (this.cc_ == null || this.cc_.canConvertTag(nodeName)) {
                NodeList nodeList = node.getChildNodes();
                int nodeListLength = nodeList.getLength();
                for (int i = 0; i < nodeListLength; ++i) {
                    this.markTree(nodeList.item(i));
                }
            } else {
                Debug.log(1, " [NodeIterator::markTree] Skipping node " + nodeName);
            }
        }
    }
}

