/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.merge;

import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.MergeException;
import org.openoffice.xmerge.merger.Difference;
import org.openoffice.xmerge.merger.Iterator;
import org.openoffice.xmerge.merger.MergeAlgorithm;
import org.openoffice.xmerge.merger.NodeMergeAlgorithm;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentMerge
implements MergeAlgorithm {
    private NodeMergeAlgorithm subDocumentMerge = null;
    protected ConverterCapabilities cc_;

    public DocumentMerge(ConverterCapabilities cc, NodeMergeAlgorithm merge) {
        this.cc_ = cc;
        this.subDocumentMerge = merge;
    }

    public void applyDifference(Iterator orgSeq, Iterator modSeq, Difference[] differences) throws MergeException {
        int currentPosition = -1;
        boolean haveDeleteOperation = false;
        for (int i = 0; i < differences.length; ++i) {
            if (differences[i].getOrgPosition() > currentPosition) {
                currentPosition = differences[i].getOrgPosition();
                if (differences[i].getOperation() == 2) {
                    haveDeleteOperation = true;
                    continue;
                }
                haveDeleteOperation = false;
                continue;
            }
            if (differences[i].getOrgPosition() == currentPosition) {
                if (differences[i].getOperation() == 2) {
                    haveDeleteOperation = true;
                    continue;
                }
                if (differences[i].getOperation() != 1 || !haveDeleteOperation) continue;
                throw new MergeException("Differences array is not sorted. Delete before Add");
            }
            throw new MergeException("Differences array need to be sorted.");
        }
        orgSeq.start();
        int orgSeqCounter = 0;
        modSeq.start();
        int modSeqCounter = 0;
        block6: for (int i = 0; i < differences.length; ++i) {
            Difference currentDiff = differences[i];
            int operation = currentDiff.getOperation();
            switch (operation) {
                case 2: {
                    while (orgSeqCounter < currentDiff.getOrgPosition()) {
                        ++orgSeqCounter;
                        orgSeq.next();
                    }
                    this.removeNode((Node)orgSeq.currentElement());
                    continue block6;
                }
                case 1: {
                    while (modSeqCounter < currentDiff.getModPosition()) {
                        ++modSeqCounter;
                        modSeq.next();
                    }
                    while (orgSeqCounter < currentDiff.getOrgPosition()) {
                        ++orgSeqCounter;
                        orgSeq.next();
                    }
                    if (orgSeqCounter > orgSeq.elementCount() - 1) {
                        this.appendNode((Node)orgSeq.currentElement(), (Node)modSeq.currentElement());
                        continue block6;
                    }
                    this.insertNode((Node)orgSeq.currentElement(), (Node)modSeq.currentElement());
                    continue block6;
                }
                case 3: {
                    while (modSeqCounter < currentDiff.getModPosition()) {
                        ++modSeqCounter;
                        modSeq.next();
                    }
                    while (orgSeqCounter < currentDiff.getOrgPosition()) {
                        ++orgSeqCounter;
                        orgSeq.next();
                    }
                    if (this.subDocumentMerge == null) {
                        this.replaceElement((Element)orgSeq.currentElement(), (Element)modSeq.currentElement());
                        continue block6;
                    }
                    this.subDocumentMerge.merge((Element)orgSeq.currentElement(), (Element)modSeq.currentElement());
                    continue block6;
                }
            }
        }
    }

    protected void removeNode(Node node) {
        Node parent = node.getParentNode();
        parent.removeChild(node);
    }

    protected void appendNode(Node oldNode, Node newNode) {
        Node clonedNode = XmlUtil.deepClone(oldNode, newNode);
        Node parent = oldNode.getParentNode();
        parent.appendChild(clonedNode);
    }

    protected void insertNode(Node oldNode, Node newNode) {
        Node clonedNode = XmlUtil.deepClone(oldNode, newNode);
        Node parent = oldNode.getParentNode();
        parent.insertBefore(clonedNode, oldNode);
    }

    protected void replaceElement(Element currElem, Element newElem) {
        Node clonedNode = XmlUtil.deepClone(currElem, newElem);
        Node parent = currElem.getParentNode();
        parent.replaceChild(clonedNode, currElem);
    }
}

