/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.StringTokenizer;
import org.openoffice.xmerge.Convert;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConverterFactory;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.util.registry.ConverterInfoMgr;
import org.openoffice.xmerge.util.registry.ConverterInfoReader;

public class ActiveSyncDriver {
    public static void main(String[] args) {
        if (args.length != 4) {
            return;
        }
        ActiveSyncDriver asd = new ActiveSyncDriver();
        try {
            asd.Convert(args[0], args[1], args[2], args[3]);
        }
        catch (Exception e) {
            return;
        }
    }

    private boolean Convert(String srcMime, String dstMime, String srcFile, String dstFile) throws Exception {
        ConvertData dataOut;
        String ooClassDir = null;
        String strClassPath = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(strClassPath, ";");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (!s.endsWith("xmerge.jar")) continue;
            ooClassDir = s.substring(0, s.indexOf("xmerge.jar"));
        }
        if (ooClassDir == null) {
            return true;
        }
        File pluginJar = null;
        if (srcMime.equals("staroffice/sxw") || srcMime.equals("application/x-pocket-word")) {
            pluginJar = new File(ooClassDir + "pocketWord.jar");
        } else if (srcMime.equals("staroffice/sxc") || srcMime.equals("application/x-pocket-excel")) {
            pluginJar = new File(ooClassDir + "pexcel.jar");
        }
        ConverterInfoReader cirPlugin = new ConverterInfoReader(pluginJar.toURI().toURL().toString(), false);
        ConverterInfoMgr.addPlugIn(cirPlugin.getConverterInfoEnumeration());
        ConverterFactory cf = new ConverterFactory();
        Convert conv = cf.getConverter(srcMime, dstMime);
        if (conv == null) {
            return false;
        }
        FileInputStream fis = new FileInputStream(srcFile);
        FileOutputStream fos = new FileOutputStream(dstFile);
        conv.addInputStream(srcFile, fis);
        try {
            dataOut = conv.convert();
        }
        catch (Exception e) {
            fos.close();
            return false;
        }
        if (dataOut == null) {
            fos.close();
            return false;
        }
        Document doc = (Document)dataOut.getDocumentEnumeration().next();
        if (doc == null) {
            fos.close();
            return false;
        }
        doc.write(fos);
        fos.flush();
        fos.close();
        return true;
    }
}

