/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public final class Debug {
    public static final int INFO = 1;
    public static final int ERROR = 2;
    public static final int TRACE = 4;
    public static final boolean SET = true;
    public static final boolean UNSET = false;
    private static int flags = 0;
    private static PrintWriter writer = null;

    private Debug() {
    }

    private static void setOutput(String str) {
        if (writer == null) {
            if (str.equals("System.out")) {
                Debug.setOutput(System.out);
            } else if (str.equals("System.err")) {
                Debug.setOutput(System.err);
            } else {
                try {
                    Debug.setOutput(new FileWriter(str));
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    private static void setOutput(OutputStream stream) {
        Debug.setOutput(new OutputStreamWriter(stream));
    }

    private static void setOutput(Writer w) {
        if (writer != null) {
            writer.close();
        }
        writer = new PrintWriter((Writer)new BufferedWriter(w), true);
    }

    private static void setFlags(int f, boolean set) {
        flags = set ? (flags |= f) : (flags &= ~f);
    }

    public static void logSystemInfo() {
        if (writer != null) {
            writer.println();
            writer.println("Platform Information:");
            writer.println("OS          : " + System.getProperty("os.name"));
            writer.println("Version     : " + System.getProperty("os.version"));
            writer.println("Platform    : " + System.getProperty("os.arch"));
            writer.println("JDK Version : " + System.getProperty("java.version"));
            writer.println("JDK Vendor  : " + System.getProperty("java.vendor"));
            writer.println();
        }
    }

    public static void logTime() {
        if (writer != null) {
            Date time = Calendar.getInstance().getTime();
            DateFormat dt = DateFormat.getDateTimeInstance(0, 0);
            writer.println(dt.format(time));
        }
    }

    public static boolean isFlagSet(int f) {
        return (flags & f) != 0;
    }

    public static void log(int flag, String msg) {
        if (Debug.isFlagSet(flag) && writer != null) {
            writer.println(msg);
        }
    }

    public static void log(int flag, String msg, Throwable e) {
        if (Debug.isFlagSet(flag) && writer != null) {
            writer.println(msg);
            if (e != null) {
                e.printStackTrace(writer);
            }
        }
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int ch = bytes[i] & 0xFF;
            String str = Integer.toHexString(ch);
            if (str.length() < 2) {
                buff.append('0');
            }
            buff.append(str);
            buff.append(' ');
        }
        return buff.toString();
    }

    static {
        try {
            Class<?> c = new Debug().getClass();
            InputStream is = c.getResourceAsStream("Debug.properties");
            Properties props = new Properties();
            props.load(is);
            String info = props.getProperty("debug.info", "false");
            info = info.toLowerCase();
            if (info.equals("true")) {
                Debug.setFlags(1, true);
            }
            String trace = props.getProperty("debug.trace", "false");
            if ((trace = trace.toLowerCase()).equals("true")) {
                Debug.setFlags(4, true);
            }
            String error = props.getProperty("debug.error", "false");
            if ((error = error.toLowerCase()).equals("true")) {
                Debug.setFlags(2, true);
            }
            String w = props.getProperty("debug.output", "System.out");
            Debug.setOutput(w);
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
        }
    }
}

