/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

public class EndianConverter {
    public static byte[] writeShort(short value) {
        byte[] leShort = new byte[]{(byte)value, (byte)(value >>> 8)};
        return leShort;
    }

    public static byte[] writeInt(int value) {
        byte[] leInt = new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24)};
        return leInt;
    }

    public static byte[] writeDouble(double value) {
        long myDouble = Double.doubleToLongBits(value);
        byte[] leDouble = new byte[]{(byte)(myDouble >>> 0), (byte)(myDouble >>> 8), (byte)(myDouble >>> 16), (byte)(myDouble >>> 24), (byte)(myDouble >>> 32), (byte)(myDouble >>> 40), (byte)(myDouble >>> 48), (byte)(myDouble >>> 56)};
        return leDouble;
    }

    public static short readShort(byte[] value) {
        int high = value[1] & 0xFF;
        int low = value[0] & 0xFF;
        return (short)(high << 8 | low);
    }

    public static int readInt(byte[] value) {
        int number = 0;
        for (int i = 0; i < 4; ++i) {
            number |= (value[i] & 0xFF) << i * 8;
        }
        return number;
    }

    public static double readDouble(byte[] value) {
        long lvalue = ((long)value[7] << 56) + ((long)(value[6] & 0xFF) << 48) + ((long)(value[5] & 0xFF) << 40) + ((long)(value[4] & 0xFF) << 32) + ((long)(value[3] & 0xFF) << 24) + ((long)(value[2] & 0xFF) << 16) + ((long)(value[1] & 0xFF) << 8) + (long)(value[0] & 0xFF);
        return Double.longBitsToDouble(lvalue);
    }
}

