/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.report;

import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.QueryMetaData;
import com.sun.star.wizards.report.IReportDocument;
import com.sun.star.wizards.report.ReportWizard;
import com.sun.star.wizards.ui.FieldSelection;
import com.sun.star.wizards.ui.WizardDialog;
import com.sun.star.wizards.ui.XFieldSelectionListener;
import java.util.ArrayList;

public class GroupFieldHandler
extends FieldSelection {
    private IReportDocument CurReportDocument;
    private ArrayList<String> GroupFieldVector = new ArrayList();
    private QueryMetaData CurDBMetaData;
    private WizardDialog oWizardDialog;
    private static final short MAXSELFIELDS = 4;

    public GroupFieldHandler(IReportDocument _CurReportDocument, WizardDialog _CurUnoDialog) {
        super(_CurUnoDialog, 3, 95, 27, 210, 127, _CurUnoDialog.m_oResource.getResText(2419), _CurUnoDialog.m_oResource.getResText(2450), 34340, false);
        try {
            this.oWizardDialog = _CurUnoDialog;
            this.CurReportDocument = _CurReportDocument;
            this.CurDBMetaData = this.CurReportDocument.getRecordParser();
            this.CurUnoDialog.setControlProperty("lstFields_2", "MultiSelection", Boolean.FALSE);
            this.CurUnoDialog.setControlProperty("lstSelFields_2", "MultiSelection", Boolean.FALSE);
            this.addFieldSelectionListener(new FieldSelectionListener());
            String sNote = ReportWizard.getBlindTextNote(_CurReportDocument, _CurUnoDialog.m_oResource);
            this.CurUnoDialog.insertControlModel("com.sun.star.awt.UnoControlFixedTextModel", "lblBlindTextNote_1", new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_MULTILINE, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_WIDTH}, new Object[]{Boolean.FALSE, 18, sNote, Boolean.TRUE, 95, 158, new Integer(3), 209});
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public boolean isGroupField(String _FieldName) {
        return JavaTools.FieldInList(this.CurDBMetaData.GroupFieldNames, _FieldName) != -1;
    }

    public void initialize() {
        try {
            ArrayList<String> NormalFieldsVector = new ArrayList<String>();
            ArrayList<String> SelFieldsVector = new ArrayList<String>();
            String[] sFieldNames = this.CurDBMetaData.getFieldNames();
            for (int i = 0; i < sFieldNames.length; ++i) {
                String sfieldtitle = sFieldNames[i];
                if (this.isGroupField(sFieldNames[i])) {
                    SelFieldsVector.add(sfieldtitle);
                    continue;
                }
                NormalFieldsVector.add(sfieldtitle);
            }
            String[] SelFields = new String[SelFieldsVector.size()];
            SelFieldsVector.toArray(SelFields);
            String[] NormalFields = new String[NormalFieldsVector.size()];
            NormalFieldsVector.toArray(NormalFields);
            super.initialize(NormalFields, SelFields, true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void removeGroupFieldNames() {
        this.emptyFieldsListBoxes();
        this.GroupFieldVector.clear();
        this.CurUnoDialog.setControlProperty("lblBlindTextNote_1", PropertyNames.PROPERTY_ENABLED, Boolean.FALSE);
    }

    public void getGroupFieldNames(CommandMetaData CurDBMetaData) {
        String[] GroupFieldNames = new String[this.GroupFieldVector.size()];
        this.GroupFieldVector.toArray(GroupFieldNames);
        CurDBMetaData.GroupFieldNames = GroupFieldNames;
    }

    protected void toggleListboxButtons(short iFieldsSelIndex, short iSelFieldsSelIndex) {
        super.toggleListboxButtons(iFieldsSelIndex, iSelFieldsSelIndex);
        short iSelCount = this.xSelectedFieldsListBox.getItemCount();
        if (iSelCount >= 4) {
            this.CurUnoDialog.setControlProperty("cmdMoveSelected" + this.sIncSuffix, PropertyNames.PROPERTY_ENABLED, Boolean.FALSE);
        }
    }

    public void selectFields(boolean bMoveAll) {
        short iSelCount = this.xSelectedFieldsListBox.getItemCount();
        if (iSelCount < 4) {
            super.selectFields(bMoveAll);
        }
    }

    class FieldSelectionListener
    implements XFieldSelectionListener {
        FieldSelectionListener() {
        }

        public void moveItemDown(String Selitem) {
            GroupFieldHandler.this.CurReportDocument.refreshGroupFields(GroupFieldHandler.this.xSelectedFieldsListBox.getItems());
        }

        public void moveItemUp(String item) {
            GroupFieldHandler.this.CurReportDocument.refreshGroupFields(GroupFieldHandler.this.xSelectedFieldsListBox.getItems());
        }

        public void shiftFromLeftToRight(String[] Selitems, String[] Newitems) {
            String CurGroupTitle = Selitems[0];
            short iSelCount = GroupFieldHandler.this.xSelectedFieldsListBox.getItemCount();
            String[] CurGroupNames = GroupFieldHandler.this.xFieldsListBox.getItems();
            GroupFieldHandler.this.CurReportDocument.liveupdate_addGroupNametoDocument(CurGroupNames, CurGroupTitle, GroupFieldHandler.this.GroupFieldVector, GroupFieldHandler.this.CurReportDocument.getReportPath(), iSelCount);
            GroupFieldHandler.this.CurUnoDialog.setControlProperty("lblBlindTextNote_1", PropertyNames.PROPERTY_ENABLED, Boolean.TRUE);
            if (iSelCount >= 4) {
                GroupFieldHandler.this.toggleMoveButtons(false, false);
            }
        }

        public void shiftFromRightToLeft(String[] OldSelitems, String[] Newitems) {
            int iSelPos = OldSelitems.length;
            if (iSelPos > 0) {
                String OldGroupTitle = OldSelitems[0];
                String[] NewSelList = GroupFieldHandler.this.xSelectedFieldsListBox.getItems();
                GroupFieldHandler.this.CurReportDocument.liveupdate_removeGroupName(NewSelList, OldGroupTitle, GroupFieldHandler.this.GroupFieldVector);
                String[] NewSelGroupNames = GroupFieldHandler.this.xSelectedFieldsListBox.getItems();
                GroupFieldHandler.this.CurUnoDialog.setControlProperty("lblBlindTextNote_1", PropertyNames.PROPERTY_ENABLED, NewSelGroupNames.length == 0);
            }
        }

        public int getID() {
            return 2;
        }

        public void setID(String sIncSuffix) {
        }
    }
}

