/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lib.uno.helper.PropertySetMixin;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.report.meta.XFunctionCategory;
import com.sun.star.report.meta.XFunctionDescription;
import com.sun.star.uno.Type;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.util.Locale;
import java.util.MissingResourceException;
import org.libreoffice.report.pentaho.StarFunctionDescription;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.function.FunctionCategory;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;

public final class StarFunctionCategory
extends WeakBase
implements XFunctionCategory {
    private final XComponentContext m_xContext;
    private final PropertySetMixin m_prophlp;
    private final int m_Number;
    private final FunctionCategory category;
    private final FunctionRegistry functionRegistry;
    private final String[] functions;
    private final DefaultFormulaContext defaultContext;
    private final Locale defaultLocale;

    public StarFunctionCategory(DefaultFormulaContext defaultContext, XComponentContext context, FunctionRegistry functionRegistry, int _number, FunctionCategory category) {
        Locale locale;
        this.defaultContext = defaultContext;
        this.m_xContext = context;
        this.m_Number = _number;
        this.category = category;
        this.functionRegistry = functionRegistry;
        try {
            category.getDisplayName(defaultContext.getLocalizationContext().getLocale());
            locale = defaultContext.getLocalizationContext().getLocale();
        }
        catch (MissingResourceException e) {
            locale = Locale.ENGLISH;
            try {
                category.getDisplayName(locale);
            }
            catch (MissingResourceException e2) {
                // empty catch block
            }
        }
        this.defaultLocale = locale;
        this.functions = functionRegistry.getFunctionNamesByCategory(category);
        this.m_prophlp = new PropertySetMixin(this.m_xContext, (XInterface)this, new Type(XFunctionCategory.class), null);
    }

    public XPropertySetInfo getPropertySetInfo() {
        return this.m_prophlp.getPropertySetInfo();
    }

    public void setPropertyValue(String aPropertyName, Object aValue) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.m_prophlp.setPropertyValue(aPropertyName, aValue);
    }

    public Object getPropertyValue(String aPropertyName) throws UnknownPropertyException, WrappedTargetException {
        return this.m_prophlp.getPropertyValue(aPropertyName);
    }

    public void addPropertyChangeListener(String aPropertyName, XPropertyChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.addPropertyChangeListener(aPropertyName, xListener);
    }

    public void removePropertyChangeListener(String aPropertyName, XPropertyChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.removePropertyChangeListener(aPropertyName, xListener);
    }

    public void addVetoableChangeListener(String aPropertyName, XVetoableChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.addVetoableChangeListener(aPropertyName, xListener);
    }

    public void removeVetoableChangeListener(String aPropertyName, XVetoableChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.removeVetoableChangeListener(aPropertyName, xListener);
    }

    public Type getElementType() {
        return new Type(XFunctionDescription.class);
    }

    public boolean hasElements() {
        return this.functions.length != 0;
    }

    public int getCount() {
        return this.functions.length;
    }

    public Object getByIndex(int Index) throws IndexOutOfBoundsException, WrappedTargetException {
        return this.getFunction(Index);
    }

    public int getNumber() {
        return this.m_Number;
    }

    public String getName() {
        try {
            return this.category.getDisplayName(this.defaultLocale);
        }
        catch (Exception exception) {
            return "Missing category for number " + this.m_Number;
        }
    }

    public XFunctionDescription getFunction(int position) throws IndexOutOfBoundsException, WrappedTargetException {
        if (position >= this.functions.length) {
            throw new java.lang.IndexOutOfBoundsException();
        }
        return new StarFunctionDescription(this.defaultContext, this.m_xContext, this, this.functionRegistry.getMetaData(this.functions[position]));
    }
}

