/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lib.uno.helper.PropertySetMixin;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.report.meta.XFunctionCategory;
import com.sun.star.report.meta.XFunctionDescription;
import com.sun.star.sheet.FunctionArgument;
import com.sun.star.uno.Type;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.util.Locale;
import java.util.MissingResourceException;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;

public final class StarFunctionDescription
extends WeakBase
implements XFunctionDescription {
    private final XComponentContext m_xContext;
    private final PropertySetMixin m_prophlp;
    private final FunctionDescription functionDescription;
    private final XFunctionCategory category;
    private final Locale defaultLocale;

    public StarFunctionDescription(DefaultFormulaContext defaultContext, XComponentContext context, XFunctionCategory category, FunctionDescription functionDescription) {
        Locale locale;
        this.m_xContext = context;
        this.category = category;
        try {
            functionDescription.getDisplayName(defaultContext.getLocalizationContext().getLocale());
            locale = defaultContext.getLocalizationContext().getLocale();
        }
        catch (MissingResourceException e) {
            locale = Locale.ENGLISH;
        }
        this.defaultLocale = locale;
        this.functionDescription = functionDescription;
        this.m_prophlp = new PropertySetMixin(this.m_xContext, (XInterface)this, new Type(XFunctionDescription.class), null);
    }

    public XPropertySetInfo getPropertySetInfo() {
        return this.m_prophlp.getPropertySetInfo();
    }

    public void setPropertyValue(String aPropertyName, Object aValue) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.m_prophlp.setPropertyValue(aPropertyName, aValue);
    }

    public Object getPropertyValue(String aPropertyName) throws UnknownPropertyException, WrappedTargetException {
        return this.m_prophlp.getPropertyValue(aPropertyName);
    }

    public void addPropertyChangeListener(String aPropertyName, XPropertyChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.addPropertyChangeListener(aPropertyName, xListener);
    }

    public void removePropertyChangeListener(String aPropertyName, XPropertyChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.removePropertyChangeListener(aPropertyName, xListener);
    }

    public void addVetoableChangeListener(String aPropertyName, XVetoableChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.addVetoableChangeListener(aPropertyName, xListener);
    }

    public void removeVetoableChangeListener(String aPropertyName, XVetoableChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.removeVetoableChangeListener(aPropertyName, xListener);
    }

    public XFunctionCategory getCategory() {
        return this.category;
    }

    public String getName() {
        try {
            return this.functionDescription.getDisplayName(this.defaultLocale);
        }
        catch (Exception exception) {
            return "Missing function name for " + ((Object)((Object)this)).getClass().getName();
        }
    }

    public String getDescription() {
        try {
            return this.functionDescription.getDescription(this.defaultLocale);
        }
        catch (Exception exception) {
            return "Missing function description for " + ((Object)((Object)this)).getClass().getName();
        }
    }

    public String getSignature() {
        int count = this.functionDescription.getParameterCount();
        StringBuffer signature = new StringBuffer(this.getName());
        signature.append('(');
        for (int i = 0; i < count; ++i) {
            signature.append(this.functionDescription.getParameterDisplayName(i, this.defaultLocale));
            if (i == count - 1) continue;
            signature.append(';');
        }
        signature.append(')');
        return signature.toString();
    }

    public FunctionArgument[] getArguments() {
        int count = this.functionDescription.getParameterCount();
        boolean infinite = this.functionDescription.isInfiniteParameterCount();
        if (infinite) {
            count = 30;
        }
        FunctionArgument[] args = new FunctionArgument[count];
        for (int i = 0; i < args.length; ++i) {
            int pos = infinite ? 0 : i;
            args[i] = new FunctionArgument();
            args[i].Description = this.functionDescription.getParameterDescription(pos, this.defaultLocale);
            args[i].Name = this.functionDescription.getParameterDisplayName(pos, this.defaultLocale);
            args[i].IsOptional = !this.functionDescription.isParameterMandatory(pos);
        }
        return args;
    }

    public String createFormula(String[] arguments) throws DisposedException, IllegalArgumentException, com.sun.star.uno.Exception {
        boolean infinite = this.functionDescription.isInfiniteParameterCount();
        int count = this.functionDescription.getParameterCount();
        if (!infinite && arguments.length > count) {
            throw new IllegalArgumentException();
        }
        StringBuffer formula = new StringBuffer(this.getName());
        formula.append('(');
        for (int i = 0; i < arguments.length && arguments[i].length() != 0; ++i) {
            formula.append(arguments[i]);
            if (i >= arguments.length - 1 || arguments[i + 1].length() == 0) continue;
            formula.append(';');
        }
        formula.append(')');
        return formula.toString();
    }
}

