/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.layoutprocessor.AbstractReportElementLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.FormatValueUtility;
import org.libreoffice.report.pentaho.layoutprocessor.OfficeRepeatingStructureLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.TableCellLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.VariablesCollection;
import org.libreoffice.report.pentaho.model.FormattedTextElement;
import org.libreoffice.report.pentaho.model.OfficeDocument;
import org.libreoffice.report.pentaho.model.OfficeStyle;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class FormattedTextLayoutController
extends AbstractReportElementLayoutController {
    private static final Log LOGGER = LogFactory.getLog(FormattedTextLayoutController.class);

    private VariablesCollection getVariablesCollection() {
        for (LayoutController parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof OfficeRepeatingStructureLayoutController)) continue;
            OfficeRepeatingStructureLayoutController orslc = (OfficeRepeatingStructureLayoutController)parent;
            if (orslc.isNormalFlowProcessing()) {
                return null;
            }
            return orslc.getVariablesCollection();
        }
        return null;
    }

    public boolean isValueChanged() {
        try {
            FormattedTextElement element = (FormattedTextElement)this.getNode();
            FormulaExpression formulaExpression = element.getValueExpression();
            Formula formula = formulaExpression.getCompiledFormula();
            LValue lValue = formula.getRootReference();
            return FormatValueUtility.isReferenceChanged(this, lValue);
        }
        catch (ParseException e) {
            LOGGER.debug("Parse Exception", e);
            return false;
        }
    }

    protected LayoutController delegateContentGeneration(ReportTarget target) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        FormattedTextElement element = (FormattedTextElement)this.getNode();
        DataFlags df = FormatValueUtility.computeDataFlag(element, this.getFlowController());
        if (df != null) {
            if (df.getValue() instanceof String) {
                target.processContent(df);
            } else {
                Element cell = this.getParentTableCell();
                if (cell != null && "string".equals(cell.getAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type"))) {
                    target.processContent(df);
                }
            }
        }
        return this.join(this.getFlowController());
    }

    private OfficeDocument getDocument() {
        for (LayoutController parent = this.getParent(); parent != null; parent = parent.getParent()) {
            Object node = parent.getNode();
            if (!(node instanceof OfficeDocument)) continue;
            return (OfficeDocument)node;
        }
        return null;
    }

    private Element getParentTableCell() {
        for (LayoutController parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TableCellLayoutController)) continue;
            TableCellLayoutController cellController = (TableCellLayoutController)parent;
            return cellController.getElement();
        }
        return null;
    }

    private String computeValueStyle() {
        Element tce = this.getParentTableCell();
        if (tce == null) {
            return null;
        }
        String cellStyleName = (String)tce.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        if (cellStyleName == null) {
            return null;
        }
        OfficeDocument document = this.getDocument();
        if (document == null) {
            return null;
        }
        OfficeStyle style = document.getStylesCollection().getStyle("table-cell", cellStyleName);
        return (String)style.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "data-style-name");
    }

    private String computeValueType() {
        Element tce = this.getParentTableCell();
        if (tce == null) {
            throw new IllegalStateException("A formatted text element must be a child of a Table-Cell.");
        }
        String type = (String)tce.getAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type");
        if (type == null) {
            LOGGER.error("The Table-Cell does not have a office:value attribute defined. Your content will be messed up.");
            return "string";
        }
        return type;
    }
}

