/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.ElementLayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerFactory;
import org.jfree.report.structure.Node;
import org.libreoffice.report.pentaho.layoutprocessor.OfficePageSectionLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.OfficeRepeatingStructureLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.OfficeTableTemplateLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.VariablesCollection;
import org.libreoffice.report.pentaho.model.OfficeReport;
import org.libreoffice.report.pentaho.model.VariablesDeclarationSection;

public class OfficeReportLayoutController
extends ElementLayoutController
implements OfficeRepeatingStructureLayoutController {
    private static final int STATE_NOT_STARTED = 0;
    private static final int STATE_TEMPLATES = 1;
    private static final int STATE_PAGE_HEADER_DONE = 2;
    private static final int STATE_PAGE_FOOTER_DONE = 3;
    private static final int STATE_SPREADSHEET_PAGE_HEADER_DONE = 4;
    private static final int STATE_SPREADSHEET_PAGE_FOOTER_DONE = 5;
    private static final int STATE_COLUMN_HEADER_DONE = 6;
    private static final int STATE_COLUMN_FOOTER_DONE = 7;
    private static final int STATE_INITIAL_VARIABLES_DONE = 8;
    private static final int STATE_REPORT_HEADER_DONE = 9;
    private static final int STATE_REPORT_BODY_DONE = 10;
    private static final int STATE_REPORT_FOOTER_VARIABLES = 11;
    private static final int STATE_REPORT_FOOTER_DONE = 12;
    private int state;
    private VariablesCollection variablesCollection;

    public void initialize(Object node, FlowController flowController, LayoutController parent) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        super.initialize(node, flowController, parent);
        this.variablesCollection = new VariablesCollection("auto_report_");
    }

    protected LayoutController processContent(ReportTarget target) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        OfficeReport or = (OfficeReport)this.getElement();
        switch (this.state) {
            case 0: {
                return this.delegateToTemplates(1);
            }
            case 1: {
                return this.delegateSection(or.getPageHeader(), 2);
            }
            case 2: {
                return this.delegateSpreadsheetSection(or.getPageHeader(), 4);
            }
            case 4: {
                return this.delegateSection(or.getPageFooter(), 3);
            }
            case 3: {
                return this.delegateSection(or.getColumnHeader(), 6);
            }
            case 6: {
                return this.delegateSection(or.getColumnFooter(), 7);
            }
            case 7: {
                return this.delegateSection(new VariablesDeclarationSection(), 8);
            }
            case 8: {
                return this.delegateSection(or.getReportHeader(), 9);
            }
            case 9: {
                return this.delegateSection(or.getBodySection(), 10);
            }
            case 10: {
                return this.delegateSection(new VariablesDeclarationSection(), 11);
            }
            case 11: {
                return this.delegateSection(or.getReportFooter(), 12);
            }
            case 12: {
                return this.delegateSpreadsheetSection(or.getPageFooter(), 5);
            }
            case 5: {
                OfficeReportLayoutController olc = (OfficeReportLayoutController)this.clone();
                olc.setProcessingState(3);
                return olc;
            }
        }
        throw new IllegalStateException("Invalid processing state encountered.");
    }

    private LayoutController delegateSpreadsheetSection(Node node, int nextState) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        OfficeReportLayoutController olc = (OfficeReportLayoutController)this.clone();
        olc.state = nextState;
        if (node == null) {
            return olc;
        }
        OfficePageSectionLayoutController templateLc = new OfficePageSectionLayoutController();
        templateLc.initialize(node, this.getFlowController(), olc);
        return templateLc;
    }

    private LayoutController delegateToTemplates(int nextState) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        OfficeReportLayoutController olc = (OfficeReportLayoutController)this.clone();
        olc.state = nextState;
        OfficeTableTemplateLayoutController templateLc = new OfficeTableTemplateLayoutController();
        templateLc.initialize(this.getElement(), this.getFlowController(), olc);
        return templateLc;
    }

    private LayoutController delegateSection(Node n, int nextState) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        OfficeReportLayoutController olc = (OfficeReportLayoutController)this.clone();
        olc.state = nextState;
        if (n == null) {
            return olc;
        }
        FlowController flowController = this.getFlowController();
        ReportContext reportContext = flowController.getReportContext();
        LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
        return layoutControllerFactory.create(flowController, n, olc);
    }

    public LayoutController join(FlowController flowController) {
        OfficeReportLayoutController derived = (OfficeReportLayoutController)this.clone();
        derived.setFlowController(flowController);
        return derived;
    }

    public boolean isNormalFlowProcessing() {
        return this.state != 2 && this.state != 3;
    }

    public VariablesCollection getVariablesCollection() {
        return this.variablesCollection;
    }
}

