/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.flow.layoutprocessor.SectionLayoutController;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.libreoffice.report.pentaho.layoutprocessor.FormatValueUtility;
import org.libreoffice.report.pentaho.model.FormatCondition;
import org.libreoffice.report.pentaho.model.FormattedTextElement;
import org.libreoffice.report.pentaho.model.ReportElement;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class TableCellLayoutController
extends SectionLayoutController {
    protected AttributeMap computeAttributes(FlowController fc, Element element, ReportTarget target) throws DataSourceException {
        AttributeMap attributeMap = new AttributeMap(super.computeAttributes(fc, element, target));
        String definedStyle = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", (Object)this.getDisplayStyleName((Section)element, definedStyle));
        try {
            DataFlags value = this.computeValue(attributeMap);
            String valueType = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type");
            if (value != null) {
                FormatValueUtility.applyValueForCell(value.getValue(), attributeMap, valueType);
            } else if (!"string".equals(valueType)) {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", (Object)"void");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        attributeMap.makeReadOnly();
        return attributeMap;
    }

    private DataFlags computeValue(AttributeMap attributeMap) throws DataSourceException {
        Section cell = (Section)this.getElement();
        FormattedTextElement element = this.findFormattedTextElement(cell);
        if (element == null) {
            return null;
        }
        if (!FormatValueUtility.shouldPrint(this, element)) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", (Object)"void");
            return null;
        }
        return FormatValueUtility.computeDataFlag(element, this.getFlowController());
    }

    public boolean isValueChanged() {
        try {
            Section cell = (Section)this.getElement();
            FormattedTextElement element = this.findFormattedTextElement(cell);
            if (element == null) {
                return false;
            }
            FormulaExpression formulaExpression = element.getValueExpression();
            Formula formula = formulaExpression.getCompiledFormula();
            LValue lValue = formula.getRootReference();
            return FormatValueUtility.isReferenceChanged(this, lValue);
        }
        catch (ParseException e) {
            return false;
        }
    }

    private FormattedTextElement findFormattedTextElement(Section section) {
        Node[] nodeArray = section.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            FormattedTextElement retval;
            Node node = nodeArray[i];
            if (node instanceof FormattedTextElement) {
                return (FormattedTextElement)node;
            }
            if (!(node instanceof Section) || (retval = this.findFormattedTextElement((Section)node)) == null) continue;
            return retval;
        }
        return null;
    }

    private String getDisplayStyleName(Section section, String defaultStyle) {
        if (!section.isEnabled() || section.getNodeCount() == 0) {
            return defaultStyle;
        }
        Node[] nodes = section.getNodeArray();
        for (int i = 0; i < nodes.length; ++i) {
            String childFormatCondition;
            ReportElement element;
            Node child = nodes[i];
            if (child instanceof ReportElement && child.isEnabled() && (element = (ReportElement)child).getFormatConditionCount() > 0) {
                Expression displayCond = element.getDisplayCondition();
                if (displayCond != null) {
                    try {
                        if (Boolean.FALSE.equals(LayoutControllerUtil.evaluateExpression(this.getFlowController(), element, displayCond))) {
                            continue;
                        }
                    }
                    catch (DataSourceException e) {
                        // empty catch block
                    }
                }
                FormatCondition[] conditions = element.getFormatConditions();
                for (int j = 0; j < conditions.length; ++j) {
                    FormatCondition formCond = conditions[j];
                    if (!formCond.isEnabled()) continue;
                    try {
                        Object o = LayoutControllerUtil.evaluateExpression(this.getFlowController(), element, formCond.getFormula());
                        if (!Boolean.TRUE.equals(o)) continue;
                        return formCond.getStyleName();
                    }
                    catch (DataSourceException e) {
                        // empty catch block
                    }
                }
            }
            if (!(child instanceof Section) || ObjectUtilities.equal((Object)(childFormatCondition = this.getDisplayStyleName((Section)child, defaultStyle)), (Object)defaultStyle)) continue;
            return childFormatCondition;
        }
        return defaultStyle;
    }
}

