/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import java.util.ArrayList;
import java.util.List;
import org.libreoffice.report.pentaho.model.FormattedTextElement;

public class VariablesCollection {
    private VariablesCollection parent;
    private String namePrefix;
    private List<FormattedTextElement> variables;

    public VariablesCollection(String namePrefix) {
        this(namePrefix, null);
    }

    public VariablesCollection(String namePrefix, VariablesCollection parent) {
        if (namePrefix == null) {
            throw new NullPointerException("NamePrefix cannot be null");
        }
        this.namePrefix = namePrefix;
        this.parent = parent;
        this.variables = new ArrayList<FormattedTextElement>();
    }

    public VariablesCollection getParent() {
        return this.parent;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String addVariable(FormattedTextElement element) {
        this.variables.add(element);
        int size = this.variables.size();
        return this.namePrefix + size;
    }

    public FormattedTextElement[] getVariables() {
        return this.variables.toArray(new FormattedTextElement[this.variables.size()]);
    }

    public int getVariablesCount() {
        return this.variables.size();
    }
}

