/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.model.DataStyle;
import org.libreoffice.report.pentaho.model.OfficeStyle;
import org.libreoffice.report.pentaho.model.PageLayout;

public class OfficeStyles
extends Element {
    private final Map<String, PageLayout> pageStyles;
    private final Map<String, DataStyle> dataStyles;
    private final Map<StyleKey, OfficeStyle> styles = new HashMap<StyleKey, OfficeStyle>();
    private final List<Element> otherChildren;

    public OfficeStyles() {
        this.dataStyles = new HashMap<String, DataStyle>();
        this.pageStyles = new HashMap<String, PageLayout>();
        this.otherChildren = new ArrayList<Element>();
    }

    public OfficeStyle getStyle(String family, String name) {
        return this.styles.get(new StyleKey(family, name));
    }

    public void addStyle(OfficeStyle style) {
        if (style == null) {
            throw new NullPointerException();
        }
        String styleFamily = style.getStyleFamily();
        if (styleFamily == null) {
            throw new NullPointerException();
        }
        if (style.getStyleName() == null) {
            throw new NullPointerException();
        }
        this.styles.put(new StyleKey(styleFamily, style.getStyleName()), style);
    }

    public void addPageStyle(PageLayout style) {
        this.pageStyles.put(style.getStyleName(), style);
    }

    public PageLayout getPageStyle(String name) {
        return this.pageStyles.get(name);
    }

    public void addDataStyle(DataStyle style) {
        this.dataStyles.put(style.getStyleName(), style);
    }

    public DataStyle getDataStyle(String name) {
        return this.dataStyles.get(name);
    }

    public void addOtherNode(Element node) {
        this.otherChildren.add(node);
    }

    public DataStyle[] getAllDataStyles() {
        return this.dataStyles.values().toArray(new DataStyle[this.dataStyles.size()]);
    }

    public PageLayout[] getAllPageStyles() {
        return this.pageStyles.values().toArray(new PageLayout[this.pageStyles.size()]);
    }

    public OfficeStyle[] getAllStyles() {
        return this.styles.values().toArray(new OfficeStyle[this.styles.size()]);
    }

    public Element[] getOtherStyles() {
        return this.otherChildren.toArray(new Element[this.otherChildren.size()]);
    }

    public boolean containsStyle(String family, String name) {
        return this.styles.containsKey(new StyleKey(family, name));
    }

    public boolean containsDataStyle(String styleName) {
        return this.dataStyles.containsKey(styleName);
    }

    public static class StyleKey
    implements Serializable {
        private static final long serialVersionUID = 4931878927362887477L;
        private final String family;
        private final String name;

        public StyleKey(String family, String name) {
            if (family == null) {
                throw new NullPointerException();
            }
            this.family = family;
            this.name = name;
        }

        public String getFamily() {
            return this.family;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (this != obj) {
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                StyleKey styleKey = (StyleKey)obj;
                if (!this.family.equals(styleKey.family) || (this.name != null ? !this.name.equals(styleKey.name) : styleKey.name != null)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int result = this.family.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

