/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.jfree.report.structure.StaticText;
import org.libreoffice.report.pentaho.model.DataStyle;
import org.libreoffice.report.pentaho.model.FontFaceDeclsSection;
import org.libreoffice.report.pentaho.model.FontFaceElement;
import org.libreoffice.report.pentaho.model.OfficeMasterPage;
import org.libreoffice.report.pentaho.model.OfficeMasterStyles;
import org.libreoffice.report.pentaho.model.OfficeStyle;
import org.libreoffice.report.pentaho.model.OfficeStyles;
import org.libreoffice.report.pentaho.model.OfficeStylesCollection;
import org.libreoffice.report.pentaho.model.PageLayout;
import org.libreoffice.report.pentaho.model.RawText;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class StylesWriter {
    private final XmlWriter xmlWriter;
    private final boolean writeOpeningTag;

    public StylesWriter(Writer writer) {
        DefaultTagDescription tagDescription = new DefaultTagDescription();
        tagDescription.configure(JFreeReportBoot.getInstance().getGlobalConfig(), "org.libreoffice.report.pentaho.output.");
        this.xmlWriter = new XmlWriter(writer, (TagDescription)tagDescription);
        this.xmlWriter.setAlwaysAddNamespace(true);
        this.writeOpeningTag = true;
    }

    public StylesWriter(XmlWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        this.writeOpeningTag = false;
    }

    public void writeContentStyles(OfficeStylesCollection predefined, OfficeStylesCollection globals) throws IOException, ReportProcessingException {
        this.writeFontFaces(new OfficeStylesCollection[]{globals});
        this.writeAutomaticStylesSection(new OfficeStylesCollection[]{globals});
    }

    public void writeGlobalStyles(OfficeStylesCollection predefined, OfficeStylesCollection globals) throws IOException, ReportProcessingException {
        if (this.writeOpeningTag) {
            this.performWriteRootTag();
        }
        this.writeFontFaces(new OfficeStylesCollection[]{globals});
        this.writeCommonStylesSection(new OfficeStylesCollection[]{globals});
        this.writeAutomaticStylesSection(new OfficeStylesCollection[]{globals});
        this.writeMasterStylesSection(new OfficeStylesCollection[]{globals});
        if (this.writeOpeningTag) {
            this.xmlWriter.writeCloseTag();
        }
    }

    private void writeMasterStylesSection(OfficeStylesCollection[] osc) throws IOException {
        this.xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "master-styles", false);
        for (int sci = 0; sci < osc.length; ++sci) {
            OfficeStylesCollection collection = osc[sci];
            OfficeMasterStyles officeStyles = collection.getMasterStyles();
            OfficeMasterPage[] officeMasterPages = officeStyles.getAllMasterPages();
            for (int i = 0; i < officeMasterPages.length; ++i) {
                OfficeMasterPage masterPage = officeMasterPages[i];
                this.writeSection(masterPage);
            }
            this.writeSectionChildren(officeStyles.getOtherNodes().getNodeArray());
        }
        this.xmlWriter.writeCloseTag();
    }

    private void writeCommonStylesSection(OfficeStylesCollection[] osc) throws IOException {
        this.xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "styles", false);
        for (int sci = 0; sci < osc.length; ++sci) {
            OfficeStylesCollection collection = osc[sci];
            OfficeStyles officeStyles = collection.getCommonStyles();
            this.writeStyles(officeStyles);
        }
        this.xmlWriter.writeCloseTag();
    }

    private void writeAutomaticStylesSection(OfficeStylesCollection[] osc) throws IOException {
        this.xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "automatic-styles", false);
        for (int sci = 0; sci < osc.length; ++sci) {
            OfficeStylesCollection collection = osc[sci];
            OfficeStyles officeStyles = collection.getAutomaticStyles();
            this.writeStyles(officeStyles);
        }
        this.xmlWriter.writeCloseTag();
    }

    private void writeFontFaces(OfficeStylesCollection[] osc) throws IOException {
        this.xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "font-face-decls", false);
        TreeMap<String, FontFaceElement> fontFaces = new TreeMap<String, FontFaceElement>();
        for (int sci = 0; sci < osc.length; ++sci) {
            OfficeStylesCollection collection = osc[sci];
            FontFaceDeclsSection fontFaceDecls = collection.getFontFaceDecls();
            FontFaceElement[] fontFaceElements = fontFaceDecls.getAllFontFaces();
            for (int i = 0; i < fontFaceElements.length; ++i) {
                FontFaceElement element = fontFaceElements[i];
                fontFaces.put(element.getStyleName(), element);
            }
        }
        for (FontFaceElement element : fontFaces.values()) {
            this.writeElement(element);
        }
        this.xmlWriter.writeCloseTag();
    }

    private void writeStyles(OfficeStyles styles) throws IOException {
        OfficeStyle[] allStyles = styles.getAllStyles();
        for (int i = 0; i < allStyles.length; ++i) {
            OfficeStyle style = allStyles[i];
            this.writeSection(style);
        }
        DataStyle[] allDataStyles = styles.getAllDataStyles();
        for (int i = 0; i < allDataStyles.length; ++i) {
            DataStyle style = allDataStyles[i];
            this.writeSection(style);
        }
        PageLayout[] allPageStyles = styles.getAllPageStyles();
        for (int i = 0; i < allPageStyles.length; ++i) {
            PageLayout style = allPageStyles[i];
            this.writeSection(style);
        }
        this.writeSectionChildren(styles.getOtherStyles());
    }

    private void writeElement(Element element) throws IOException {
        String type = element.getType();
        String namespace = element.getNamespace();
        AttributeList attrList = this.buildAttributeList(element.getAttributeMap());
        this.xmlWriter.writeTag(namespace, type, attrList, true);
    }

    private void writeSection(Section section) throws IOException {
        String type = section.getType();
        String namespace = section.getNamespace();
        AttributeList attrList = this.buildAttributeList(section.getAttributeMap());
        if (section.getNodeCount() == 0) {
            this.xmlWriter.writeTag(namespace, type, attrList, true);
            return;
        }
        this.xmlWriter.writeTag(namespace, type, attrList, false);
        this.writeSectionChildren(section.getNodeArray());
        this.xmlWriter.writeCloseTag();
    }

    private void writeSectionChildren(Node[] nodes) throws IOException {
        for (int i = 0; i < nodes.length; ++i) {
            StaticText text;
            Node node = nodes[i];
            if (node instanceof Section) {
                this.writeSection((Section)node);
                continue;
            }
            if (node instanceof Element) {
                this.writeElement((Element)node);
                continue;
            }
            if (node instanceof RawText) {
                text = (RawText)node;
                this.xmlWriter.writeText(text.getText());
                continue;
            }
            if (!(node instanceof StaticText)) continue;
            text = (StaticText)node;
            this.xmlWriter.writeTextNormalized(text.getText(), false);
        }
    }

    protected AttributeList buildAttributeList(AttributeMap attrs) {
        AttributeList attrList = new AttributeList();
        String[] namespaces = attrs.getNameSpaces();
        for (int i = 0; i < namespaces.length; ++i) {
            String attrNamespace = namespaces[i];
            if (this.isFilteredNamespace(attrNamespace)) continue;
            Map localAttributes = attrs.getAttributes(attrNamespace);
            for (Map.Entry entry : localAttributes.entrySet()) {
                String key = String.valueOf(entry.getKey());
                attrList.setAttribute(attrNamespace, key, String.valueOf(entry.getValue()));
            }
        }
        return attrList;
    }

    protected boolean isFilteredNamespace(String namespace) {
        if ("http://jfreereport.sourceforge.net/namespaces/layout".equals(namespace)) {
            return true;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/engine".equals(namespace)) {
            return true;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/engine/compatibility".equals(namespace)) {
            return true;
        }
        return "http://openoffice.org/2005/report".equals(namespace);
    }

    private void performWriteRootTag() throws IOException {
        AttributeList rootAttributes = new AttributeList();
        rootAttributes.addNamespaceDeclaration("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        rootAttributes.addNamespaceDeclaration("style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        rootAttributes.addNamespaceDeclaration("text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        rootAttributes.addNamespaceDeclaration("table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        rootAttributes.addNamespaceDeclaration("draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        rootAttributes.addNamespaceDeclaration("fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        rootAttributes.addNamespaceDeclaration("xlink", "http://www.w3.org/1999/xlink");
        rootAttributes.addNamespaceDeclaration("dc", "http://purl.org/dc/elements/1.1/");
        rootAttributes.addNamespaceDeclaration("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        rootAttributes.addNamespaceDeclaration("number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        rootAttributes.addNamespaceDeclaration("svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        rootAttributes.addNamespaceDeclaration("chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        rootAttributes.addNamespaceDeclaration("chartooo", "http://openoffice.org/2010/chart");
        rootAttributes.addNamespaceDeclaration("dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        rootAttributes.addNamespaceDeclaration("math", "http://www.w3.org/1998/Math/MathML");
        rootAttributes.addNamespaceDeclaration("form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        rootAttributes.addNamespaceDeclaration("script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        rootAttributes.addNamespaceDeclaration("ooo", "http://openoffice.org/2004/office");
        rootAttributes.addNamespaceDeclaration("ooow", "http://openoffice.org/2004/writer");
        rootAttributes.addNamespaceDeclaration("oooc", "http://openoffice.org/2004/calc");
        rootAttributes.addNamespaceDeclaration("dom", "http://www.w3.org/2001/xml-events");
        rootAttributes.addNamespaceDeclaration("xforms", "http://www.w3.org/2002/xforms");
        rootAttributes.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        rootAttributes.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootAttributes.addNamespaceDeclaration("grddl", "http://www.w3.org/2003/g/data-view#");
        rootAttributes.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "version", "1.2");
        this.xmlWriter.writeXmlDeclaration("UTF-8");
        this.xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "document-styles", rootAttributes, false);
    }

    public void close() throws IOException {
        this.xmlWriter.close();
    }
}

