/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.namespace.Namespaces;
import org.jfree.report.JFreeReportBoot;
import org.libreoffice.report.pentaho.parser.AttributeSpecification;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficeParserUtil {
    private static final Log LOGGER = LogFactory.getLog(OfficeParserUtil.class);
    private static OfficeParserUtil instance;
    private static final String NAMESPACES_PREFIX = "namespaces.";
    private final DefaultConfiguration props = new DefaultConfiguration();
    private final NamespaceDefinition[] namespaces;

    public static synchronized OfficeParserUtil getInstance() {
        if (instance == null) {
            instance = new OfficeParserUtil();
        }
        return instance;
    }

    private OfficeParserUtil() {
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.registerDefaults();
        try {
            Resource res = resourceManager.createDirectly((Object)"res://org/libreoffice/report/pentaho/parser/selectors.properties", Properties.class);
            Properties resProps = (Properties)res.getResource();
            this.props.putAll((Map)resProps);
        }
        catch (ResourceException e) {
            LOGGER.warn("Unable to load mapping rules. Parsing services may not be available.", e);
        }
        this.namespaces = Namespaces.createFromConfig((Configuration)JFreeReportBoot.getInstance().getGlobalConfig(), (String)"org.jfree.report.namespaces.", (ResourceManager)resourceManager);
    }

    public NamespaceDefinition getNamespaceDeclaration(String uri) {
        if (uri == null) {
            throw new NullPointerException("URI must not be null");
        }
        for (int i = 0; i < this.namespaces.length; ++i) {
            NamespaceDefinition definition = this.namespaces[i];
            if (!uri.equals(definition.getURI())) continue;
            return definition;
        }
        return null;
    }

    public String getGenericFont(String officeFont) {
        return this.props.getProperty("font-family." + officeFont.toLowerCase(), officeFont);
    }

    public String getNamespaceURI(String namespacePrefix) {
        return this.props.getProperty(NAMESPACES_PREFIX + namespacePrefix);
    }

    public String getNamespaceForStyleFamily(String styleFamily) {
        return this.props.getProperty("style-family." + styleFamily);
    }

    public Map<String, String> getNamespaces() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keys = this.props.findPropertyKeys(NAMESPACES_PREFIX);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = this.props.getConfigProperty(key);
            map.put(key.substring(NAMESPACES_PREFIX.length()), value);
        }
        return map;
    }

    public String getNamespacePrefix(String namespaceURI) {
        Iterator keys = this.props.findPropertyKeys(NAMESPACES_PREFIX);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = this.props.getConfigProperty(key);
            if (!namespaceURI.equals(value)) continue;
            return key.substring(NAMESPACES_PREFIX.length());
        }
        return null;
    }

    public AttributeSpecification parseStyleAttrDefinition(String key, String prefix, String tagname) {
        String configPrefix = "attr." + prefix + "." + tagname + ".";
        String configSuffix = key.substring(configPrefix.length());
        int dotPosition = configSuffix.indexOf(46);
        if (dotPosition == -1) {
            return null;
        }
        String namespaceUri = this.getNamespaceURI(configSuffix.substring(0, dotPosition));
        String attrName = configSuffix.substring(dotPosition + 1);
        String value = this.props.getProperty(key);
        return new AttributeSpecification(namespaceUri, attrName, value);
    }

    public Iterator findStylesForElement(String prefix, String tagname) {
        String configPrefix = "attr." + prefix + "." + tagname + ".";
        return this.props.findPropertyKeys(configPrefix);
    }

    public boolean isValidStyleElement(String uri, String tagName) {
        String prefix = this.getNamespacePrefix(uri);
        if (prefix == null) {
            return false;
        }
        Iterator stylesForElement = this.findStylesForElement(prefix, tagName);
        return stylesForElement.hasNext();
    }

    public String getSelectorPattern() {
        return this.props.getConfigProperty("style-selector.pattern");
    }

    public static void main(String[] args) {
        JFreeReportBoot.getInstance().start();
        System.out.print(OfficeParserUtil.getInstance().getNamespaces());
    }
}

