/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.office;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.model.OfficeMasterStyles;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.style.MasterPageReadHandler;
import org.libreoffice.report.pentaho.parser.style.StyleDefinitionReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MasterStylesReadHandler
extends ElementReadHandler {
    private final OfficeMasterStyles masterStyles;
    private final List<ElementReadHandler> otherHandlers;
    private final List<MasterPageReadHandler> masterPageHandlers;

    public MasterStylesReadHandler(OfficeMasterStyles masterStyles) {
        this.masterStyles = masterStyles;
        this.masterPageHandlers = new ArrayList<MasterPageReadHandler>();
        this.otherHandlers = new ArrayList<ElementReadHandler>();
    }

    public OfficeMasterStyles getMasterStyles() {
        return this.masterStyles;
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("urn:oasis:names:tc:opendocument:xmlns:style:1.0".equals(uri) && "master-page".equals(tagName)) {
            MasterPageReadHandler mrh = new MasterPageReadHandler();
            this.masterPageHandlers.add(mrh);
            return mrh;
        }
        StyleDefinitionReadHandler readHandler = new StyleDefinitionReadHandler();
        this.otherHandlers.add(readHandler);
        return readHandler;
    }

    protected void doneParsing() throws SAXException {
        ElementReadHandler handler;
        int i;
        for (i = 0; i < this.otherHandlers.size(); ++i) {
            handler = this.otherHandlers.get(i);
            this.masterStyles.getOtherNodes().addNode(handler.getElement());
        }
        for (i = 0; i < this.masterPageHandlers.size(); ++i) {
            handler = this.masterPageHandlers.get(i);
            this.masterStyles.addMasterPage(((MasterPageReadHandler)handler).getMasterPage());
        }
    }

    public Element getElement() {
        return this.masterStyles;
    }
}

