/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.form;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.document.Control;
import com.sun.star.wizards.document.DatabaseControl;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.document.Shape;
import com.sun.star.wizards.document.TimeStampControl;

public class FormControlArranger {
    public static final String LABELCONTROL = "LabelControl";
    protected DatabaseControl[] DBControlList = null;
    private XNameContainer xFormName;
    private XMultiServiceFactory xMSF;
    private Control[] LabelControlList = null;
    private XStatusIndicator xProgressBar;
    private FieldColumn[] FieldColumns;
    private int icurArrangement;
    private boolean bIsFirstRun;
    private boolean bIsVeryFirstRun;
    private boolean bControlsareCreated;
    private int cXOffset;
    private int cYOffset;
    private static final int cVertDistance = 200;
    private static final int cHoriDistance = 300;
    private static final int cLabelGap = 100;
    private static final double CMAXREDUCTION = 0.7;
    private FormHandler oFormHandler;
    private int iReduceWidth;
    private int m_currentLabelPosX;
    private int m_currentLabelPosY;
    private int m_currentControlPosX;
    private int m_currentControlPosY;
    private int m_LabelHeight;
    private int m_LabelWidth;
    private int m_dbControlHeight;
    private int m_dbControlWidth;
    private int m_MaxLabelWidth;
    private int nFormWidth;
    private int nFormHeight;
    private int m_currentMaxRowHeight;
    private int nSecMaxRowY;
    private int m_maxPostionX;
    private int a;
    private int StartA;
    private int m_controlMaxPosY = 0;
    private Short NBorderType = new Short(1);

    public FormControlArranger(FormHandler _oFormHandler, XNameContainer _xFormName, CommandMetaData oDBMetaData, XStatusIndicator _xProgressBar, Point _StartPoint, Size _FormSize) {
        this.FieldColumns = oDBMetaData.FieldColumns;
        this.xMSF = oDBMetaData.xMSF;
        this.xFormName = _xFormName;
        this.xProgressBar = _xProgressBar;
        this.LabelControlList = new Control[this.FieldColumns.length];
        this.DBControlList = new DatabaseControl[this.FieldColumns.length];
        this.oFormHandler = _oFormHandler;
        this.cXOffset = _StartPoint.X;
        this.cYOffset = _StartPoint.Y;
        this.setFormSize(_FormSize);
    }

    private int getLabelDiffHeight(int _index) {
        DatabaseControl curDBControl = this.DBControlList[_index];
        if (curDBControl != null && curDBControl.getControlType() == 2) {
            return this.getCheckBoxDiffHeight(_index);
        }
        return this.oFormHandler.getBasicLabelDiffHeight();
    }

    public void setBorderType(short _nBorderType) {
        this.NBorderType = new Short(_nBorderType);
    }

    public Control[] getLabelControlList() {
        return this.LabelControlList;
    }

    private int getCheckBoxDiffHeight(int LastIndex) {
        if (LastIndex < this.DBControlList.length && this.DBControlList[LastIndex].getControlType() == 2) {
            return (this.oFormHandler.getControlReferenceHeight() - this.DBControlList[LastIndex].getControlHeight()) / 2;
        }
        return 0;
    }

    private boolean isReducable(int _index, int i_labelWidth, int i_dbControlWidth) {
        boolean bisreducable = false;
        int ntype = this.FieldColumns[_index].getFieldType();
        switch (ntype) {
            case -7: 
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                bisreducable = false;
                break;
            }
            case 12: {
                try {
                    short nTextLen = AnyConverter.toShort((Object)this.DBControlList[_index].xPropertySet.getPropertyValue("MaxTextLen"));
                    if (nTextLen != 0 && nTextLen <= 20) break;
                    bisreducable = true;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                break;
            }
            case -5: {
                bisreducable = true;
                break;
            }
            default: {
                bisreducable = true;
            }
        }
        if (bisreducable && (double)i_labelWidth > 0.63 * (double)i_dbControlWidth) {
            bisreducable = false;
        }
        return bisreducable;
    }

    private int getControlGroupWidth() {
        if (this.m_dbControlWidth > this.m_LabelWidth) {
            return this.m_dbControlWidth;
        }
        return this.m_LabelWidth;
    }

    private void checkJustifiedPosition(int a) {
        int nBaseWidth = this.nFormWidth + this.cXOffset;
        int nLeftDist = this.m_maxPostionX - nBaseWidth;
        int nRightDist = nBaseWidth - (this.DBControlList[a].getPosition().X - 300);
        if ((double)nLeftDist < 0.5 * (double)nRightDist) {
            this.adjustLineWidth(this.StartA, a, nLeftDist, -1);
            this.m_currentLabelPosY = this.m_currentMaxRowHeight + 200;
            this.m_currentControlPosY = this.m_currentLabelPosY + this.m_LabelHeight;
            this.m_currentLabelPosX = this.cXOffset;
            this.m_currentControlPosX = this.cXOffset;
            this.bIsFirstRun = true;
            this.StartA = a + 1;
        } else {
            this.m_currentLabelPosY = this.m_currentControlPosY + this.m_dbControlHeight == this.m_currentMaxRowHeight ? this.nSecMaxRowY : this.m_currentMaxRowHeight;
            this.m_currentLabelPosY += 200;
            this.m_currentControlPosY = this.m_currentLabelPosY + this.m_LabelHeight;
            this.m_currentControlPosX = this.cXOffset;
            this.m_currentLabelPosX = this.cXOffset;
            this.LabelControlList[a].setPosition(new Point(this.cXOffset, this.m_currentLabelPosY));
            this.DBControlList[a].setPosition(new Point(this.cXOffset, this.m_currentControlPosY));
            this.bIsFirstRun = true;
            this.checkOuterPoints(this.m_currentControlPosX, this.m_dbControlWidth > this.m_LabelWidth ? this.m_dbControlWidth : this.m_LabelWidth, this.m_currentControlPosY, this.m_dbControlHeight, true);
            this.m_currentControlPosX = this.m_currentLabelPosX = this.m_maxPostionX + 300;
            this.adjustLineWidth(this.StartA, a - 1, nRightDist, 1);
            this.StartA = a;
        }
    }

    private int getCorrWidth(int StartIndex, int EndIndex, int nDist, int Widthfactor) {
        int ShapeCount = Widthfactor > 0 ? EndIndex - StartIndex + 1 : this.iReduceWidth;
        return nDist / ShapeCount;
    }

    private void adjustLineWidth(int StartIndex, int EndIndex, int nDist, int WidthFactor) {
        int CorrWidth = this.getCorrWidth(StartIndex, EndIndex, nDist, WidthFactor);
        int iLocTCPosX = this.cXOffset;
        for (int i = StartIndex; i <= EndIndex; ++i) {
            int nControlBaseWidth = 0;
            DatabaseControl dbControl = this.DBControlList[i];
            Control curLabelControl = this.LabelControlList[i];
            if (i != StartIndex) {
                curLabelControl.setPosition(new Point(iLocTCPosX, curLabelControl.getPosition().Y));
                dbControl.setPosition(new Point(iLocTCPosX, curLabelControl.getPosition().Y + this.m_LabelHeight));
            }
            Size labelSize = curLabelControl.getSize();
            Size controlSize = dbControl.getSize();
            nControlBaseWidth = labelSize.Width > controlSize.Width && WidthFactor > 0 ? labelSize.Width : controlSize.Width;
            if (this.FieldColumns[i].getFieldType() == 93) {
                TimeStampControl oDBTimeStampControl = (TimeStampControl)dbControl;
                nControlBaseWidth = oDBTimeStampControl.getSize().Width;
            }
            if (WidthFactor > 0 || this.isReducable(i, labelSize.Width, controlSize.Width)) {
                controlSize.Width = nControlBaseWidth + WidthFactor * CorrWidth;
                dbControl.setSize(controlSize);
                controlSize = dbControl.getSize();
            }
            iLocTCPosX = labelSize.Width > controlSize.Width ? (iLocTCPosX += labelSize.Width) : (iLocTCPosX += controlSize.Width);
            iLocTCPosX += 300;
        }
        this.iReduceWidth = WidthFactor > 0 ? 1 : 0;
    }

    private void checkOuterPoints(int i_nXPos, int i_nWidth, int i_nYPos, int i_nHeight, boolean i_bIsDBField) {
        if (this.icurArrangement == 4 && i_bIsDBField) {
            if (this.bIsFirstRun) {
                this.nSecMaxRowY = this.m_currentMaxRowHeight = i_nYPos + i_nHeight;
            } else {
                int nRowY = i_nYPos + i_nHeight;
                if (nRowY >= this.m_currentMaxRowHeight) {
                    this.nSecMaxRowY = this.m_currentMaxRowHeight;
                    this.m_currentMaxRowHeight = nRowY;
                }
            }
        }
        if (this.bIsFirstRun) {
            this.m_maxPostionX = i_nXPos + i_nWidth;
            this.bIsFirstRun = false;
        } else {
            int nColRightX = i_nXPos + i_nWidth;
            if (nColRightX > this.m_maxPostionX) {
                this.m_maxPostionX = nColRightX;
            }
        }
    }

    public void positionControls(int _icurArrangement, Point _aStartPoint, Size _aFormSize, short _iAlign, Short _NBorderType) {
        try {
            this.NBorderType = _NBorderType;
            this.setStartPoint(_aStartPoint);
            this.icurArrangement = _icurArrangement;
            this.initializePosSizes();
            this.initializeControlColumn(-1);
            this.bIsVeryFirstRun = true;
            this.m_currentMaxRowHeight = 0;
            this.nSecMaxRowY = 0;
            this.m_maxPostionX = 0;
            this.xProgressBar.start(PropertyNames.EMPTY_STRING, this.FieldColumns.length);
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                try {
                    this.insertLabel(i, _iAlign);
                    this.insertDBControl(i);
                    this.bIsVeryFirstRun = false;
                    this.DBControlList[i].setPropertyValue(LABELCONTROL, this.LabelControlList[i].xPropertySet);
                    this.resetPosSizes(i);
                    this.xProgressBar.setValue(i + 1);
                    continue;
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            this.xProgressBar.end();
            this.bControlsareCreated = true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public boolean areControlsexisting() {
        if (this.DBControlList != null && this.DBControlList.length > 0) {
            return this.DBControlList[0] != null;
        }
        return false;
    }

    private void initializeControlColumn(int LastIndex) {
        this.bIsFirstRun = true;
        this.StartA = LastIndex + 1;
        this.a = 0;
    }

    private void resetPosSizes(int LastIndex) {
        int nYRefPos = this.m_currentControlPosY;
        switch (this.icurArrangement) {
            case 1: {
                nYRefPos = this.m_currentControlPosY = this.m_currentControlPosY + this.m_dbControlHeight + 200 + this.getCheckBoxDiffHeight(LastIndex);
                if (this.m_currentControlPosY > this.cYOffset + this.nFormHeight || LastIndex == this.FieldColumns.length - 1) {
                    this.repositionColumnarLeftControls(LastIndex);
                    this.m_currentLabelPosX = this.m_maxPostionX + 600;
                    this.m_currentControlPosX = this.m_currentLabelPosX + 100 + this.m_MaxLabelWidth;
                    nYRefPos = this.m_currentControlPosY = this.cYOffset;
                    this.initializeControlColumn(LastIndex);
                } else {
                    ++this.a;
                }
                this.m_currentLabelPosY = this.m_currentControlPosY + this.getLabelDiffHeight(LastIndex);
                if (nYRefPos + this.m_dbControlHeight <= this.m_controlMaxPosY) break;
                this.m_controlMaxPosY = nYRefPos + this.m_dbControlHeight;
                break;
            }
            case 2: {
                this.m_currentLabelPosY = this.m_currentControlPosY + this.m_dbControlHeight + 200 + this.getCheckBoxDiffHeight(LastIndex);
                if (this.m_currentLabelPosY > this.cYOffset + this.nFormHeight || LastIndex == this.FieldColumns.length - 1) {
                    this.m_currentLabelPosX = this.m_currentControlPosX = this.m_maxPostionX + 300;
                    nYRefPos = this.m_currentControlPosY;
                    this.m_currentControlPosY = this.cYOffset + this.m_LabelHeight + 200;
                    this.m_currentLabelPosY = this.cYOffset;
                    this.initializeControlColumn(LastIndex);
                } else {
                    ++this.a;
                }
                if (nYRefPos + this.m_dbControlHeight + 200 <= this.m_controlMaxPosY) break;
                this.m_controlMaxPosY = nYRefPos + this.m_dbControlHeight + 200;
                break;
            }
            case 4: {
                if (this.isReducable(this.a, this.m_LabelWidth, this.m_dbControlWidth)) {
                    ++this.iReduceWidth;
                }
                if (this.m_maxPostionX > this.cXOffset + this.nFormWidth) {
                    this.checkJustifiedPosition(this.a);
                    nYRefPos = this.m_currentControlPosY;
                } else {
                    this.m_currentLabelPosX = this.m_maxPostionX + 300;
                }
                if (this.a == this.FieldColumns.length - 1) {
                    this.checkJustifiedPosition(this.a);
                    nYRefPos = this.m_currentControlPosY;
                }
                this.m_currentControlPosX = this.m_currentLabelPosX;
                ++this.a;
                if (nYRefPos + this.m_dbControlHeight <= this.m_controlMaxPosY) break;
                this.m_controlMaxPosY = nYRefPos + this.m_dbControlHeight;
            }
        }
    }

    private void repositionColumnarLeftControls(int LastIndex) {
        this.bIsFirstRun = true;
        for (int i = this.StartA; i <= LastIndex; ++i) {
            if (i == this.StartA) {
                this.m_currentLabelPosX = this.LabelControlList[i].getPosition().X;
                this.m_currentControlPosX = this.m_currentLabelPosX + this.m_MaxLabelWidth + 300;
            }
            this.LabelControlList[i].setSize(new Size(this.m_MaxLabelWidth, this.m_LabelHeight));
            this.resetDBShape(this.DBControlList[i], this.m_currentControlPosX);
            this.checkOuterPoints(this.m_currentControlPosX, this.m_dbControlWidth, this.m_currentControlPosY, this.m_dbControlHeight, true);
        }
    }

    private void resetDBShape(Shape _curDBControl, int iXPos) {
        this.m_dbControlWidth = _curDBControl.getSize().Width;
        this.m_dbControlHeight = _curDBControl.getSize().Height;
        _curDBControl.setPosition(new Point(iXPos, _curDBControl.getPosition().Y));
    }

    private void initializePosSizes() {
        this.m_controlMaxPosY = 0;
        this.m_currentLabelPosX = this.cXOffset;
        this.m_LabelWidth = 2000;
        this.m_dbControlWidth = 2000;
        this.m_dbControlHeight = this.oFormHandler.getControlReferenceHeight();
        this.m_LabelHeight = this.oFormHandler.getLabelHeight();
        this.iReduceWidth = 0;
        if (this.icurArrangement == 1) {
            this.m_currentLabelPosY = this.cYOffset + this.getLabelDiffHeight(0);
            this.m_currentControlPosX = this.cXOffset + 3050;
            this.m_currentControlPosY = this.cYOffset;
        } else {
            this.m_currentControlPosX = this.cXOffset;
            this.m_currentLabelPosY = this.cYOffset;
        }
    }

    private void insertLabel(int i, int _iAlign) {
        try {
            Point aPoint = new Point(this.m_currentLabelPosX, this.m_currentLabelPosY);
            Size aSize = new Size(this.m_LabelWidth, this.m_LabelHeight);
            if (this.bControlsareCreated) {
                this.LabelControlList[i].setPosition(aPoint);
                if (this.icurArrangement != 1) {
                    aSize.Width = this.m_LabelWidth = this.LabelControlList[i].getPreferredWidth(this.FieldColumns[i].getFieldTitle());
                    this.LabelControlList[i].setSize(aSize);
                } else {
                    this.m_LabelWidth = this.LabelControlList[i].getSize().Width;
                }
            } else {
                String sFieldName = this.FieldColumns[i].getFieldName();
                this.LabelControlList[i] = new Control(this.oFormHandler, this.xFormName, 0, sFieldName, aPoint, aSize);
                if (this.bIsVeryFirstRun && this.icurArrangement == 2) {
                    this.m_currentControlPosY = this.m_currentLabelPosY + this.m_LabelHeight;
                }
                String sTitle = this.FieldColumns[i].getFieldTitle();
                aSize.Width = this.m_LabelWidth = this.LabelControlList[i].getPreferredWidth(sTitle);
                this.LabelControlList[i].setSize(aSize);
            }
            Control curLabelControl = this.LabelControlList[i];
            if (this.icurArrangement == 1) {
                if (this.bIsFirstRun) {
                    this.m_MaxLabelWidth = this.m_LabelWidth;
                    this.bIsFirstRun = false;
                } else if (this.m_LabelWidth > this.m_MaxLabelWidth) {
                    this.m_MaxLabelWidth = this.m_LabelWidth;
                }
            }
            this.checkOuterPoints(this.m_currentLabelPosX, this.m_LabelWidth, this.m_currentLabelPosY, this.m_LabelHeight, false);
            if (this.icurArrangement == 2 || this.icurArrangement == 4) {
                this.m_currentControlPosX = this.m_currentLabelPosX;
                this.m_currentControlPosY = this.m_currentLabelPosY + this.m_LabelHeight;
                curLabelControl.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_ALIGN, (Object)new Short(0));
            } else {
                curLabelControl.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_ALIGN, (Object)new Short((short)_iAlign));
            }
            if (!this.bControlsareCreated) {
                curLabelControl.setSize(new Size(this.m_LabelWidth, this.m_LabelHeight));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void insertDBControl(int i) {
        try {
            String sFieldName = this.FieldColumns[i].getFieldName();
            int nFieldType = this.FieldColumns[i].getFieldType();
            Point aPoint = new Point(this.m_currentControlPosX, this.m_currentControlPosY);
            if (this.bControlsareCreated) {
                this.DBControlList[i].setPosition(aPoint);
            } else if (nFieldType == 93) {
                this.DBControlList[i] = new TimeStampControl(new Resource(this.xMSF, "FormWizard", "dbw"), this.oFormHandler, this.xFormName, sFieldName, aPoint);
            } else {
                this.DBControlList[i] = new DatabaseControl(this.oFormHandler, this.xFormName, sFieldName, nFieldType, aPoint);
                if (this.DBControlList[i].getControlType() == 2) {
                    this.DBControlList[i].setPropertyValue(PropertyNames.PROPERTY_LABEL, PropertyNames.EMPTY_STRING);
                }
            }
            DatabaseControl aDBControl = this.DBControlList[i];
            this.m_dbControlHeight = aDBControl.getControlHeight();
            this.m_dbControlWidth = aDBControl.getControlWidth();
            if (nFieldType != 93) {
                aDBControl.setSize(new Size(this.m_dbControlWidth, this.m_dbControlHeight));
            }
            if (aDBControl.getControlType() == 2) {
                this.m_currentControlPosY += (this.oFormHandler.getControlReferenceHeight() - this.m_dbControlHeight) / 2;
                aPoint = new Point(this.m_currentControlPosX, this.m_currentControlPosY);
                aDBControl.setPosition(aPoint);
            }
            if (nFieldType == -1) {
                Helper.setUnoPropertyValue(this.LabelControlList[i], PropertyNames.PROPERTY_MULTILINE, Boolean.TRUE);
            }
            this.checkOuterPoints(this.m_currentControlPosX, this.m_dbControlWidth, this.m_currentControlPosY, this.m_dbControlHeight, true);
            aDBControl.setPropertyValue(PropertyNames.PROPERTY_BORDER, this.NBorderType);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private int assignFieldLength(int _fieldlength) {
        if (_fieldlength >= 65535) {
            return -1;
        }
        return _fieldlength;
    }

    public int getFormHeight() {
        return this.m_controlMaxPosY - this.cYOffset;
    }

    public int getEntryPointY() {
        if (this.icurArrangement == 2) {
            Control curLabelControl2 = this.LabelControlList[0];
            return curLabelControl2.getPosition().Y;
        }
        DatabaseControl curDBControl2 = this.DBControlList[0];
        return curDBControl2.getPosition().Y;
    }

    public void setStartPoint(Point _aPoint) {
        this.cXOffset = _aPoint.X;
        this.cYOffset = _aPoint.Y;
    }

    public void adjustYPositions(int _diffY) {
        for (int i = 0; i < this.DBControlList.length; ++i) {
            Point aPoint = this.DBControlList[i].getPosition();
            this.DBControlList[i].setPosition(new Point(aPoint.X, aPoint.Y - _diffY));
            aPoint = this.LabelControlList[i].getPosition();
            this.LabelControlList[i].setPosition(new Point(aPoint.X, aPoint.Y - _diffY));
        }
        this.m_controlMaxPosY = -_diffY;
        this.cYOffset = -_diffY;
    }

    public void setFormSize(Size _FormSize) {
        this.nFormHeight = _FormSize.Height;
        this.nFormWidth = _FormSize.Width;
    }
}

