/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.beanshell;

import com.sun.star.script.framework.provider.beanshell.PlainSourceView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextArea;

class GlyphGutter
extends JComponent {
    private PlainSourceView view;
    private final String DUMMY_STRING = "99";

    GlyphGutter(PlainSourceView view) {
        this.view = view;
        this.update();
    }

    public void update() {
        JTextArea textArea = this.view.getTextArea();
        Font font = textArea.getFont();
        this.setFont(font);
        FontMetrics metrics = this.getFontMetrics(font);
        int h = metrics.getHeight();
        int lineCount = textArea.getLineCount() + 1;
        String dummy = Integer.toString(lineCount);
        if (dummy.length() < 2) {
            dummy = "99";
        }
        Dimension d = new Dimension();
        d.width = metrics.stringWidth(dummy) + 16;
        d.height = lineCount * h + 100;
        this.setPreferredSize(d);
        this.setSize(d);
    }

    public void paintComponent(Graphics g) {
        JTextArea textArea = this.view.getTextArea();
        Font font = textArea.getFont();
        g.setFont(font);
        FontMetrics metrics = this.getFontMetrics(font);
        Rectangle clip = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        int ascent = metrics.getMaxAscent();
        int h = metrics.getHeight();
        int lineCount = textArea.getLineCount() + 1;
        int startLine = clip.y / h;
        int endLine = (clip.y + clip.height) / h + 1;
        int width = this.getWidth();
        if (endLine > lineCount) {
            endLine = lineCount;
        }
        for (int i = startLine; i < endLine; ++i) {
            String text = Integer.toString(i + 1) + " ";
            int w = metrics.stringWidth(text);
            int y = i * h;
            g.setColor(Color.blue);
            g.drawString(text, 0, y + ascent);
            int x = width - ascent;
            if (i != this.view.getCurrentPosition()) continue;
            this.drawArrow(g, ascent, x, y);
        }
    }

    private void drawArrow(Graphics g, int ascent, int x, int y) {
        Polygon arrow = new Polygon();
        int dx = x;
        int dy = y += ascent - 10;
        arrow.addPoint(dx, dy + 3);
        arrow.addPoint(dx + 5, dy + 3);
        x = dx + 5;
        while (x <= dx + 10) {
            arrow.addPoint(x, y);
            ++x;
            ++y;
        }
        x = dx + 9;
        while (x >= dx + 5) {
            arrow.addPoint(x, y);
            --x;
            ++y;
        }
        arrow.addPoint(dx + 5, dy + 7);
        arrow.addPoint(dx, dy + 7);
        g.setColor(Color.red);
        g.fillPolygon(arrow);
        g.setColor(Color.black);
        g.drawPolygon(arrow);
    }
}

