/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import com.sun.star.document.XScriptInvocationContext;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ClassLoaderFactory;
import com.sun.star.script.framework.provider.NoSuitableClassLoaderException;
import com.sun.star.script.framework.provider.ScriptContext;
import com.sun.star.script.framework.provider.beanshell.ScriptEditorForBeanShell;
import com.sun.star.script.provider.ScriptErrorRaisedException;
import com.sun.star.script.provider.ScriptExceptionRaisedException;
import com.sun.star.script.provider.ScriptFrameworkErrorException;
import com.sun.star.script.provider.XScript;
import com.sun.star.uno.Any;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.XComponentContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

class ScriptImpl
implements XScript {
    private ScriptMetaData metaData;
    private XComponentContext m_xContext;
    private XMultiComponentFactory m_xMultiComponentFactory;
    private XModel m_xModel;
    private XScriptInvocationContext m_xInvocContext;

    ScriptImpl(XComponentContext ctx, ScriptMetaData metaData, XModel xModel, XScriptInvocationContext xContext) throws RuntimeException {
        this.metaData = metaData;
        this.m_xContext = ctx;
        this.m_xModel = xModel;
        this.m_xInvocContext = xContext;
        try {
            this.m_xMultiComponentFactory = this.m_xContext.getServiceManager();
        }
        catch (Exception e) {
            LogUtils.DEBUG(LogUtils.getTrace(e));
            throw new RuntimeException("Error constructing  ScriptImpl [beanshell]: " + e.getMessage());
        }
        LogUtils.DEBUG("ScriptImpl [beanshell] script data = " + metaData);
    }

    public Object invoke(Object[] aParams, short[][] aOutParamIndex, Object[][] aOutParam) throws ScriptFrameworkErrorException, InvocationTargetException {
        aOutParamIndex[0] = new short[0];
        aOutParam[0] = new Object[0];
        ClassLoader cl = null;
        URL sourceUrl = null;
        try {
            cl = ClassLoaderFactory.getURLClassLoader(this.metaData);
            sourceUrl = this.metaData.getSourceURL();
        }
        catch (MalformedURLException mfu) {
            throw new ScriptFrameworkErrorException(mfu.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 3);
        }
        catch (NoSuitableClassLoaderException nsc) {
            throw new ScriptFrameworkErrorException(nsc.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        Thread.currentThread().setContextClassLoader(cl);
        Interpreter interpreter = new Interpreter();
        interpreter.getNameSpace().clear();
        interpreter.setClassLoader(cl);
        try {
            interpreter.set("XSCRIPTCONTEXT", ScriptContext.createContext(this.m_xModel, this.m_xInvocContext, this.m_xContext, this.m_xMultiComponentFactory));
            interpreter.set("ARGUMENTS", aParams);
        }
        catch (EvalError e) {
            throw new ScriptFrameworkErrorException(e.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        try {
            String source = null;
            Object result = null;
            ScriptEditorForBeanShell editor = ScriptEditorForBeanShell.getEditor(sourceUrl);
            if (editor != null) {
                result = editor.execute();
                if (result == null) {
                    return new Any(new Type(), null);
                }
                return result;
            }
            this.metaData.loadSource();
            source = this.metaData.getSource();
            if (source == null || source.length() == 0) {
                throw new ScriptFrameworkErrorException("Failed to read script", null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 2);
            }
            result = interpreter.eval(source);
            if (result == null) {
                return new Any(new Type(), null);
            }
            return result;
        }
        catch (ParseException pe) {
            throw new InvocationTargetException("Beanshell failed to parse " + this.metaData.getLanguageName(), null, (Object)this.processBshException(pe, this.metaData.getLanguageName()));
        }
        catch (TargetError te) {
            throw new InvocationTargetException("Beanshell uncaught exception for " + this.metaData.getLanguageName(), null, (Object)this.processBshException(te, this.metaData.getLanguageName()));
        }
        catch (EvalError ex) {
            throw new InvocationTargetException("Beanshell error for " + this.metaData.getLanguageName(), null, (Object)this.processBshException(ex, this.metaData.getLanguageName()));
        }
        catch (Exception e) {
            throw new ScriptFrameworkErrorException("Failed to read script", null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
    }

    private void raiseEditor(int lineNum) {
        ScriptEditorForBeanShell editor = null;
        try {
            URL sourceUrl = this.metaData.getSourceURL();
            editor = ScriptEditorForBeanShell.getEditor(sourceUrl);
            if (editor == null) {
                editor = ScriptEditorForBeanShell.getEditor();
                editor.edit(ScriptContext.createContext(this.m_xModel, this.m_xInvocContext, this.m_xContext, this.m_xMultiComponentFactory), this.metaData);
                editor = ScriptEditorForBeanShell.getEditor(sourceUrl);
            }
            if (editor != null) {
                editor.indicateErrorLine(lineNum);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ScriptErrorRaisedException processBshException(EvalError e, String script) {
        LogUtils.DEBUG("Beanshell error RAW message " + e.getMessage());
        String message = e.getMessage();
        int usefulInfoIndex = message.lastIndexOf("' :");
        int lineNum = e.getErrorLineNumber();
        this.raiseEditor(lineNum);
        if (usefulInfoIndex > -1) {
            message = message.substring(usefulInfoIndex + 2);
        }
        if (e instanceof TargetError) {
            LogUtils.DEBUG("got instance of  TargetError");
            if (usefulInfoIndex == -1) {
                message = ((TargetError)e).getTarget().getMessage();
            }
            String wrappedException = "";
            String full = e.toString();
            int index = full.indexOf("Target exception:");
            if (index > -1) {
                String toParse = full.substring(index);
                LogUtils.DEBUG("About to parse " + toParse);
                StringTokenizer tokenizer = new StringTokenizer(full.substring(index), ":");
                if (tokenizer.countTokens() > 2) {
                    LogUtils.DEBUG("First token = " + (String)tokenizer.nextElement());
                    wrappedException = (String)tokenizer.nextElement();
                    LogUtils.DEBUG("wrapped exception = = " + wrappedException);
                }
            }
            ScriptExceptionRaisedException se = new ScriptExceptionRaisedException(message);
            se.lineNum = lineNum;
            se.scriptName = script;
            se.exceptionType = wrappedException;
            se.language = "BeanShell";
            LogUtils.DEBUG("UnCaught Exception error: ");
            LogUtils.DEBUG("\tscript: " + script);
            LogUtils.DEBUG("\tline: " + lineNum);
            LogUtils.DEBUG("\twrapped exception: " + wrappedException);
            LogUtils.DEBUG("\tmessage: " + message);
            return se;
        }
        LogUtils.DEBUG("Error or ParseError Exception error: ");
        LogUtils.DEBUG("\tscript: " + script);
        LogUtils.DEBUG("\tline: " + lineNum);
        LogUtils.DEBUG("\tmessage: " + message);
        return new ScriptErrorRaisedException(message, null, script, "BeanShell", lineNum);
    }
}

