/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.beanshell;

import bsh.Interpreter;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceView;
import com.sun.star.script.provider.XScriptContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ScriptSourceModel {
    private int currentPosition = -1;
    private URL file = null;
    private ScriptSourceView view = null;

    public ScriptSourceModel(URL file) {
        this.file = file;
    }

    private String load() throws IOException {
        StringBuffer buf = new StringBuffer();
        InputStream in = this.file.openStream();
        byte[] contents = new byte[1024];
        int len = 0;
        while ((len = in.read(contents, 0, 1024)) != -1) {
            buf.append(new String(contents, 0, len));
        }
        try {
            in.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return buf.toString();
    }

    public String getText() {
        String result = "";
        try {
            result = this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public void setView(ScriptSourceView view) {
        this.view = view;
    }

    public Object execute(XScriptContext context, ClassLoader cl) throws Exception {
        Object result = null;
        if (cl != null) {
            Thread.currentThread().setContextClassLoader(cl);
        }
        Interpreter interpreter = new Interpreter();
        if (cl != null) {
            interpreter.getNameSpace().clear();
        }
        this.currentPosition = -1;
        this.view.update();
        interpreter.set("XSCRIPTCONTEXT", context);
        interpreter.set("ARGUMENTS", new Object[0]);
        result = this.view.isModified() ? interpreter.eval(this.view.getText()) : interpreter.eval(this.getText());
        return result;
    }

    public void indicateErrorLine(int lineNum) {
        System.out.println("Beanshell indicateErrorLine " + lineNum);
        this.currentPosition = lineNum - 1;
        this.view.update();
    }
}

