/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.sdbcx.comp.hsqldb;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

final class NativeLibraries {
    public static void load() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            NativeLibraries.loadLibrary("msvcr71");
            NativeLibraries.loadLibrary("uwinapi");
            NativeLibraries.loadLibrary("sal3");
            NativeLibraries.loadLibrary("dbtoolsmi");
        }
        NativeLibraries.loadLibrary("hsqldb");
    }

    private static void loadLibrary(String libname) {
        block4: {
            try {
                System.loadLibrary(libname);
            }
            catch (UnsatisfiedLinkError e) {
                URL url;
                ClassLoader cl = NativeLibraries.class.getClassLoader();
                if (!(cl instanceof URLClassLoader) || (url = ((URLClassLoader)cl).findResource(System.mapLibraryName(libname))) == null) break block4;
                try {
                    System.load(((File)File.class.getConstructor(ClassLoader.getSystemClassLoader().loadClass("java.net.URI")).newInstance(URL.class.getMethod("toURI", new Class[0]).invoke((Object)url, (Object[])null))).getAbsolutePath());
                }
                catch (Throwable t) {
                    throw new UnsatisfiedLinkError(e.toString() + " - " + t.toString());
                }
            }
        }
    }

    private NativeLibraries() {
    }
}

