/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.sdbcx.comp.hsqldb;

import com.sun.star.sdbcx.comp.hsqldb.NativeStorageAccess;
import java.io.IOException;
import org.hsqldb.lib.Storage;

public class StorageAccess
implements Storage {
    String key;
    String name;
    boolean readonly;
    NativeStorageAccess access;

    public StorageAccess(String name, Boolean readonly, Object key) throws IOException {
        this.key = (String)key;
        this.name = name;
        this.readonly = readonly;
        try {
            this.access = new NativeStorageAccess(name, this.readonly ? "r" : "rw", key);
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    public void close() throws IOException {
        this.access.close(this.name, this.key);
    }

    public long getFilePointer() throws IOException {
        return this.access.getFilePointer(this.name, this.key);
    }

    public long length() throws IOException {
        return this.access.length(this.name, this.key);
    }

    public int read() throws IOException {
        return this.access.read(this.name, this.key);
    }

    public void read(byte[] b, int off, int len) throws IOException {
        this.access.read(this.name, this.key, b, off, len);
    }

    public int readInt() throws IOException {
        byte[] tmp = new byte[4];
        int count = this.access.read(this.name, this.key, tmp, 0, 4);
        if (count != 4) {
            throw new IOException();
        }
        count = 0;
        int ch0 = tmp[count++] & 0xFF;
        int ch1 = tmp[count++] & 0xFF;
        int ch2 = tmp[count++] & 0xFF;
        int ch3 = tmp[count] & 0xFF;
        return (ch0 << 24) + (ch1 << 16) + (ch2 << 8) + ch3;
    }

    public void seek(long position) throws IOException {
        this.access.seek(this.name, this.key, position);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        this.access.write(this.name, this.key, b, offset, length);
    }

    public void writeInt(int v) throws IOException {
        byte[] oneByte = new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        this.write(oneByte, 0, 4);
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public boolean wasNio() {
        return false;
    }

    public void writeLong(long v) throws IOException {
        byte[] oneByte = new byte[]{(byte)(v >>> 56 & 0xFFL), (byte)(v >>> 48 & 0xFFL), (byte)(v >>> 40 & 0xFFL), (byte)(v >>> 32 & 0xFFL), (byte)(v >>> 24 & 0xFFL), (byte)(v >>> 16 & 0xFFL), (byte)(v >>> 8 & 0xFFL), (byte)(v >>> 0 & 0xFFL)};
        this.write(oneByte, 0, 8);
    }
}

