/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XKeyHandler;
import com.sun.star.awt.XTopWindowListener;
import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.openoffice.accessibility.KeyHandler;
import org.openoffice.accessibility.WindowsAccessBridgeAdapter;
import org.openoffice.java.accessibility.AccessibleObjectFactory;

public class AccessBridge {
    protected static HashMap<String, Window> topWindowMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Window getTopWindowImpl(XAccessible xAccessible) {
        HashMap<String, Window> hashMap = topWindowMap;
        synchronized (hashMap) {
            String oid = UnoRuntime.generateOid((Object)xAccessible);
            Window w = topWindowMap.get(oid);
            if (w == null && (w = AccessibleObjectFactory.getTopWindow(xAccessible)) != null) {
                topWindowMap.put(oid, w);
            }
            return w;
        }
    }

    protected static Window getTopWindow(XAccessible xAccessible) {
        XAccessibleContext xAccessibleContext;
        if (xAccessible != null && (xAccessibleContext = xAccessible.getAccessibleContext()) != null) {
            switch (xAccessibleContext.getAccessibleRole()) {
                case 43: 
                case 49: {
                    return AccessBridge.getTopWindow(xAccessibleContext.getAccessibleParent());
                }
                case 1: 
                case 12: 
                case 21: 
                case 67: {
                    return AccessBridge.getTopWindowImpl(xAccessible);
                }
            }
        }
        return null;
    }

    protected static Window removeTopWindow(XAccessible xAccessible) {
        XAccessibleContext xAccessibleContext;
        if (xAccessible != null && (xAccessibleContext = xAccessible.getAccessibleContext()) != null) {
            switch (xAccessibleContext.getAccessibleRole()) {
                case 43: 
                case 49: {
                    return AccessBridge.removeTopWindow(xAccessibleContext.getAccessibleParent());
                }
                case 12: 
                case 21: 
                case 67: {
                    return topWindowMap.remove(UnoRuntime.generateOid((Object)xAccessible));
                }
            }
        }
        return null;
    }

    public static XSingleServiceFactory __getServiceFactory(String implName, XMultiServiceFactory multiFactory, XRegistryKey regKey) {
        XSingleServiceFactory xSingleServiceFactory = null;
        if (implName.equals(AccessBridge.class.getName())) {
            Toolkit.getDefaultToolkit();
            xSingleServiceFactory = FactoryHelper.getServiceFactory(_AccessBridge.class, (String)"com.sun.star.accessibility.AccessBridge", (XMultiServiceFactory)multiFactory, (XRegistryKey)regKey);
        }
        return xSingleServiceFactory;
    }

    public static class _AccessBridge
    implements XTopWindowListener,
    XInitialization,
    XComponent {
        static final String _serviceName = "com.sun.star.accessibility.AccessBridge";
        XComponentContext xComponentContext;

        public _AccessBridge(XComponentContext xComponentContext) {
            this.xComponentContext = xComponentContext;
        }

        public void initialize(Object[] arguments) {
            try {
                XExtendedToolkit unoToolkit = (XExtendedToolkit)AnyConverter.toObject((Type)new Type(XExtendedToolkit.class), (Object)arguments[0]);
                if (unoToolkit != null) {
                    unoToolkit.addTopWindowListener((XTopWindowListener)this);
                    String os = System.getProperty("os.name");
                    if (os.startsWith("Windows")) {
                        WindowsAccessBridgeAdapter.attach(this.xComponentContext);
                    } else {
                        unoToolkit.addKeyHandler((XKeyHandler)new KeyHandler());
                    }
                } else {
                    System.err.println("argument 0 is not of type XExtendedToolkit.");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void windowOpened(EventObject event) {
            XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)event.Source);
            Window w = AccessBridge.getTopWindow(xAccessible);
        }

        public void windowActivated(EventObject event) {
        }

        public void windowDeactivated(EventObject event) {
        }

        public void windowMinimized(EventObject event) {
        }

        public void windowNormalized(EventObject event) {
        }

        public void windowClosing(EventObject event) {
        }

        public void windowClosed(EventObject event) {
            XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)event.Source);
            Window w = AccessBridge.removeTopWindow(xAccessible);
            if (w != null) {
                w.dispose();
            }
        }

        public void disposing(EventObject event) {
        }

        public void addEventListener(XEventListener listener) {
        }

        public void removeEventListener(XEventListener listener) {
        }

        public void dispose() {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                    }
                });
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

