/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility;

import com.sun.star.accessibility.XAccessible;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import org.openoffice.java.accessibility.AccessibleObjectFactory;

public class PopupWindow
extends Window {
    AccessibleContext accessibleContext = null;
    ContainerProxy layeredPane = new ContainerProxy(AccessibleRole.LAYERED_PANE);
    ContainerProxy rootPane = new ContainerProxy(AccessibleRole.ROOT_PANE);
    ContainerProxy popupLayer = new ContainerProxy(AccessibleRole.PANEL);
    boolean opened = false;
    boolean visible = false;

    public PopupWindow(Window owner) {
        super(owner);
        super.add(this.rootPane);
        this.rootPane.add(this.layeredPane);
        AccessibleContext ac = this.rootPane.getAccessibleContext();
        if (ac != null) {
            ac.setAccessibleParent(this);
        }
    }

    static PopupWindow create(XAccessible xAccessible) {
        Window parent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (parent != null) {
            PopupWindow w = new PopupWindow(parent);
            w.setVisible(true);
            AccessibleObjectFactory.invokeAndWait();
            AccessibleObjectFactory.addChild((Container)w, xAccessible);
            return w;
        }
        return null;
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            Container parent = this.getParent();
            return parent == null || parent.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        if (this.visible != b) {
            this.visible = b;
            if (b && !this.opened) {
                AccessibleObjectFactory.postWindowOpened(this);
                this.opened = true;
            }
        }
    }

    public Component add(Component c) {
        AccessibleContext ac;
        this.popupLayer.add(c);
        this.layeredPane.add(this.popupLayer);
        if (c instanceof Accessible && (ac = this.layeredPane.getAccessibleContext()) != null) {
            ac.firePropertyChange("AccessibleChild", null, this.popupLayer.getAccessibleContext());
        }
        return c;
    }

    public void remove(Component c) {
        AccessibleContext ac;
        this.layeredPane.remove(this.popupLayer);
        if (c instanceof Accessible && (ac = this.layeredPane.getAccessibleContext()) != null) {
            ac.firePropertyChange("AccessibleChild", this.popupLayer.getAccessibleContext(), null);
        }
        this.popupLayer.remove(c);
    }

    public void dispose() {
        this.setVisible(false);
        AccessibleObjectFactory.postWindowClosed(this);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePopupWindow();
        }
        return this.accessibleContext;
    }

    protected class ContainerProxy
    extends Container
    implements Accessible {
        AccessibleContext accessibleContext = null;
        AccessibleRole role;

        protected ContainerProxy(AccessibleRole role) {
            this.role = role;
        }

        public Component add(Component c) {
            Accessible a;
            AccessibleContext ac;
            if (c instanceof Accessible && (ac = (a = (Accessible)((Object)c)).getAccessibleContext()) != null) {
                ac.setAccessibleParent(this);
            }
            return super.add(c);
        }

        public void remove(Component c) {
            Accessible a;
            AccessibleContext ac;
            if (c instanceof Accessible && (ac = (a = (Accessible)((Object)c)).getAccessibleContext()) != null) {
                ac.setAccessibleParent(null);
            }
            super.remove(c);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleContainerProxy();
            }
            return this.accessibleContext;
        }

        private class AccessibleContainerProxy
        extends Container.AccessibleAWTContainer {
            AccessibleContainerProxy() {
                super(ContainerProxy.this);
            }

            public AccessibleRole getAccessibleRole() {
                return ContainerProxy.this.role;
            }
        }
    }

    protected class AccessiblePopupWindow
    extends Window.AccessibleAWTWindow {
        AccessiblePopupWindow() {
            super(PopupWindow.this);
        }
    }
}

