/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.java.XJavaVM;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import org.openoffice.accessibility.AccessBridge;
import org.openoffice.accessibility.PopupWindow;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;

public class WindowsAccessBridgeAdapter {
    private static Method registerVirtualFrame;
    private static Method revokeVirtualFrame;
    private static HashMap<Integer, Accessible> frameMap;

    protected static native byte[] getProcessID();

    protected static native boolean createMapping(long var0);

    protected static void attach(XComponentContext xComponentContext) {
        try {
            Class<?> bridge = Class.forName("com.sun.java.accessibility.AccessBridge");
            Class[] parameterTypes = new Class[]{Accessible.class, Integer.class};
            if (bridge != null) {
                XJavaVM xJavaVM;
                registerVirtualFrame = bridge.getMethod("registerVirtualFrame", parameterTypes);
                revokeVirtualFrame = bridge.getMethod("revokeVirtualFrame", parameterTypes);
                System.loadLibrary("java_uno_accessbridge");
                Object any = xComponentContext.getValueByName("/singletons/com.sun.star.java.theJavaVirtualMachine");
                if (AnyConverter.isObject((Object)any) && (xJavaVM = (XJavaVM)UnoRuntime.queryInterface(XJavaVM.class, (Object)AnyConverter.toObject((Type)new Type(XJavaVM.class), (Object)any))) != null && AnyConverter.isLong((Object)(any = xJavaVM.getJavaVM(WindowsAccessBridgeAdapter.getProcessID())))) {
                    WindowsAccessBridgeAdapter.createMapping(AnyConverter.toLong((Object)any));
                    frameMap = new HashMap();
                }
            }
        }
        catch (NoSuchMethodException e) {
            System.err.println("ERROR: incompatible AccessBridge found: " + e.getMessage());
            throw new RuntimeException("incompatible AccessBridge class: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("ERROR: no access to AccessBridge: " + e.getMessage());
            throw new RuntimeException("Security exception caught: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ClassNotFound exception caught: " + e.getMessage());
        }
        catch (java.lang.IllegalArgumentException e) {
            System.err.println("IllegalArgumentException caught: " + e.getMessage());
            throw new RuntimeException("IllegalArgumentException caught: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.err.println("UNO IllegalArgumentException caught: " + e.getMessage());
            throw new RuntimeException("UNO IllegalArgumentException caught: " + e.getMessage());
        }
    }

    protected static boolean isAttached() {
        return frameMap != null;
    }

    protected static Accessible getAccessibleWrapper(XAccessible xAccessible) {
        Accessible a;
        block9: {
            a = null;
            try {
                XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
                if (xAccessibleContext == null) break block9;
                switch (xAccessibleContext.getAccessibleRole()) {
                    case 32: {
                        a = (Accessible)((Object)AccessibleObjectFactory.getAccessibleComponent(xAccessible));
                        if (a != null) {
                            a = new ListProxy(a.getAccessibleContext());
                        }
                        break;
                    }
                    case 34: {
                        AccessibleContext ac;
                        Accessible tmp = (Accessible)((Object)AccessibleObjectFactory.getAccessibleComponent(xAccessible));
                        if (tmp != null && (ac = tmp.getAccessibleContext()) != null) {
                            a = new PopupMenuProxy(ac);
                        }
                        break;
                    }
                    case 64: {
                        a = PopupWindow.create(xAccessible);
                        break;
                    }
                    default: {
                        a = AccessBridge.getTopWindow(xAccessible);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return a;
    }

    public static void registerTopWindow(int handle, XAccessible xAccessible) {
        Integer hwnd = new Integer(handle);
        if (!frameMap.containsKey(hwnd)) {
            System.err.println("Native frame " + hwnd + " of role " + AccessibleRoleAdapter.getAccessibleRole(xAccessible) + " has been opened");
            Accessible a = WindowsAccessBridgeAdapter.getAccessibleWrapper(xAccessible);
            if (a != null) {
                Object[] args = new Object[]{a, hwnd};
                frameMap.put(hwnd, a);
                System.err.println("registering native frame " + hwnd);
                try {
                    registerVirtualFrame.invoke(null, args);
                }
                catch (IllegalAccessException e) {
                    System.err.println("IllegalAccessException caught: " + e.getMessage());
                }
                catch (java.lang.IllegalArgumentException e) {
                    System.err.println("IllegalArgumentException caught: " + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    System.err.println("InvokationTargetException caught: " + e.getMessage());
                }
            }
        }
    }

    public static void revokeTopWindow(int handle, XAccessible xAccessible) {
        Integer hwnd = new Integer(handle);
        Accessible a = frameMap.remove(hwnd);
        if (a != null) {
            Object[] args = new Object[]{a, hwnd};
            System.err.println("revoking native frame " + hwnd);
            try {
                revokeVirtualFrame.invoke(null, args);
            }
            catch (IllegalAccessException e) {
                System.err.println("IllegalAccessException caught: " + e.getMessage());
            }
            catch (java.lang.IllegalArgumentException e) {
                System.err.println("IllegalArgumentException caught: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                System.err.println("InvokationTargetException caught: " + e.getMessage());
            }
        }
        if (a instanceof PopupWindow) {
            PopupWindow toolTipWindow = (PopupWindow)a;
            toolTipWindow.removeAll();
            toolTipWindow.dispose();
        }
    }

    protected static class ListProxy
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent {
        AccessibleContext list;
        AccessibleComponent listComponent;

        ListProxy(AccessibleContext ac) {
            this.list = ac;
            this.listComponent = this.list.getAccessibleComponent();
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this.list.getAccessibleSelection();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return this.list.getAccessibleStateSet();
        }

        public Locale getLocale() {
            return this.list.getLocale();
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return this.list.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int i) {
            return this.list.getAccessibleChild(i);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public void addFocusListener(FocusListener fl) {
            this.listComponent.addFocusListener(fl);
        }

        public void removeFocusListener(FocusListener fl) {
            this.listComponent.removeFocusListener(fl);
        }

        public Color getBackground() {
            return this.listComponent.getBackground();
        }

        public void setBackground(Color c) {
        }

        public Color getForeground() {
            return this.listComponent.getForeground();
        }

        public void setForeground(Color c) {
            this.listComponent.setForeground(c);
        }

        public Cursor getCursor() {
            return this.listComponent.getCursor();
        }

        public void setCursor(Cursor cursor) {
            this.listComponent.setCursor(cursor);
        }

        public Font getFont() {
            return this.listComponent.getFont();
        }

        public void setFont(Font f) {
            this.listComponent.setFont(f);
        }

        public FontMetrics getFontMetrics(Font f) {
            return this.listComponent.getFontMetrics(f);
        }

        public boolean isEnabled() {
            return this.listComponent.isEnabled();
        }

        public void setEnabled(boolean b) {
            this.listComponent.setEnabled(b);
        }

        public boolean isVisible() {
            return this.listComponent.isVisible();
        }

        public void setVisible(boolean b) {
            this.listComponent.setVisible(b);
        }

        public boolean isShowing() {
            return this.listComponent.isShowing();
        }

        public boolean contains(Point p) {
            return this.listComponent.contains(p);
        }

        public Point getLocationOnScreen() {
            return this.listComponent.getLocationOnScreen();
        }

        public Point getLocation() {
            return this.getLocationOnScreen();
        }

        public void setLocation(Point p) {
        }

        public Rectangle getBounds() {
            Point p = this.getLocationOnScreen();
            Dimension d = this.getSize();
            return new Rectangle(p.x, p.y, d.width, d.height);
        }

        public void setBounds(Rectangle r) {
        }

        public Dimension getSize() {
            return this.listComponent.getSize();
        }

        public void setSize(Dimension d) {
        }

        public Accessible getAccessibleAt(Point p) {
            return this.listComponent.getAccessibleAt(p);
        }

        public boolean isFocusTraversable() {
            return this.listComponent.isFocusTraversable();
        }

        public void requestFocus() {
            this.listComponent.requestFocus();
        }
    }

    protected static class PopupMenuProxy
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent {
        AccessibleContext menu;
        AccessibleComponent menuComponent;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;

        PopupMenuProxy(AccessibleContext ac) {
            this.menu = ac;
            this.menuComponent = this.menu.getAccessibleComponent();
            int x2 = 0;
            int y2 = 0;
            int count = ac.getAccessibleChildrenCount();
            for (int i = 0; i < count; ++i) {
                AccessibleComponent comp;
                AccessibleContext childAC;
                Accessible a = this.menu.getAccessibleChild(i);
                if (a == null || (childAC = a.getAccessibleContext()) == null || (comp = ac.getAccessibleComponent()) == null) continue;
                Point p = comp.getLocationOnScreen();
                Dimension d = comp.getSize();
                if (p == null || d == null) continue;
                if (p.x < this.x) {
                    this.x = p.x;
                }
                if (p.y < this.y) {
                    this.y = p.y;
                }
                if (p.x + d.width > x2) {
                    x2 = p.x + d.width;
                }
                if (p.y + d.height <= y2) continue;
                y2 = p.y + d.height;
            }
            this.width = x2 - this.x;
            this.height = y2 - this.y;
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public AccessibleText getAccessibleText() {
            return this.menu.getAccessibleText();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return this.menu.getAccessibleStateSet();
        }

        public Locale getLocale() {
            return this.menu.getLocale();
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return this.menu.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int i) {
            return this.menu.getAccessibleChild(i);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }

        public void addFocusListener(FocusListener fl) {
            this.menuComponent.addFocusListener(fl);
        }

        public void removeFocusListener(FocusListener fl) {
            this.menuComponent.removeFocusListener(fl);
        }

        public Color getBackground() {
            return this.menuComponent.getBackground();
        }

        public void setBackground(Color c) {
        }

        public Color getForeground() {
            return this.menuComponent.getForeground();
        }

        public void setForeground(Color c) {
            this.menuComponent.setForeground(c);
        }

        public Cursor getCursor() {
            return this.menuComponent.getCursor();
        }

        public void setCursor(Cursor cursor) {
            this.menuComponent.setCursor(cursor);
        }

        public Font getFont() {
            return this.menuComponent.getFont();
        }

        public void setFont(Font f) {
            this.menuComponent.setFont(f);
        }

        public FontMetrics getFontMetrics(Font f) {
            return this.menuComponent.getFontMetrics(f);
        }

        public boolean isEnabled() {
            return this.menuComponent.isEnabled();
        }

        public void setEnabled(boolean b) {
            this.menuComponent.setEnabled(b);
        }

        public boolean isVisible() {
            return this.menuComponent.isVisible();
        }

        public void setVisible(boolean b) {
            this.menuComponent.setVisible(b);
        }

        public boolean isShowing() {
            return this.menuComponent.isShowing();
        }

        public boolean contains(Point p) {
            Dimension d = this.getSize();
            System.err.println("PopupMenuProxy.containsPoint(" + p.x + "," + p.y + ") returns " + (d.width >= 0 && p.x < d.width && d.height >= 0 && p.y < d.height ? "true" : "false"));
            return d.width >= 0 && p.x < d.width && d.height >= 0 && p.y < d.height;
        }

        public Point getLocationOnScreen() {
            return new Point(this.x, this.y);
        }

        public Point getLocation() {
            return this.getLocationOnScreen();
        }

        public void setLocation(Point p) {
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }

        public void setBounds(Rectangle r) {
        }

        public Dimension getSize() {
            return new Dimension(this.width, this.height);
        }

        public void setSize(Dimension d) {
        }

        public Accessible getAccessibleAt(Point p) {
            Point p2 = this.menuComponent.getLocationOnScreen();
            return this.menuComponent.getAccessibleAt(new Point(p.x + this.x - p2.x, p.y + this.y - p2.y));
        }

        public boolean isFocusTraversable() {
            return this.menuComponent.isFocusTraversable();
        }

        public void requestFocus() {
            this.menuComponent.requestFocus();
        }
    }
}

