/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleRelation;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleRelationSet;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.awt.EventQueue;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleText;
import javax.swing.UIManager;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.Component;

public abstract class AbstractButton
extends Component {
    protected AbstractButton(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected abstract class AccessibleAbstractButton
    extends Component.AccessibleUNOComponent
    implements AccessibleAction {
        protected AccessibleAbstractButton() {
            super(AbstractButton.this);
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleText getAccessibleText() {
            if (AbstractButton.this.disposed) {
                return null;
            }
            try {
                XAccessibleText unoAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)AbstractButton.this.unoAccessibleComponent);
                if (unoAccessibleText != null) {
                    return new AccessibleTextImpl(unoAccessibleText);
                }
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            try {
                XAccessibleRelationSet unoAccessibleRelationSet = AbstractButton.this.unoAccessibleContext.getAccessibleRelationSet();
                if (unoAccessibleRelationSet == null) {
                    return null;
                }
                AccessibleRelationSet relationSet = new AccessibleRelationSet();
                int count = unoAccessibleRelationSet.getRelationCount();
                block7: for (int i = 0; i < count; ++i) {
                    AccessibleRelation unoAccessibleRelation = unoAccessibleRelationSet.getRelation(i);
                    switch (unoAccessibleRelation.RelationType) {
                        case 7: {
                            relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.MEMBER_OF, AbstractButton.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block7;
                        }
                        case 6: {
                            relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.LABELED_BY, AbstractButton.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block7;
                        }
                    }
                }
                return relationSet;
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public boolean doAccessibleAction(int param) {
            if (param == 0) {
                if (EventQueue.isDispatchThread()) {
                    Thread t = new Thread(){

                        public void run() {
                            AccessibleAbstractButton.this.doAccessibleAction(0);
                        }
                    };
                    t.start();
                    return true;
                }
                try {
                    XAccessibleAction xAccessibleAction;
                    XAccessibleContext xAccessibleContext = AbstractButton.this.unoAccessibleContext;
                    if (xAccessibleContext != null && (xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)xAccessibleContext)) != null) {
                        return xAccessibleAction.doAccessibleAction(0);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return false;
        }

        public String getAccessibleActionDescription(int param) {
            return UIManager.getString("AbstractButton.clickText");
        }

        public int getAccessibleActionCount() {
            return 1;
        }
    }
}

