/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.FontSlant;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.style.ParagraphAdjust;
import com.sun.star.style.TabAlign;
import com.sun.star.style.TabStop;
import com.sun.star.uno.RuntimeException;
import java.util.ArrayList;
import javax.accessibility.AccessibleEditableText;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import org.openoffice.java.accessibility.AccessibleTextImpl;

public class AccessibleEditableTextImpl
extends AccessibleTextImpl
implements AccessibleEditableText {
    static final double toPointFactor = 0.028985507246376812;

    public AccessibleEditableTextImpl(XAccessibleEditableText xAccessibleEditableText) {
        super((XAccessibleText)xAccessibleEditableText);
    }

    public void cut(int startIndex, int endIndex) {
        try {
            ((XAccessibleEditableText)this.unoObject).cutText(startIndex, endIndex);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void delete(int startIndex, int endIndex) {
        try {
            ((XAccessibleEditableText)this.unoObject).deleteText(startIndex, endIndex);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public String getTextRange(int startIndex, int endIndex) {
        try {
            return this.unoObject.getTextRange(startIndex, endIndex);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public void insertTextAtIndex(int index, String s) {
        try {
            ((XAccessibleEditableText)this.unoObject).insertText(s, index);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void paste(int startIndex) {
        try {
            ((XAccessibleEditableText)this.unoObject).pasteText(startIndex);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void replaceText(int startIndex, int endIndex, String s) {
        try {
            ((XAccessibleEditableText)this.unoObject).replaceText(startIndex, endIndex, s);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    public void selectText(int startIndex, int endIndex) {
        try {
            this.unoObject.setSelection(startIndex, endIndex);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void setAttributes(int startIndex, int endIndex, AttributeSet as) {
        PropertyValue propertyValue;
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        Object attribute = as.getAttribute(StyleConstants.Alignment);
        if (null != attribute) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaAdjust";
            switch (StyleConstants.getAlignment(as)) {
                case 2: {
                    propertyValue.Value = ParagraphAdjust.RIGHT;
                    break;
                }
                case 1: {
                    propertyValue.Value = ParagraphAdjust.CENTER;
                    break;
                }
                case 3: {
                    propertyValue.Value = ParagraphAdjust.BLOCK;
                    break;
                }
                default: {
                    propertyValue.Value = ParagraphAdjust.LEFT;
                }
            }
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.Background))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharBackColor";
            propertyValue.Value = new Integer(StyleConstants.getBackground(as).getRGB());
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.Bold))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharWeight";
            propertyValue.Value = StyleConstants.isBold(as) ? new Float(150.0f) : new Float(100.0f);
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.FirstLineIndent))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaFirstLineIndent";
            propertyValue.Value = new Double((double)StyleConstants.getFirstLineIndent(as) / 0.028985507246376812);
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.FontFamily))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharFontName";
            propertyValue.Value = new String(StyleConstants.getFontFamily(as));
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.FontSize))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharHeight";
            propertyValue.Value = new Integer(StyleConstants.getFontSize(as));
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.Foreground))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharColor";
            propertyValue.Value = new Integer(StyleConstants.getForeground(as).getRGB());
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.Italic))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharPosture";
            propertyValue.Value = StyleConstants.isItalic(as) ? FontSlant.ITALIC : FontSlant.DONTKNOW;
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.LeftIndent))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaFirstLeftMargin";
            propertyValue.Value = new Integer(new Double((double)StyleConstants.getLeftIndent(as) / 0.028985507246376812).intValue());
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.RightIndent))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaFirstRightMargin";
            propertyValue.Value = new Integer(new Double((double)StyleConstants.getRightIndent(as) / 0.028985507246376812).intValue());
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.LineSpacing))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaLineSpacing";
            propertyValue.Value = new Integer(new Double((double)StyleConstants.getLineSpacing(as) / 0.028985507246376812).intValue());
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.SpaceAbove))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaTopMargin";
            propertyValue.Value = new Integer(new Double((double)StyleConstants.getSpaceAbove(as) / 0.028985507246376812).intValue());
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.SpaceBelow))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaBottomMargin";
            propertyValue.Value = new Integer(new Double((double)StyleConstants.getSpaceBelow(as) / 0.028985507246376812).intValue());
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.StrikeThrough))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharPosture";
            propertyValue.Value = StyleConstants.isStrikeThrough(as) ? new Short(1) : new Short(0);
            propertyValues.add(propertyValue);
        }
        if (null == (attribute = as.getAttribute(StyleConstants.Superscript))) {
            attribute = as.getAttribute(StyleConstants.Subscript);
        }
        if (null != attribute) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharEscapement";
            propertyValue.Value = StyleConstants.isSuperscript(as) ? new Short("1") : (StyleConstants.isSubscript(as) ? new Short("-1") : new Short("0"));
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.TabSet))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ParaTabStops";
            TabSet tabSet = StyleConstants.getTabSet(as);
            ArrayList<TabStop> tabStops = new ArrayList<TabStop>(tabSet.getTabCount());
            int max = tabSet.getTabCount();
            for (int i = 0; i < max; ++i) {
                javax.swing.text.TabStop tab = tabSet.getTab(i);
                TabStop unoTab = new TabStop();
                unoTab.Position = new Double((double)tab.getPosition() / 0.028985507246376812).intValue();
                switch (tab.getAlignment()) {
                    case 2: {
                        unoTab.Alignment = TabAlign.CENTER;
                        break;
                    }
                    case 1: {
                        unoTab.Alignment = TabAlign.RIGHT;
                        break;
                    }
                    case 4: {
                        unoTab.Alignment = TabAlign.DECIMAL;
                        break;
                    }
                    default: {
                        unoTab.Alignment = TabAlign.LEFT;
                    }
                }
                tabStops.add(unoTab);
            }
            propertyValue.Value = tabStops.toArray();
            propertyValues.add(propertyValue);
        }
        if (null != (attribute = as.getAttribute(StyleConstants.Underline))) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "CharUnderline";
            propertyValue.Value = StyleConstants.isUnderline(as) ? new Short(1) : new Short(0);
            propertyValues.add(propertyValue);
        }
        try {
            ((XAccessibleEditableText)this.unoObject).setAttributes(startIndex, endIndex, (PropertyValue[])propertyValues.toArray());
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    public void setTextContents(String s) {
        try {
            ((XAccessibleEditableText)this.unoObject).setText(s);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

