/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.accessibility.AccessibleRole;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.Alert;
import org.openoffice.java.accessibility.Application;
import org.openoffice.java.accessibility.Button;
import org.openoffice.java.accessibility.CheckBox;
import org.openoffice.java.accessibility.ComboBox;
import org.openoffice.java.accessibility.Container;
import org.openoffice.java.accessibility.Dialog;
import org.openoffice.java.accessibility.FocusTraversalPolicy;
import org.openoffice.java.accessibility.Frame;
import org.openoffice.java.accessibility.Icon;
import org.openoffice.java.accessibility.Label;
import org.openoffice.java.accessibility.List;
import org.openoffice.java.accessibility.Menu;
import org.openoffice.java.accessibility.MenuContainer;
import org.openoffice.java.accessibility.MenuItem;
import org.openoffice.java.accessibility.NativeFrame;
import org.openoffice.java.accessibility.Paragraph;
import org.openoffice.java.accessibility.RadioButton;
import org.openoffice.java.accessibility.ScrollBar;
import org.openoffice.java.accessibility.Separator;
import org.openoffice.java.accessibility.Table;
import org.openoffice.java.accessibility.TextComponent;
import org.openoffice.java.accessibility.ToggleButton;
import org.openoffice.java.accessibility.ToolTip;
import org.openoffice.java.accessibility.Tree;
import org.openoffice.java.accessibility.Window;
import org.openoffice.java.accessibility.logging.XAccessibleEventLog;

public class AccessibleObjectFactory {
    public static final Type XAccessibleType = new Type(XAccessible.class);
    private static HashMap<String, WeakReference<Component>> objectList = new HashMap();
    private static java.awt.FocusTraversalPolicy focusTraversalPolicy = new FocusTraversalPolicy();
    private static EventQueue theEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();

    public static EventQueue getEventQueue() {
        return theEventQueue;
    }

    public static void postFocusGained(Component c) {
        AccessibleObjectFactory.getEventQueue().postEvent(new FocusEvent(c, 1004));
    }

    public static void postWindowGainedFocus(java.awt.Window w) {
        AccessibleObjectFactory.postWindowEvent(w, 207);
    }

    public static void postWindowLostFocus(java.awt.Window w) {
        AccessibleObjectFactory.postWindowEvent(w, 208);
    }

    public static void postWindowActivated(java.awt.Window w) {
        AccessibleObjectFactory.postWindowEvent(w, 205);
    }

    public static void postWindowDeactivated(java.awt.Window w) {
        AccessibleObjectFactory.postWindowEvent(w, 206);
    }

    public static void postWindowOpened(java.awt.Window w) {
        AccessibleObjectFactory.postWindowEvent(w, 200);
    }

    public static void postWindowClosed(java.awt.Window w) {
        AccessibleObjectFactory.postWindowEvent(w, 202);
    }

    public static void invokeAndWait() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (InvocationTargetException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void postWindowEvent(java.awt.Window w, int i) {
        theEventQueue.postEvent(new WindowEvent(w, i));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component getAccessibleComponent(XAccessible xAccessible) {
        Component c = null;
        if (xAccessible != null) {
            String oid = UnoRuntime.generateOid((Object)xAccessible);
            HashMap<String, WeakReference<Component>> hashMap = objectList;
            synchronized (hashMap) {
                WeakReference<Component> r = objectList.get(oid);
                if (r != null) {
                    c = (Component)r.get();
                }
            }
        }
        return c;
    }

    public static void addChild(java.awt.Container parent, Object any) {
        try {
            AccessibleObjectFactory.addChild(parent, (XAccessible)AnyConverter.toObject((Type)XAccessibleType, (Object)any));
        }
        catch (IllegalArgumentException e) {
            System.err.println(((Object)((Object)e)).getClass().getName() + " caught: " + e.getMessage());
        }
    }

    public static void addChild(java.awt.Container parent, XAccessible child) {
        try {
            XAccessibleStateSet stateSet;
            XAccessibleContext childAC;
            if (child != null && (childAC = child.getAccessibleContext()) != null && (stateSet = childAC.getAccessibleStateSet()) != null) {
                Component c = AccessibleObjectFactory.getAccessibleComponent(child);
                if (c != null) {
                    if (parent.equals(c.getParent())) {
                        return;
                    }
                    c.setEnabled(stateSet.contains((short)7));
                    c.setVisible(stateSet.contains((short)30));
                } else {
                    c = AccessibleObjectFactory.createAccessibleComponentImpl(child, childAC, stateSet);
                }
                if (c != null) {
                    if (c instanceof java.awt.Container) {
                        AccessibleObjectFactory.populateContainer((java.awt.Container)c, childAC);
                    }
                    parent.add(c);
                    if (stateSet.contains((short)11)) {
                        AccessibleObjectFactory.postFocusGained(c);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            System.err.println(((Object)((Object)e)).getClass().getName() + " caught: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected static void removeChild(java.awt.Container parent, Object any) {
        try {
            XAccessible xAccessible = (XAccessible)AnyConverter.toObject((Type)XAccessibleType, (Object)any);
            Component c = AccessibleObjectFactory.getAccessibleComponent(xAccessible);
            if (c != null) {
                parent.remove(c);
                if (c instanceof java.awt.Container) {
                    AccessibleObjectFactory.clearContainer((java.awt.Container)c);
                }
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(((Object)((Object)e)).getClass().getName() + " caught: " + e.getMessage());
        }
    }

    protected static void clearContainer(java.awt.Container parent) {
        int count = parent.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = parent.getComponent(i);
            if (!(c instanceof java.awt.Container)) continue;
            AccessibleObjectFactory.clearContainer((java.awt.Container)c);
        }
        parent.removeAll();
    }

    protected static void populateContainer(java.awt.Container parent, XAccessibleContext parentAC) {
        if (parentAC != null) {
            try {
                int childCount = parentAC.getAccessibleChildCount();
                for (int i = 0; i < childCount; ++i) {
                    AccessibleObjectFactory.addChild(parent, parentAC.getAccessibleChild(i));
                }
            }
            catch (Exception e) {
                System.err.println(e.getClass().getName() + " caught: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected static void populateContainer(java.awt.Container parent, XAccessibleContext parentAC, java.awt.Window frame) {
        if (parentAC != null) {
            try {
                int childCount = parentAC.getAccessibleChildCount();
                for (int i = 0; i < childCount; ++i) {
                    XAccessible child = parentAC.getAccessibleChild(i);
                    if (child != null) {
                        XAccessibleContext childAC = child.getAccessibleContext();
                        Component c = AccessibleObjectFactory.createAccessibleComponent(child, childAC, frame);
                        if (c == null) continue;
                        if (c instanceof java.awt.Container) {
                            AccessibleObjectFactory.populateContainer((java.awt.Container)c, childAC, frame);
                        }
                        parent.add(c);
                        continue;
                    }
                    System.err.println("ignoring not accessible child " + i);
                }
            }
            catch (Exception e) {
                System.err.println(e.getClass().getName() + " caught: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected static Component createAccessibleComponent(XAccessible xAccessible) {
        try {
            XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
            if (xAccessibleContext != null) {
                return AccessibleObjectFactory.createAccessibleComponentImpl(xAccessible, xAccessibleContext, xAccessibleContext.getAccessibleStateSet());
            }
        }
        catch (RuntimeException e) {
            System.err.println(((Object)((Object)e)).getClass().getName() + " caught: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    protected static Component createAccessibleComponent(XAccessible xAccessible, XAccessibleContext xAccessibleContext, java.awt.Window frame) {
        if (xAccessibleContext != null) {
            try {
                XAccessibleStateSet xAccessibleStateSet = xAccessibleContext.getAccessibleStateSet();
                Component c = AccessibleObjectFactory.createAccessibleComponentImpl(xAccessible, xAccessibleContext, xAccessibleStateSet);
                if (c != null) {
                    if (xAccessibleStateSet.contains((short)11) && frame instanceof NativeFrame) {
                        ((NativeFrame)((Object)frame)).setInitialComponent(c);
                    }
                    return c;
                }
            }
            catch (RuntimeException e) {
                System.err.println(((Object)((Object)e)).getClass().getName() + " caught: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Component createAccessibleComponentImpl(XAccessible xAccessible, XAccessibleContext xAccessibleContext, XAccessibleStateSet xAccessibleStateSet) {
        Component c = null;
        short role = xAccessibleContext.getAccessibleRole();
        switch (role) {
            case 3: {
                c = new Container(AccessibleRole.CANVAS, xAccessible, xAccessibleContext);
                break;
            }
            case 4: {
                c = new CheckBox(xAccessible, xAccessibleContext);
                break;
            }
            case 7: {
                c = new ComboBox(xAccessible, xAccessibleContext);
                break;
            }
            case 13: {
                c = new Container(AccessibleRole.CANVAS, xAccessible, xAccessibleContext);
                break;
            }
            case 14: {
                c = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 15: {
                c = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 17: {
                c = new Container(AccessibleRole.FILLER, xAccessible, xAccessibleContext);
                break;
            }
            case 20: {
                c = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 19: {
                c = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 23: {
                c = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 25: {
                c = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 28: {
                c = new Icon(xAccessible, xAccessibleContext);
                break;
            }
            case 30: {
                c = new Label(xAccessible, xAccessibleContext);
                break;
            }
            case 31: {
                c = new Container(AccessibleRole.LAYERED_PANE, xAccessible, xAccessibleContext);
                break;
            }
            case 32: {
                if (xAccessibleStateSet.contains((short)15)) {
                    c = new List(xAccessible, xAccessibleContext);
                    break;
                }
                c = new Container(AccessibleRole.LIST, xAccessible, xAccessibleContext);
                break;
            }
            case 34: {
                c = new Menu(xAccessible, xAccessibleContext);
                break;
            }
            case 35: {
                c = new MenuContainer(AccessibleRole.MENU_BAR, xAccessible, xAccessibleContext);
                break;
            }
            case 36: {
                c = new MenuItem(xAccessible, xAccessibleContext);
                break;
            }
            case 43: {
                c = new MenuContainer(AccessibleRole.POPUP_MENU, xAccessible, xAccessibleContext);
                break;
            }
            case 37: {
                c = new Container(AccessibleRole.OPTION_PANE, xAccessible, xAccessibleContext);
                break;
            }
            case 38: {
                c = new Container(AccessibleRole.PAGE_TAB, xAccessible, xAccessibleContext);
                break;
            }
            case 39: {
                c = new Container(AccessibleRole.PAGE_TAB_LIST, xAccessible, xAccessibleContext);
                break;
            }
            case 26: 
            case 41: {
                c = new Paragraph(xAccessible, xAccessibleContext);
                break;
            }
            case 40: {
                c = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 44: {
                c = new Button(xAccessible, xAccessibleContext);
                break;
            }
            case 46: {
                c = new RadioButton(xAccessible, xAccessibleContext);
                break;
            }
            case 49: {
                c = new Container(AccessibleRole.ROOT_PANE, xAccessible, xAccessibleContext);
                break;
            }
            case 50: {
                c = new ScrollBar(xAccessible, xAccessibleContext);
                break;
            }
            case 51: {
                c = new Container(AccessibleRole.SCROLL_PANE, xAccessible, xAccessibleContext);
                break;
            }
            case 53: {
                c = new Separator(xAccessible, xAccessibleContext);
                break;
            }
            case 52: {
                c = new Container(AccessibleRole.CANVAS, xAccessible, xAccessibleContext);
                break;
            }
            case 56: {
                c = new Container(AccessibleRole.SPLIT_PANE, xAccessible, xAccessibleContext);
                break;
            }
            case 57: {
                c = new Container(AccessibleRole.STATUS_BAR, xAccessible, xAccessibleContext);
                break;
            }
            case 2: 
            case 58: {
                if (xAccessibleStateSet.contains((short)15)) {
                    c = new Table(xAccessible, xAccessibleContext, xAccessibleStateSet.contains((short)18));
                    break;
                }
                c = new Container(AccessibleRole.TABLE, xAccessible, xAccessibleContext);
                break;
            }
            case 59: {
                if (xAccessibleContext.getAccessibleChildCount() > 0) {
                    c = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                    break;
                }
                c = new Label(xAccessible, xAccessibleContext);
                break;
            }
            case 60: {
                c = new TextComponent(xAccessible, xAccessibleContext);
                break;
            }
            case 61: {
                c = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 62: {
                c = new ToggleButton(xAccessible, xAccessibleContext);
                break;
            }
            case 63: {
                c = new Container(AccessibleRole.TOOL_BAR, xAccessible, xAccessibleContext);
                break;
            }
            case 64: {
                c = new ToolTip(xAccessible, xAccessibleContext);
                break;
            }
            case 65: {
                c = new Tree(xAccessible, xAccessibleContext);
                break;
            }
            case 66: {
                c = new Container(AccessibleRole.VIEWPORT, xAccessible, xAccessibleContext);
                break;
            }
            default: {
                System.err.println("Unmapped accessible object " + role);
                System.err.println("usually mapped to " + AccessibleRoleAdapter.getAccessibleRole(role));
                c = new Container(AccessibleRoleAdapter.getAccessibleRole(role), xAccessible, xAccessibleContext);
            }
        }
        if (c != null) {
            HashMap<String, WeakReference<Component>> hashMap = objectList;
            synchronized (hashMap) {
                objectList.put(c.toString(), new WeakReference<Component>(c));
            }
            AccessibleStateAdapter.setComponentState(c, xAccessibleStateSet);
            String property = System.getProperty("AccessBridgeLogging");
            if (property != null && property.indexOf("event") != -1) {
                XAccessibleEventLog.addEventListener(xAccessibleContext, c);
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void disposing(Component c) {
        if (c != null) {
            HashMap<String, WeakReference<Component>> hashMap = objectList;
            synchronized (hashMap) {
                objectList.remove(c.toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static java.awt.Window getTopWindow(XAccessible xAccessible) {
        java.awt.Window w;
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        if (xAccessibleContext == null) {
            return null;
        }
        short role = xAccessibleContext.getAccessibleRole();
        XAccessibleStateSet xAccessibleStateSet = xAccessibleContext.getAccessibleStateSet();
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessibleContext);
        if (role == 12) {
            w = new Dialog((java.awt.Frame)new Application(), xAccessibleContext.getAccessibleName(), xAccessibleStateSet.contains((short)16), xAccessibleComponent);
        } else if (role == 1) {
            w = new Alert((java.awt.Frame)new Application(), xAccessibleContext.getAccessibleName(), xAccessibleStateSet.contains((short)16), xAccessibleComponent);
        } else if (role == 21) {
            w = new Frame(xAccessibleContext.getAccessibleName(), xAccessibleComponent);
        } else {
            if (role != 67) {
                System.err.println("invalid role for toplevel window: " + role);
                return null;
            }
            java.awt.Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (activeWindow == null) {
                System.err.println("no active frame found for Window: " + role);
                return null;
            }
            w = new Window(activeWindow, xAccessibleComponent);
        }
        AccessibleObjectFactory.populateContainer(w, xAccessibleContext, w);
        w.setFocusTraversalPolicy(focusTraversalPolicy);
        w.setVisible(true);
        Component c = ((NativeFrame)((Object)w)).getInitialComponent();
        if (c != null) {
            AccessibleObjectFactory.postWindowGainedFocus(w);
        }
        return w;
    }
}

