/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import java.awt.Component;
import java.awt.Window;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import org.openoffice.java.accessibility.AccessibleExtendedState;

public class AccessibleStateAdapter {
    private static final AccessibleState[] stateTypeMap = new AccessibleState[]{null, AccessibleState.ACTIVE, AccessibleState.ARMED, AccessibleState.BUSY, AccessibleState.CHECKED, AccessibleExtendedState.DEFUNCT, AccessibleState.EDITABLE, AccessibleState.ENABLED, AccessibleState.EXPANDABLE, AccessibleState.EXPANDED, AccessibleState.FOCUSABLE, AccessibleState.FOCUSED, AccessibleState.HORIZONTAL, AccessibleState.ICONIFIED, AccessibleExtendedState.INDETERMINATE, AccessibleExtendedState.MANAGES_DESCENDANTS, AccessibleState.MODAL, AccessibleState.MULTI_LINE, AccessibleState.MULTISELECTABLE, AccessibleState.OPAQUE, AccessibleState.PRESSED, AccessibleState.RESIZABLE, AccessibleState.SELECTABLE, AccessibleState.SELECTED, AccessibleExtendedState.SENSITIVE, AccessibleState.SHOWING, AccessibleState.SINGLE_LINE, AccessibleExtendedState.STALE, AccessibleState.TRANSIENT, AccessibleState.VERTICAL, AccessibleState.VISIBLE};

    private static void printToplevelStateMessage(AccessibleState s, Component c) {
        System.err.println("*** ERROR *** " + s + " state is a toplevel window state " + c);
    }

    private static String getDisplayName(Component c) {
        Accessible a = (Accessible)((Object)c);
        if (a != null) {
            AccessibleContext ac = a.getAccessibleContext();
            return "[" + ac.getAccessibleRole() + "] " + ac.getAccessibleName();
        }
        return c.toString();
    }

    private static void printOutOfSyncMessage(AccessibleState s, Component c, boolean enabled) {
        System.err.println("*** ERROR *** " + s + " state out of sync (UNO state set: " + !enabled + ", Java component state: " + enabled + ") for " + AccessibleStateAdapter.getDisplayName(c));
    }

    public static AccessibleState getAccessibleState(Object any) {
        try {
            if (AnyConverter.isShort((Object)any)) {
                return AccessibleStateAdapter.getAccessibleState(AnyConverter.toShort((Object)any));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static AccessibleState getAccessibleState(short unoStateType) {
        if (unoStateType > 0 && unoStateType < stateTypeMap.length) {
            return stateTypeMap[unoStateType];
        }
        return null;
    }

    public static AccessibleStateSet getDefunctStateSet() {
        AccessibleStateSet ass = new AccessibleStateSet();
        ass.add(AccessibleExtendedState.DEFUNCT);
        return ass;
    }

    public static void setComponentState(Component c, XAccessibleStateSet xAccessibleStateSet) {
        try {
            if (xAccessibleStateSet != null) {
                if (!xAccessibleStateSet.contains((short)30)) {
                    c.setVisible(false);
                }
                if (!xAccessibleStateSet.contains((short)7)) {
                    c.setEnabled(false);
                }
                if (!xAccessibleStateSet.contains((short)10)) {
                    c.setFocusable(false);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static AccessibleStateSet getAccessibleStateSet(Component c, XAccessibleStateSet xAccessibleStateSet) {
        try {
            if (xAccessibleStateSet != null) {
                boolean isActiveInSync;
                boolean isFocusInSync;
                AccessibleStateSet as = new AccessibleStateSet();
                short[] unoStateTypes = xAccessibleStateSet.getStates();
                for (int i = 0; i < unoStateTypes.length; ++i) {
                    if (unoStateTypes[i] <= 0 || unoStateTypes[i] >= stateTypeMap.length) continue;
                    as.add(stateTypeMap[unoStateTypes[i]]);
                }
                if (as.contains(AccessibleState.EXPANDABLE) && !as.contains(AccessibleState.EXPANDED)) {
                    as.add(AccessibleState.COLLAPSED);
                }
                if (c.isFocusOwner()) {
                    isFocusInSync = !as.add(AccessibleState.FOCUSED);
                } else {
                    boolean bl = isFocusInSync = !as.remove(AccessibleState.FOCUSED);
                }
                if (c instanceof Window && ((Window)c).isActive()) {
                    isActiveInSync = !as.add(AccessibleState.ACTIVE);
                } else {
                    boolean bl = isActiveInSync = !as.remove(AccessibleState.ACTIVE);
                }
                if (!isFocusInSync) {
                    AccessibleStateAdapter.printOutOfSyncMessage(AccessibleState.FOCUSED, c, c.isFocusOwner());
                }
                if (!isActiveInSync) {
                    AccessibleStateAdapter.printOutOfSyncMessage(AccessibleState.ACTIVE, c, ((Window)c).isActive());
                }
                if (as.contains(AccessibleState.ENABLED) != c.isEnabled()) {
                    AccessibleStateAdapter.printOutOfSyncMessage(AccessibleState.ENABLED, c, c.isEnabled());
                }
                if (as.contains(AccessibleState.FOCUSABLE) != c.isFocusable()) {
                    AccessibleStateAdapter.printOutOfSyncMessage(AccessibleState.FOCUSABLE, c, c.isFocusable());
                }
                if (as.contains(AccessibleState.SHOWING) != c.isShowing()) {
                    AccessibleStateAdapter.printOutOfSyncMessage(AccessibleState.SHOWING, c, c.isShowing());
                }
                if (as.contains(AccessibleState.VISIBLE) != c.isVisible()) {
                    AccessibleStateAdapter.printOutOfSyncMessage(AccessibleState.VISIBLE, c, c.isVisible());
                }
                if (!(c instanceof Window)) {
                    if (as.contains(AccessibleState.ACTIVE)) {
                        AccessibleStateAdapter.printToplevelStateMessage(AccessibleState.ACTIVE, c);
                    }
                    if (as.contains(AccessibleState.ICONIFIED)) {
                        AccessibleStateAdapter.printToplevelStateMessage(AccessibleState.ICONIFIED, c);
                    }
                    if (as.contains(AccessibleState.MODAL)) {
                        AccessibleStateAdapter.printToplevelStateMessage(AccessibleState.MODAL, c);
                    }
                }
                return as;
            }
            return null;
        }
        catch (RuntimeException e) {
            return AccessibleStateAdapter.getDefunctStateSet();
        }
    }
}

