/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.TextSegment;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.FontSlant;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.style.LineSpacing;
import com.sun.star.style.ParagraphAdjust;
import com.sun.star.style.TabAlign;
import com.sun.star.style.TabStop;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.awt.Color;
import java.text.BreakIterator;
import java.util.Arrays;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import org.openoffice.java.accessibility.logging.XAccessibleTextLog;

public class AccessibleTextImpl
implements AccessibleText {
    static final double toPointFactor = 0.028985507246376812;
    static final String[] attributeList = new String[]{"ParaAdjust", "CharBackColor", "CharWeight", "ParaFirstLineIndent", "CharFontName", "CharHeight", "CharColor", "CharPosture", "ParaLeftMargin", "ParaLineSpacing", "ParaTopMargin", "ParaBottomMargin", "CharStrikeout", "CharEscapement", "ParaTabStops", "CharUnderline"};
    static final String[] localeAttributeList = new String[]{"CharLocale", "CharLocaleAsian", "CharLocaleComplex"};
    XAccessibleText unoObject;
    private TabSet tabSet = null;
    private javax.swing.text.TabStop[] tabStops = null;
    private static Type TextSegmentType = new Type(TextSegment.class);
    private static Type UnoLocaleType = new Type(Locale.class);

    public AccessibleTextImpl(XAccessibleText xAccessibleText) {
        String property = System.getProperty("AccessBridgeLogging");
        this.unoObject = property != null && property.indexOf("text") != -1 ? new XAccessibleTextLog(xAccessibleText) : xAccessibleText;
    }

    public AccessibleTextImpl() {
    }

    public static AccessibleText get(XInterface unoObject) {
        try {
            XAccessibleText unoAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)unoObject);
            if (unoAccessibleText != null) {
                return new AccessibleTextImpl(unoAccessibleText);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    protected static Object convertTextSegment(Object any) {
        try {
            TextSegment ts;
            if (AnyConverter.isObject((Object)any) && (ts = (TextSegment)AnyConverter.toObject((Type)TextSegmentType, (Object)any)) != null) {
                Object[] array = new Object[]{new Integer(ts.SegmentStart), new Integer(ts.SegmentEnd), ts.SegmentText};
                return array;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    protected java.util.Locale getLocale(int index) {
        try {
            PropertyValue[] propertyValues = this.unoObject.getCharacterAttributes(index, localeAttributeList);
            if (null != propertyValues) {
                for (int i = 0; i < propertyValues.length; ++i) {
                    Locale unoLocale = (Locale)AnyConverter.toObject((Type)UnoLocaleType, (Object)propertyValues[i]);
                    if (unoLocale == null) continue;
                    return new java.util.Locale(unoLocale.Language, unoLocale.Country);
                }
            }
            return java.util.Locale.getDefault();
        }
        catch (IllegalArgumentException e) {
            return java.util.Locale.getDefault();
        }
        catch (IndexOutOfBoundsException e) {
            return java.util.Locale.getDefault();
        }
    }

    public String getAfterIndex(int part, int index) {
        switch (part) {
            case 1: {
                try {
                    String s = this.unoObject.getText();
                    return s.substring(index + 1, index + 2);
                }
                catch (java.lang.IndexOutOfBoundsException e) {
                    return null;
                }
            }
            case 2: {
                try {
                    String s = this.unoObject.getText();
                    BreakIterator words = BreakIterator.getWordInstance(this.getLocale(index));
                    words.setText(s);
                    int start = words.following(index);
                    if (start == -1 || start >= s.length()) {
                        return null;
                    }
                    int end = words.following(start);
                    if (end == -1 || end >= s.length()) {
                        return null;
                    }
                    return s.substring(start, end);
                }
                catch (java.lang.IllegalArgumentException e) {
                    return null;
                }
                catch (java.lang.IndexOutOfBoundsException e) {
                    return null;
                }
            }
            case 3: {
                try {
                    String s = this.unoObject.getText();
                    BreakIterator sentence = BreakIterator.getSentenceInstance(this.getLocale(index));
                    sentence.setText(s);
                    int start = sentence.following(index);
                    if (start == -1 || start >= s.length()) {
                        return null;
                    }
                    int end = sentence.following(start);
                    if (end == -1 || end >= s.length()) {
                        return null;
                    }
                    return s.substring(start, end);
                }
                catch (java.lang.IllegalArgumentException e) {
                    return null;
                }
                catch (java.lang.IndexOutOfBoundsException e) {
                    return null;
                }
            }
            case 4: {
                try {
                    TextSegment ts = this.unoObject.getTextBehindIndex(index, (short)5);
                    return ts.SegmentText;
                }
                catch (IndexOutOfBoundsException e) {
                    if (index > 0 && this.getCharCount() == index) {
                        return this.getAfterIndex(part, index - 1);
                    }
                    return null;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            case 5: {
                try {
                    TextSegment ts = this.unoObject.getTextBehindIndex(index, (short)7);
                    return ts.SegmentText;
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public int getCaretPosition() {
        try {
            return this.unoObject.getCaretPosition();
        }
        catch (RuntimeException e) {
            return -1;
        }
    }

    public int getSelectionStart() {
        try {
            int index = this.unoObject.getSelectionStart();
            if (index == -1) {
                index = this.getCaretPosition();
            }
            return index;
        }
        catch (RuntimeException e) {
            return -1;
        }
    }

    protected void setAttribute(MutableAttributeSet as, PropertyValue property) {
        try {
            if (property.Name.equals("ParaAdjust")) {
                ParagraphAdjust adjust = null;
                adjust = property.Value instanceof ParagraphAdjust ? (ParagraphAdjust)property.Value : (property.Value instanceof Any ? (ParagraphAdjust)AnyConverter.toObject((Type)new Type(ParagraphAdjust.class), (Object)property.Value) : ParagraphAdjust.fromInt((int)AnyConverter.toInt((Object)property.Value)));
                if (adjust != null) {
                    if (adjust.equals(ParagraphAdjust.LEFT)) {
                        StyleConstants.setAlignment(as, 0);
                    } else if (adjust.equals(ParagraphAdjust.RIGHT)) {
                        StyleConstants.setAlignment(as, 2);
                    } else if (adjust.equals(ParagraphAdjust.CENTER)) {
                        StyleConstants.setAlignment(as, 1);
                    } else if (adjust.equals(ParagraphAdjust.BLOCK) || adjust.equals(ParagraphAdjust.STRETCH)) {
                        StyleConstants.setAlignment(as, 3);
                    }
                } else {
                    System.err.println("Invalid property value for key ParaAdjust: " + property.Value.getClass().getName());
                }
            } else if (property.Name.equals("CharBackColor")) {
                StyleConstants.setBackground(as, new Color(AnyConverter.toInt((Object)property.Value)));
            } else if (property.Name.equals("CharWeight")) {
                boolean isBold = AnyConverter.toFloat((Object)property.Value) > 125.0f;
                StyleConstants.setBold(as, isBold);
            } else if (property.Name.equals("ParaFirstLineIndent")) {
                StyleConstants.setFirstLineIndent(as, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)property.Value)));
            } else if (property.Name.equals("CharFontName")) {
                StyleConstants.setFontFamily(as, AnyConverter.toString((Object)property.Value));
            } else if (property.Name.equals("CharHeight")) {
                StyleConstants.setFontSize(as, (int)AnyConverter.toFloat((Object)property.Value));
            } else if (property.Name.equals("CharColor")) {
                StyleConstants.setForeground(as, new Color(AnyConverter.toInt((Object)property.Value)));
            } else if (property.Name.equals("CharPosture")) {
                FontSlant fs = null;
                if (property.Value instanceof FontSlant) {
                    fs = (FontSlant)property.Value;
                } else if (property.Value instanceof Any) {
                    fs = (FontSlant)AnyConverter.toObject((Type)new Type(FontSlant.class), (Object)property.Value);
                }
                if (fs != null) {
                    StyleConstants.setItalic(as, FontSlant.ITALIC.equals(fs));
                }
            } else if (property.Name.equals("ParaLeftMargin")) {
                StyleConstants.setLeftIndent(as, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)property.Value)));
            } else if (property.Name.equals("ParaRightMargin")) {
                StyleConstants.setRightIndent(as, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)property.Value)));
            } else if (property.Name.equals("ParaLineSpacing")) {
                LineSpacing ls = null;
                if (property.Value instanceof LineSpacing) {
                    ls = (LineSpacing)property.Value;
                } else if (property.Value instanceof Any) {
                    ls = (LineSpacing)AnyConverter.toObject((Type)new Type(LineSpacing.class), (Object)property.Value);
                }
                if (ls != null) {
                    StyleConstants.setLineSpacing(as, (float)(0.028985507246376812 * (double)ls.Height));
                }
            } else if (property.Name.equals("ParaTopMargin")) {
                StyleConstants.setSpaceAbove(as, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)property.Value)));
            } else if (property.Name.equals("ParaBottomMargin")) {
                StyleConstants.setSpaceBelow(as, (float)(0.028985507246376812 * (double)AnyConverter.toInt((Object)property.Value)));
            } else if (property.Name.equals("CharStrikeout")) {
                boolean isStrikeThrough = 0 != AnyConverter.toShort((Object)property.Value);
                StyleConstants.setStrikeThrough(as, isStrikeThrough);
            } else if (property.Name.equals("CharEscapement")) {
                short value = AnyConverter.toShort((Object)property.Value);
                if (value > 0) {
                    StyleConstants.setSuperscript(as, true);
                } else if (value < 0) {
                    StyleConstants.setSubscript(as, true);
                }
            } else if (property.Name.equals("ParaTabStops")) {
                TabStop[] unoTabStops = (TabStop[])AnyConverter.toArray((Object)property.Value);
                Object[] tabStops = new javax.swing.text.TabStop[unoTabStops.length];
                for (int index2 = 0; index2 < unoTabStops.length; ++index2) {
                    float pos = (float)(0.028985507246376812 * (double)unoTabStops[index2].Position);
                    tabStops[index2] = unoTabStops[index2].Alignment.equals(TabAlign.LEFT) ? new javax.swing.text.TabStop(pos, 0, 0) : (unoTabStops[index2].Alignment.equals(TabAlign.CENTER) ? new javax.swing.text.TabStop(pos, 2, 0) : (unoTabStops[index2].Alignment.equals(TabAlign.RIGHT) ? new javax.swing.text.TabStop(pos, 1, 0) : (unoTabStops[index2].Alignment.equals(TabAlign.DECIMAL) ? new javax.swing.text.TabStop(pos, 4, 0) : new javax.swing.text.TabStop(pos))));
                }
                if (this.tabSet == null || !Arrays.equals(tabStops, this.tabStops)) {
                    this.tabStops = tabStops;
                    this.tabSet = new TabSet((javax.swing.text.TabStop[])tabStops);
                }
                StyleConstants.setTabSet(as, this.tabSet);
            } else if (property.Name.equals("CharUnderline")) {
                boolean isUnderline = 0 != AnyConverter.toShort((Object)property.Value);
                StyleConstants.setUnderline(as, isUnderline);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("*** ERROR *** " + ((Object)((Object)e)).getClass().getName() + " caught for property " + property.Name + ": " + e.getMessage());
            System.err.println("              value is of type " + property.Value.getClass().getName());
        }
    }

    public AttributeSet getCharacterAttribute(int index) {
        try {
            PropertyValue[] propertyValues = this.unoObject.getCharacterAttributes(index, attributeList);
            SimpleAttributeSet attributeSet = new SimpleAttributeSet();
            if (null != propertyValues) {
                for (int i = 0; i < propertyValues.length; ++i) {
                    this.setAttribute(attributeSet, propertyValues[i]);
                }
            }
            return attributeSet;
        }
        catch (IndexOutOfBoundsException e) {
            if (index > 0 && this.getCharCount() == index) {
                return this.getCharacterAttribute(index - 1);
            }
            return null;
        }
    }

    public int getIndexAtPoint(java.awt.Point point) {
        try {
            return this.unoObject.getIndexAtPoint(new Point(point.x, point.y));
        }
        catch (RuntimeException e) {
            return -1;
        }
    }

    public int getSelectionEnd() {
        try {
            int index = this.unoObject.getSelectionEnd();
            if (index == -1) {
                index = this.getCaretPosition();
            }
            return index;
        }
        catch (RuntimeException e) {
            return -1;
        }
    }

    public String getBeforeIndex(int part, int index) {
        switch (part) {
            case 1: {
                try {
                    String s = this.unoObject.getText();
                    return s.substring(index - 1, index);
                }
                catch (java.lang.IndexOutOfBoundsException e) {
                    return null;
                }
            }
            case 2: {
                try {
                    String s = this.unoObject.getText();
                    BreakIterator words = BreakIterator.getWordInstance(this.getLocale(index));
                    words.setText(s);
                    int end = words.following(index);
                    end = words.previous();
                    int start = words.previous();
                    if (start == -1) {
                        return null;
                    }
                    return s.substring(start, end);
                }
                catch (java.lang.IllegalArgumentException e) {
                    return null;
                }
                catch (java.lang.IndexOutOfBoundsException e) {
                    return null;
                }
            }
            case 3: {
                try {
                    String s = this.unoObject.getText();
                    BreakIterator sentence = BreakIterator.getSentenceInstance(this.getLocale(index));
                    sentence.setText(s);
                    int end = sentence.following(index);
                    end = sentence.previous();
                    int start = sentence.previous();
                    if (start == -1) {
                        return null;
                    }
                    return s.substring(start, end);
                }
                catch (java.lang.IllegalArgumentException e) {
                    return null;
                }
                catch (java.lang.IndexOutOfBoundsException e) {
                    return null;
                }
            }
            case 4: {
                try {
                    TextSegment ts = this.unoObject.getTextBeforeIndex(index, (short)5);
                    return ts.SegmentText;
                }
                catch (IndexOutOfBoundsException e) {
                    if (index > 0 && this.getCharCount() == index) {
                        return this.getBeforeIndex(part, index - 1);
                    }
                    return null;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            case 5: {
                try {
                    TextSegment ts = this.unoObject.getTextBeforeIndex(index, (short)7);
                    return ts.SegmentText;
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public String getAtIndex(int part, int index) {
        switch (part) {
            case 1: {
                try {
                    String s = this.unoObject.getText();
                    return s.substring(index, index + 1);
                }
                catch (java.lang.IndexOutOfBoundsException e) {
                    return null;
                }
            }
            case 2: {
                try {
                    String s = this.unoObject.getText();
                    BreakIterator words = BreakIterator.getWordInstance(this.getLocale(index));
                    words.setText(s);
                    int end = words.following(index);
                    return s.substring(words.previous(), end);
                }
                catch (java.lang.IllegalArgumentException e) {
                    return null;
                }
                catch (java.lang.IndexOutOfBoundsException e) {
                    return null;
                }
            }
            case 3: {
                try {
                    String s = this.unoObject.getText();
                    BreakIterator sentence = BreakIterator.getSentenceInstance(this.getLocale(index));
                    sentence.setText(s);
                    int end = sentence.following(index);
                    return s.substring(sentence.previous(), end);
                }
                catch (java.lang.IllegalArgumentException e) {
                    return null;
                }
                catch (java.lang.IndexOutOfBoundsException e) {
                    return null;
                }
            }
            case 4: {
                try {
                    TextSegment ts = this.unoObject.getTextAtIndex(index, (short)5);
                    return ts.SegmentText;
                }
                catch (IndexOutOfBoundsException e) {
                    if (index > 0 && this.getCharCount() == index) {
                        return this.getAtIndex(part, index - 1);
                    }
                    return null;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            case 5: {
                try {
                    TextSegment ts = this.unoObject.getTextAtIndex(index, (short)7);
                    return ts.SegmentText;
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public int getCharCount() {
        try {
            return this.unoObject.getCharacterCount();
        }
        catch (RuntimeException runtimeException) {
            return 0;
        }
    }

    public String getSelectedText() {
        try {
            return this.unoObject.getSelectedText();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public java.awt.Rectangle getCharacterBounds(int index) {
        try {
            Rectangle unoRect = this.unoObject.getCharacterBounds(index);
            return new java.awt.Rectangle(unoRect.X, unoRect.Y, unoRect.Width, unoRect.Height);
        }
        catch (IndexOutOfBoundsException e) {
            if (index > 0 && this.getCharCount() == index) {
                return this.getCharacterBounds(index - 1);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return new java.awt.Rectangle();
    }
}

